<?php

/**
*
* @package WordPress
* @subpackage softing
* @since softing 1.0
*
**/

define('SOFTING_DIRECTORY_URI', get_template_directory_uri());
define('SOFTING_DIRECTORY', get_template_directory());

/*************************************************
## GOOGLE FONTS
*************************************************/

if ( ! function_exists( 'softing_fonts_url' ) ) {
    function softing_fonts_url() {
        $fonts_url = '';

        $opensans = _x( 'on', 'Open+Sans font: on or off', 'softing' );
        $poppins = _x( 'on', 'Poppins font: on or off', 'softing' );


        if ( 'off' !== $opensans OR 'off' !== $poppins ) {
            $font_families = array();

            if ( 'off' !== $opensans )
            $font_families[] = 'Open+Sans';

            if ( 'off' !== $poppins )
            $font_families[] = 'Poppins:400,500,600,700,800';

            $query_args = array(
                'family' => urlencode( implode( '|', $font_families ) ),
                'subset' => urlencode( 'latin,latin-ext' ),
            );

            $fonts_url = add_query_arg( $query_args, "//fonts.googleapis.com/css" );
        }
        return $fonts_url;
    }
}

/*************************************************
## STYLES AND SCRIPTS
*************************************************/


function softing_theme_scripts() {
    $rtl = is_rtl() ? '-rtl' : '';
    // ## CSS
    // font families
    wp_enqueue_style( 'ionicon',SOFTING_DIRECTORY_URI . '/css/ionicons.min.css',false, '1.0');
    wp_enqueue_style( 'flaticon',SOFTING_DIRECTORY_URI . '/css/flaticon.css',false, '1.0');
    wp_enqueue_style( 'flaticon-set',SOFTING_DIRECTORY_URI . '/css/flaticon-set.css',false, '1.0');
    wp_enqueue_style( 'fontawesome',SOFTING_DIRECTORY_URI . '/css/font-awesome.min.css',false, '1.0');

    // theme inner pages files
    wp_enqueue_style( 'bootstrap',SOFTING_DIRECTORY_URI . '/css/bootstrap'.$rtl.'.min.css',false, '1.0'); //Bootstrap
    wp_enqueue_style( 'softing-general-style',SOFTING_DIRECTORY_URI . '/css/framework-style'.$rtl.'.css',false, '1.0');
    wp_enqueue_style( 'nice-select',SOFTING_DIRECTORY_URI . '/css/nice-select.css',false, '1.0');

    // upload Google Webfonts
    wp_enqueue_style( 'softing-fonts',softing_fonts_url(), array(), '1.0' );

    // SOFTING CSS FILES
    wp_enqueue_style( 'owl-carousel',SOFTING_DIRECTORY_URI . '/css/owl.carousel.min.css',false, '1.0');
    wp_enqueue_style( 'owl-default',SOFTING_DIRECTORY_URI . '/css/owl.theme.default.min.css',false, '1.0');
    wp_enqueue_style( 'animate',SOFTING_DIRECTORY_URI . '/css/animate.css',false, '1.0');
    wp_register_style( 'magnific',SOFTING_DIRECTORY_URI . '/css/magnific-popup.css',false, '1.0');
    wp_enqueue_style( 'bootsnav',SOFTING_DIRECTORY_URI . '/css/bootsnav'.$rtl.'.css',false, '1.0');
    wp_enqueue_style( 'softing-style',SOFTING_DIRECTORY_URI . '/css/style'.$rtl.'.css',false, '1.0');
    wp_enqueue_style( 'softing-responsive',SOFTING_DIRECTORY_URI . '/css/responsive'.$rtl.'.css',false, '1.0');
    wp_enqueue_style( 'softing-update',SOFTING_DIRECTORY_URI . '/css/softing-update'.$rtl.'.css',false, '1.0');

    // JS FILES
    // bootstrap
    wp_enqueue_script('bootstrap',SOFTING_DIRECTORY_URI . '/js/bootstrap.min.js',array('jquery'), '1.0', true);

    // equal-height
    wp_enqueue_script('equal-height',SOFTING_DIRECTORY_URI . '/js/equal-height.min.js',array('jquery'), '1.0', true);
    wp_enqueue_script('equal-height-custom',SOFTING_DIRECTORY_URI . '/js/custom/equal-height-custom.js',array('jquery'), '1.0', true);

    // appear
    wp_register_script('appear',SOFTING_DIRECTORY_URI . '/js/jquery.appear.js',array('jquery'), '1.0', true);
    wp_register_script('easing',SOFTING_DIRECTORY_URI . '/js/jquery.easing.min.js',array('jquery'), '1.0', true);

    // owl-carousel
    wp_register_script('owl-carousel',SOFTING_DIRECTORY_URI . '/js/owl.carousel.min.js',array('jquery'), '1.0', true);
    wp_register_script('carousel-custom',SOFTING_DIRECTORY_URI . '/js/custom/carousel-custom.js',array('jquery'), '1.0', true);

    // magnificpopup lightbox
    wp_register_script('magnific',SOFTING_DIRECTORY_URI . '/js/jquery.magnific-popup.min.js',array('jquery'), '1.0', true);
    wp_register_script('magnific-custom',SOFTING_DIRECTORY_URI . '/js/custom/magnific-custom.js',array('jquery'), '1.0', true);

    // modernizr.custom
    wp_register_script('modernizr',SOFTING_DIRECTORY_URI . '/js/modernizr.custom.13711.js',array('jquery'), '1.0', true);

    //wow for animate css
    wp_register_script('wow',SOFTING_DIRECTORY_URI . '/js/wow.min.js',array('jquery'), '1.0', true);
    wp_register_script('animate-custom',SOFTING_DIRECTORY_URI . '/js/custom/animate-custom.js',array('jquery'), '1.0', true);

    // scrollUp
    wp_register_script('scrollUp',SOFTING_DIRECTORY_URI . '/js/jquery.scrollUp.min.js',array('jquery'), '1.0', true);
    wp_register_script('scrollup-custom',SOFTING_DIRECTORY_URI . '/js/custom/scrollup-custom.js',array('jquery'), '1.0', true);

    // bootsnav
    wp_enqueue_script('bootsnav',SOFTING_DIRECTORY_URI . '/js/bootsnav.js',array('jquery'), '1.0', true);

    // smoothscroll
    wp_enqueue_script('smoothscroll',SOFTING_DIRECTORY_URI . '/js/smooth-scroll.min.js',array('jquery'), '1.0', true);
    wp_enqueue_script('smoothscroll-custom',SOFTING_DIRECTORY_URI . '/js/custom/smoothscroll-custom.js',array('jquery'), '1.0', true);

    // theme inner page files
    wp_enqueue_script('softing-js-settings',SOFTING_DIRECTORY_URI . '/js/framework-settings.js',array('jquery'), '1.0', true);
    wp_register_script('jarallax',SOFTING_DIRECTORY_URI . '/js/jarallax.min.js',array('jquery'), '1.0', true);
    wp_enqueue_script('nice-select',SOFTING_DIRECTORY_URI . '/js/jquery.nice-select.min.js',array('jquery'), '1.0', true);

    // comment form reply
    if ( is_singular() ) wp_enqueue_script( 'comment-reply' );

}
add_action( 'wp_enqueue_scripts', 'softing_theme_scripts' );


/*************************************************
## ADMIN STYLE AND SCRIPTS
*************************************************/
if ( ! function_exists( 'softing_admin_scripts' ) ) {
    function softing_admin_scripts()
    {
        // Update CSS within in Admin
        wp_enqueue_script('softing-custom-admin',SOFTING_DIRECTORY_URI . '/js/framework-admin.js');
    }
    add_action('admin_enqueue_scripts', 'softing_admin_scripts');
}


/*************************************************
## THEME OPTION & METABOXES & SHORTCODES
*************************************************/

// Check Metabox Plugin Activation
if ( ! function_exists( 'rwmb_meta' ) ) {
    function rwmb_meta( $key, $args = '', $post_id = null ) {
        return false;
    }
}


function softing_settings( $opt_id, $def_value='' )
{
    global $softing;

    $defval = '' != $def_value ? $def_value : false;
    $opt_id = trim($opt_id);
    $opt    = isset($softing[$opt_id]) ? $softing[$opt_id] : $defval;

    return $opt;
}


/*************************************************
## EXCERPT FILTER AND EXCERPT LIMIT
*************************************************/

// content excerpt more
if ( ! function_exists( 'softing_custom_excerpt_more' ) ) {
    function softing_custom_excerpt_more( $more ) {
        return '...';
    }
    add_filter( 'excerpt_more', 'softing_custom_excerpt_more' );
}


// custom excerpt
if ( ! function_exists( 'softing_excerpt_limit' ) ) {
    function softing_excerpt_limit( $limit ) {

        $excerpt = explode( ' ', get_the_excerpt(), $limit );

        if ( count( $excerpt ) >= $limit ) {
            array_pop( $excerpt );
            $excerpt = implode( " ", $excerpt ) . '...';
        } else {
            $excerpt = implode( " ", $excerpt );
        }

        $excerpt = preg_replace( '`\[[^\]]*\]`', '', $excerpt );

        return $excerpt;
    }
}

/*************************************************
## THEME SETUP
*************************************************/

if ( ! isset( $content_width ) ) $content_width = 960;

function softing_theme_setup() {

    // Add default posts and comments RSS feed links to head.
    add_theme_support( 'automatic-feed-links' );

    /*
    * Enable support for Post Formats.
    *
    * See: https://codex.wordpress.org/Post_Formats
    */
    add_theme_support( 'post-formats', array(
        'video',
        'audio',
        'gallery'
    ) );

    /*
    * Enable support for Post Thumbnails on posts and pages.
    *
    * See: https://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
    */
    add_theme_support( 'post-thumbnails' );

    // custom thumbnail image sizes
    add_image_size( 'softing-120-hard', 120, 120, true ); // Hard Crop Mode
    add_image_size( 'softing-120-soft', 120, 120 ); // Soft Crop Mode
    add_image_size( 'softing-240-hard', 240, 240, true ); // Hard Crop Mode
    add_image_size( 'softing-240-soft', 240, 240 ); // Soft Crop Mode
    add_image_size( 'softing-360-hard', 360, 360, true ); // Hard Crop Mode
    add_image_size( 'softing-360-soft', 360, 360 ); // Soft Crop Mode
    add_image_size( 'softing-480-hard', 480, 480, true ); // Hard Crop Mode
    add_image_size( 'softing-480-soft', 480, 480 ); // Soft Crop Mode
    add_image_size( 'softing-750-hard', 750, 450, true ); // Hard Crop Mode
    add_image_size( 'softing-820-hard', 820, 820, true ); // Hard Crop Mode
    add_image_size( 'softing-820-soft', 820, 820 ); // Soft Crop Mode
    add_image_size( 'softing-1040-hard', 1040, 1040, true ); // Hard Crop Mode
    add_image_size( 'softing-1040-soft', 1040, 1040 ); // Soft Crop Mode
    add_image_size( 'softing-1040-hard', 1040, 1040, true ); // Hard Crop Mode
    add_image_size( 'softing-1040-soft', 1040, 1040 ); // Soft Crop Mode

    // theme supports
    add_theme_support( 'title-tag' );
    add_theme_support( 'custom-background' );
    add_theme_support( 'custom-header' );
    add_theme_support( 'html5', array( 'search-form' ) );
    remove_theme_support( 'widgets-block-editor' );
    add_filter( 'use_widgets_block_editor', '__return_false' );
    add_filter('use_block_editor_for_post', '__return_false', 10);
    add_filter('use_block_editor_for_page', '__return_false', 10);
    // Make theme available for translation
    // Translations can be filed in the /languages/ directory
    load_theme_textdomain( 'softing', SOFTING_DIRECTORY . '/languages' );

    // Redux theme options panel
    include SOFTING_DIRECTORY . '/inc/theme-options/options.php';

    // Check Visual Composer Activation
    if ( function_exists( 'vc_set_as_theme' ) ) {

        require_once SOFTING_DIRECTORY . '/vc_templates/framework-parts/vc-custom-settings.php';

        vc_set_as_theme( $disable_updater = false );
        vc_is_updater_disabled();
    }
    // Theme post and page meta plugin for customization and more features
    include SOFTING_DIRECTORY . '/inc/metaboxes.php';

    // Theme css settings file
    include SOFTING_DIRECTORY . '/inc/custom-style.php';

    if ( is_admin() ) {
        require_once get_parent_theme_file_path( '/inc/merlin/admin-menu.php' );
        require_once get_parent_theme_file_path( '/inc/merlin/class-merlin.php' );
        require_once get_parent_theme_file_path( '/inc/demo-wizard-config.php' );
    }

    include SOFTING_DIRECTORY . '/inc/template-parts/breadcrumbs.php';
    include SOFTING_DIRECTORY . '/inc/template-parts/comment-parts.php';
    include SOFTING_DIRECTORY . '/inc/template-parts/page-hero.php';
    include SOFTING_DIRECTORY . '/inc/template-parts/paginations.php';
    include SOFTING_DIRECTORY . '/inc/template-parts/post-formats.php';
    include SOFTING_DIRECTORY . '/inc/template-parts/small-parts.php';

    // WooCommerce init
    if ( class_exists('woocommerce') ) {
        add_theme_support( 'woocommerce' );
        include SOFTING_DIRECTORY . '/woocommerce/init.php';
    }

    register_nav_menus( array(
        'header_menu_1'  => esc_html__( 'Header Menu 1', 'softing' ),
        'footer_menu'  => esc_html__( 'Footer Menu', 'softing' ),
    ));
}
add_action( 'after_setup_theme', 'softing_theme_setup' );

/*************************************************
## WIDGET COLUMNS
*************************************************/

if ( ! function_exists( 'softing_widgets_init' ) ) {
    function softing_widgets_init()
    {
        register_sidebar( array(
            'name'          => esc_html__( 'Blog Sidebar', 'softing' ),
            'id'            => 'sidebar-1',
            'description'   => esc_html__( 'These widgets for the Blog page.','softing' ),
            'before_widget' => '<div class="sidebar sidebar-widget widget mb-30 %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>'
        ) );

        register_sidebar( array(
            'name'          => esc_html__( 'Blog Single Sidebar', 'softing' ),
            'id'            => 'softing-single-sidebar',
            'description'   => esc_html__( 'These widgets for the Blog single page.','softing' ),
            'before_widget' => '<div class="sidebar sidebar-widget widget mb-30 %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>'
        ) );

        //widgetize footer display. default is off
        $softing = get_option('softing');

        $fw  = isset($softing[ 'footer_widgetize_onoff' ]) ? $softing[ 'footer_widgetize_onoff' ] : '';
        $d_w = isset($softing[ 'default_widgets' ]) ? $softing[ 'default_widgets' ] : '';
        $c_w = isset($softing[ 'custom_widgets' ]) ? $softing[ 'custom_widgets' ] : '';

        if ( '1' == $fw ) {

            // widgetize footer column and display settings
            $sidebars_d = array (
                'softing-footer-widget-1' => 'Footer default widget-1',
                'softing-footer-widget-2' => 'Footer default widget-2',
                'softing-footer-widget-3' => 'Footer default widget-3',
                'softing-footer-widget-4' => 'Footer default widget-4'
            );

            // default register footer widgets for the footer widget area section
            if ( '0' != $d_w ) {
                foreach ( $sidebars_d as $id => $sidebar) {
                    register_sidebar( array(
                        'name'          => sprintf( esc_html__( '%s', 'softing' ), $sidebar ),
                        'description'   => esc_html__( 'You can hide/show default footer widgets area from Theme Options > Footer > Footer Widgetize', 'softing' ),
                        'id'            => $id,
                        'before_widget' => '<div class="col-lg-3 col-md-3 col-sm-6 equal-height item footer-widget"><div class="f-item link footer-widget %2$s">',
                        'after_widget'  => '</div></div>',
                        'before_title'  => '<h4 class="footer-widget-title">',
                        'after_title'   => '</h4>'
                    ) );
                }
            }

            // custom register footer widgets from theme optipons panel
            if ( $c_w ) {
                for ( $i=0;  $i <= (count( $c_w )-1); $i++ ) {
                    $column = $c_w[$i];
                    $number = $i + 1;
                    $id = 'custom-footer-widget-'.$number;
                    register_sidebar( array(
                        'name'          => sprintf( esc_html__( 'Footer custom widget %s', 'softing' ), $number ),
                        'description'   => sprintf( esc_html__( 'This widget has %s column.', 'softing' ), $column ),
                        'id'            => $id,
                        'before_widget' => '<div class="footer-widget equal-height item"><div class="f-item link %2$s">',
                        'after_widget'  => '</div></div>',
                        'before_title'  => '<h4 class="footer-widget-title">',
                        'after_title'   => '</h4>'
                    ) );
                }
            }
        }
    }
    add_action( 'widgets_init', 'softing_widgets_init' );
}


/*************************************************
## HEADER SEARCH FORM
*************************************************/

if ( ! function_exists( 'softing_header_search_form' ) ) {
    function softing_header_search_form() {
        $form = '<form role="search" method="get" id="header-searchform" class="searchform c-header-1-searcher-form" action="'.esc_url( home_url( '/' ) ).'" >
        <input type="text" value="' . get_search_query() . '"  name="s" id="hs" class="c-header-1-searcher-field form-search sb-search-input" placeholder="'.esc_attr__( 'Start Typing &amp; Press Enter ...', 'softing' ).'">
        <button type="button" class="c-header-1-searcher-close"><i class="fas fa-long-arrow-alt-right"></i></button>
        </form>';
        return $form;
    }
    add_filter( 'get_search_form', 'softing_header_search_form' );
}


/*************************************************
## THEME SEARCH FORM
*************************************************/
if ( ! function_exists( 'softing_custom_search_form' ) ) {
    function softing_custom_search_form( $form ) {
        $form = '<div class="nt-sidebar-inner-search">
        <form class="nt-sidebar-inner-search-form searchform" role="search" method="get" id="widget-searchform"  action="' . esc_url( home_url( '/' ) ) . '" >
        <input class="nt-sidebar-inner-search-field" type="text" value="' . get_search_query() . '" placeholder="'. esc_attr__( 'Search for...', 'softing' ) .'" name="s" id="ws" >
        <button class="nt-sidebar-inner-search-button" id="searchsubmit" type="submit"><i class="fas fa-long-arrow-alt-right"></i></button>
        </form>
        </div>';
        return $form;
    }
    add_filter( 'get_search_form', 'softing_custom_search_form' );
}


/*************************************************
## DEFAULT CATEGORIES WIDGET
*************************************************/

if ( ! function_exists( 'softing_add_span_cat_count' ) ) {
    function softing_add_span_cat_count( $links )
    {
        $links = str_replace( '</a> (', '</a> <span class="widget-list-span">', $links );
        $links = str_replace( ')', '</span>', $links );

        return $links;
    }
    add_filter( 'wp_list_categories', 'softing_add_span_cat_count' );
}

/*************************************************
## DEFAULT ARCHIVES WIDGET
*************************************************/

if ( ! function_exists( 'softing_add_span_arc_count' ) ) {
    function softing_add_span_arc_count( $links )
    {
        $links = str_replace('</a>&nbsp;(', '</a> <span class="widget-list-span">', $links);
        $links = str_replace(')', '</span>', $links);
        return $links;
    }
    add_filter( 'get_archives_link', 'softing_add_span_arc_count' );
}


/*************************************************
## NAVIGATION CUSTOMIZATION
*************************************************/

if ( ! function_exists( 'softing_sanitize_pagination' ) ) {
    function softing_sanitize_pagination( $content )
    {
        // Remove role attribute
        $content = str_replace( 'role="navigation"', '', $content );

        // Remove h2 tag
        $content = preg_replace( '#<h2.*?>(.*?)<\/h2>#si', '', $content );

        return $content;
    }
    add_action('navigation_markup_template', 'softing_sanitize_pagination');
}


/*************************************************
## Custom Body and Html Classes
*************************************************/

if ( ! function_exists( 'softing_body_theme_class_names' ) ) {
    function softing_body_theme_class_names( $classes )
    {
        global $is_IE, $is_safari, $is_chrome, $is_iphone;
        $theme_name    =  wp_get_theme();
        $theme_version =  'nt-version-' . wp_get_theme()->get( 'Version' );
        $theme_page    =  ( ! is_page_template( 'custom-page.php' ) ) ? 'nt-body' : '';

        $classes[] = $theme_name;
        $classes[] = $theme_version;
        $classes[] = $theme_page;
        $classes[] = $is_IE ? 'nt-msie' : '';
        $classes[] = $is_chrome ? 'nt-chrome' : '';
        $classes[] = $is_safari ? 'nt-safari' : '';
        $classes[] = $is_iphone ? 'nt-iphone' : '';
        $classes[] = function_exists('wp_is_mobile') && wp_is_mobile() ? 'nt-mobile' : 'nt-desktop';

        return $classes;
    }
    add_filter( 'body_class','softing_body_theme_class_names' );
}


if ( ! function_exists( 'softing_add_class_to_html_tag' ) ) {
    function softing_add_class_to_html_tag( $output, $doctype )
    {
        if ( 'html' !== $doctype ) {
            return $output;
        }

        $output .= ' class="nt-theme-html-tag"';

        return $output;
    }
    add_filter( 'language_attributes', 'softing_add_class_to_html_tag', 10, 2 );
}


/*************************************************
## CUSTOM POST ADDCLASS
*************************************************/

if ( ! function_exists( 'softing_post_theme_class' ) ) {
    function softing_post_theme_class( $classes )
    {
        $class =  ' c-blog-1-item  nt-post-class';

        $classes[] =  $class;

        return $classes;
    }
    add_filter( 'post_class','softing_post_theme_class' );
}

/*************************************************
## SANITIZE MODIFIED VC-ELEMENTS OUTPUT
*************************************************/

if ( !function_exists( 'softing_vc_sanitize_data' ) ) {
    function softing_vc_sanitize_data($html_data)
    {
        return $html_data;
    }
}

/*************************************************
## VC COMPOSER PAGE CSS
*************************************************/
/*
*	get vc composer custom css from by page id
*	and add css to head by wp_head hook
*/
if( ! function_exists('softing_vc_inject_shortcode_css') )  {
    function softing_vc_inject_shortcode_css( $id ){
        $shortcodes_custom_css = get_post_meta( $id, '_wpb_shortcodes_custom_css', true );
        if ( ! empty( $shortcodes_custom_css ) ) {
            $shortcodes_custom_css = strip_tags( $shortcodes_custom_css );
            echo '<style type="text/css" data-type="nt-shortcodes-custom-css-page-'.$id.'">';
            echo esc_attr( $shortcodes_custom_css );
            echo '</style>';
        }
    }
    add_action('wp_head', 'softing_vc_inject_shortcode_css');
}


/*************************************************
## Custom archive title
*************************************************/

if ( ! function_exists( 'softing_archive_title' ) ) {
    function softing_archive_title()
    {
        $title = '';

        if ( is_category() ) {
            $title = single_cat_title( '', false );
        } elseif ( is_tag() ) {
            $title = single_tag_title( '', false );
        } elseif ( is_author() ) {
            $title = get_the_author();
        } elseif ( is_year() ) {
            $title = get_the_date( _x( 'Y', 'yearly archives date format', 'softing' ) );
        } elseif ( is_month() ) {
            $title = get_the_date( _x( 'F Y', 'monthly archives date format', 'softing' ) );
        } elseif ( is_day() ) {
            $title = get_the_date( _x( 'F j, Y', 'daily archives date format', 'softing' ) );
        } elseif ( is_post_type_archive() ) {
            $title = post_type_archive_title( '', false );
        } elseif ( is_tax() ) {
            $title = single_term_title( '', false );
        } else {
            $title = esc_html__( 'Archives', 'softing' );
        }

        return $title;
    }
    add_filter( 'get_the_archive_title', 'softing_archive_title' );
}


/*************************************************
## Register Menu
*************************************************/

if ( ! class_exists( 'Softing_Wp_Bootstrap_Navwalker' ) ) {
    class Softing_Wp_Bootstrap_Navwalker extends Walker_Nav_Menu
    {
        function start_lvl( &$output, $depth = 0, $args = array() )
        {

            $indent = str_repeat( "\t", $depth );
            $submenu = ($depth > 0) ? 'text-left' : '';
            $output	.= "\n$indent<ul class=\"dropdown-menu depth_$depth\" >\n";

        }

        function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 )
        {

            $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

            $li_attributes = '';
            $class_names = $value = '';

            $classes = empty( $item->classes ) ? array() : (array) $item->classes;
            // managing divider: add divider class to an element to get a divider before it.
            $divider_class_position = array_search('divider', $classes);
            if($divider_class_position !== false){
                $output .= "<li class=\"divider\"></li>\n";
                unset($classes[$divider_class_position]);
            }
            $classes[] = ($args->has_children) ? 'dropdown dropdown-right' : '';
            $classes[] = ($item->current || $item->current_item_ancestor) ? '' : '';
            $classes[] = 'menu-item-' . $item->ID;
            if($depth && $args->has_children){
                $classes[] = 'dropdown dropdown-right';
            }

            $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
            $class_names = ' class="' . esc_attr( $class_names ) . '"';

            $id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args );
            $id = strlen( $id ) ? ' id="' . esc_attr( $id ) . '"' : '';

            $output .= $indent . '<li' . $id . $value . $class_names . $li_attributes . '>';


            $attributes = ! empty( $item->title ) ? ' title="' . esc_attr( $item->title ) .'"' : '';
            $attributes .= ! empty( $item->target ) ? ' target="' . esc_attr( $item->target ) .'"' : '';
            $attributes .= ! empty( $item->xfn ) ? ' rel="' . esc_attr( $item->xfn ) .'"' : '';
            $attributes .= ! empty( $item->url ) ? ' href="' . esc_attr( $item->url ) .'"' : '';
            $attributes .= ($args->has_children)  ? ' class="dropdown-toggle scroll"  data-toggle="dropdown"' : ' class="scroll"';

            $item_output = $args->before;
            $item_output .= '<a'. $attributes .'>';
            $item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;

            $item_output .= (($depth == 0 || 1) && $args->has_children) ? '</a>' : '</a>';
            $item_output .= $args->after;


            $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
        }

        function display_element( $element, &$children_elements, $max_depth, $depth, $args, &$output )
        {
            if ( !$element )
            return;

            $id_field = $this->db_fields['id'];

            //display this element
            if ( is_array( $args[0] ) )
            $args[0]['has_children'] = ! empty( $children_elements[$element->$id_field] );
            else if ( is_object( $args[0] ) )
            $args[0]->has_children = ! empty( $children_elements[$element->$id_field] );
            $cb_args = array_merge( array(&$output, $element, $depth), $args);
            call_user_func_array(array(&$this, 'start_el'), $cb_args);

            $id = $element->$id_field;

            // descend only when the depth is right and there are childrens for this element
            if ( ($max_depth == 0 || $max_depth > $depth+1 ) && isset( $children_elements[$id]) ) {

                foreach( $children_elements[ $id ] as $child ){

                    if ( !isset($newlevel) ) {
                        $newlevel = true;
                        //start the child delimiter
                        $cb_args = array_merge( array(&$output, $depth), $args);
                        call_user_func_array(array(&$this, 'start_lvl'), $cb_args);
                    }
                    $this->display_element( $child, $children_elements, $max_depth, $depth + 1, $args, $output );
                }
                unset( $children_elements[ $id ] );
            }

            if ( isset($newlevel) && $newlevel ){
                //end the child delimiter
                $cb_args = array_merge( array(&$output, $depth), $args);
                call_user_func_array(array(&$this, 'end_lvl'), $cb_args);
            }

            //end this element
            $cb_args = array_merge( array(&$output, $element, $depth), $args);
            call_user_func_array(array(&$this, 'end_el'), $cb_args);

        }

        /**
        * Menu Fallback
        *
        * @since 1.0.0
        *
        * @param array $args passed from the wp_nav_menu function.
        */
        public static function fallback( $args )
        {
            if ( current_user_can( 'edit_theme_options' ) ) {

                echo '<li><a href="' . admin_url( 'nav-menus.php' ) . '">' . esc_html__( 'Add a menu', 'softing' ) . '</a></li>';

            }
        }
    }
}

if ( is_admin() ) {
    /*************************************************
    ## INCLUDE THE TGM_PLUGIN_ACTIVATION CLASS.
    *************************************************/
    include SOFTING_DIRECTORY . '/inc/class-tgm-plugin-activation.php';
    function softing_register_required_plugins()
    {
        $plugins = array(
            array(
                'name'     => esc_html__('Contact Form 7', "softing"),
                'slug'     => 'contact-form-7'
            ),
            array(
                'name'     => esc_html__('Meta Box', "softing"),
                'slug'     => 'meta-box',
                'required' => true
            ),
            array(
                'name'     => esc_html__('Theme Options Panel', "softing"),
                'slug'     => 'redux-framework',
                'required' => true
            ),
            array(
                'name'     => esc_html__('Metabox Tabs', "softing"),
                'slug'     => 'meta-box-tabs',
                'source'   => 'https://ninetheme.com/documentation/plugins/meta-box-tabs.zip',
                'required' => true,
                'version'  => '1.1.5'
            ),
            array(
                'name'     => esc_html__('Metabox Show/Hide', "softing"),
                'slug'     => 'meta-box-show-hide',
                'source'   => 'https://ninetheme.com/documentation/plugins/meta-box-show-hide.zip',
                'required' => true,
                'version'  => '1.3'
            ),
            array(
                'name' => esc_html__('Safe SVG', "softing"),
                'slug' => 'safe-svg',
                'required' => false
            ),
            array(
                'name'     => esc_html__('Envato Auto Update Theme', "softing"),
                'slug'     => 'envato-market',
                'source'   => 'https://ninetheme.com/documentation/plugins/envato-market.zip',
                'required' => false,
                'version'  => '2.0.3'
            ),
            array(
                'name'     => esc_html__('Page Builder', "softing"),
                'slug'     => 'js_composer',
                'source'   => 'https://ninetheme.com/documentation/plugins/js_composer.zip',
                'required' => true
            ),
            array(
                'name'     => esc_html__('Revolution Slider', "softing"),
                'slug'     => 'revslider',
                'source'   => 'https://ninetheme.com/documentation/plugins/revslider.zip',
                'required' => false
            ),
            array(
                'name'     => esc_html__('Softing Shortcodes', "softing"),
                'slug'     => 'nt-softing-shortcodes',
                'source'   => SOFTING_DIRECTORY_URI . '/plugins/nt-softing-shortcodes.zip',
                'required' => true,
                'version'  => '1.5.9'
            )
        );

        $config = array(
            'id' => 'tgmpa',
            'default_path' => '',
            'menu' => 'tgmpa-install-plugins',
            'parent_slug' => apply_filters( 'ninetheme_parent_slug', 'themes.php' ),
            'has_notices' => true,
            'dismissable' => true,
            'dismiss_msg' => '',
            'is_automatic' => true,
            'message' => ''
        );

        tgmpa( $plugins, $config );
    }
    add_action( 'tgmpa_register', 'softing_register_required_plugins' );

    /*************************************************
    ## THEME SETUP WIZARD
    https://github.com/richtabor/MerlinWP
    *************************************************/

    function softing_merlin_local_import_files() {
        return array(
            array(
                'import_file_name' => esc_html__( 'Demo Import', 'softing' ),
                // xml data
                'local_import_file' => get_parent_theme_file_path( 'inc/merlin/demodata/data.xml' ),
                // widget data
                'local_import_widget_file' => get_parent_theme_file_path( 'inc/merlin/demodata/widgets.wie' ),
                // theme options
                'import_redux' => array(
                    array(
                        'file_url' => trailingslashit( SOFTING_DIRECTORY_URI ) .  'inc/merlin/demodata/redux.json',
                        'option_name' => 'softing'
                    )
                )
            )
        );
    }
    add_filter( 'merlin_import_files', 'softing_merlin_local_import_files' );


    /**
    * Execute custom code after the whole import has finished.
    */
    function softing_merlin_after_import_setup() {
        // Assign menus to their locations
        $header_menu_1 = get_term_by( 'name', 'primary', 'nav_menu' );
        $footer_menu = get_term_by( 'name', 'footer', 'nav_menu' );

        set_theme_mod( 'nav_menu_locations',
            array(
                'header_menu_1' => $header_menu_1->term_id,
                'footer_menu' => $footer_menu->term_id,
            )
        );

        // Assign front page and posts page (blog page).
        update_option( 'show_on_front', 'page' );

        $front_pagequery = new WP_Query(array(
            'post_type' => 'page',
            'title' => 'Home 1',
        ));
        if ($front_pagequery->have_posts()) {
            $front_pagequery->the_post();
            update_option( 'page_on_front', get_the_ID() );
            wp_reset_postdata();
        }

        $blog_pagequery = new WP_Query(array(
            'post_type' => 'page',
            'title' => 'Blog',
        ));
        if ($blog_pagequery->have_posts()) {
            $blog_pagequery->the_post();
            update_option( 'page_for_posts', get_the_ID() );
            wp_reset_postdata();
        }

        update_option( 'posts_per_page', '4' );
        // removes block widgets from sidebars after demodata install
        if ( is_active_sidebar( 'sidebar-1' ) ) {
            $sidebars_widgets = get_option( 'sidebars_widgets' );
            $sidebar_1_array  = $sidebars_widgets['sidebar-1'];
            foreach( $sidebar_1_array as $k => $v ) {
                if( substr( $v, 0, strlen("block-") ) === "block-" ) {
                    unset($sidebars_widgets['sidebar-1'][$k]);
                }
            }
            update_option( 'sidebars_widgets', $sidebars_widgets);
        }

    }
    add_action( 'merlin_after_all_import', 'softing_merlin_after_import_setup' );
}

add_action('init', 'do_output_buffer'); function do_output_buffer() { ob_start(); }

add_filter( 'woocommerce_prevent_automatic_wizard_redirect', '__return_true' );


/*************************************************
## CUSTOM POST CLASS
*************************************************/

if ( ! function_exists( 'nt_softing_post_theme_class' ) ) {
    function nt_softing_post_theme_class( $classes )
    {
        if ( is_single() ) {
            $classes[] =  has_blocks() ? 'nt-single-has-block' : '';
        }

        return $classes;
    }
    add_filter('post_class', 'nt_softing_post_theme_class');
}


if ( ! function_exists( 'nt_softing_home_posts_by_categories' ) ) {
    function nt_softing_home_posts_by_categories( $query )
    {
        global $softing;
        $cats = isset($softing['post_categories']) && !empty( $softing['post_categories'] ) ? $softing['post_categories'] : '';

        if( !empty( $cats ) && $query->is_home() && $query->is_main_query() ) {
            $query->set( 'cat', $cats );
        }
    }
    add_action( 'pre_get_posts', 'nt_softing_home_posts_by_categories' );
}


if ( !get_option('envato_purchase_code_23177965') ) {
    add_filter('auto_update_theme', '__return_false');
}
