<?php
if ( ! function_exists( 'rwmb_meta' ) || ! is_admin() )
return false;

add_filter( 'rwmb_meta_boxes', 'softing_register_meta_boxes' );
function softing_register_meta_boxes( $meta_boxes ) {

/* ----------------------------------------------------- */
// PAGE BACKGROUND-HEADER-FOOTER COLOR
/* ----------------------------------------------------- */

$meta_boxes[] = array(
	'title' 	=> esc_html__( 'Header - Footer', 'softing' ),
	'id' 		=> 'pageheadersettings',
	'pages' 	=> array( 'page' ),
	'context'	=> 'normal',
	'tab_style' => 'box',
	'priority'	=> 'high',
	'tabs'    	=> array(
		'tab1' 	=> 'Menu',
		'tab2' 	=> 'Menu Right Button',
		'tab3' 	=> 'Main Footer',
		'tab4' 	=> 'Footer Widgetize',
	),
	'fields' 	=> array(

		// TAB1 HEADER MENU
		array(
			'id'   		=> 'softing_page_nav_section',
			'name'		=> esc_html__( 'Header Navigation', 'softing' ),
			'type' 		=> 'heading',
			'tab'  		=> 'tab1',
		),
		// Menu
		array(
			'id'        => 'softing_page_nav_onoff',
			'name' 		=> esc_html__('Header Navigation Display', 'softing'),
			'type'      => 'switch',
			'style'     => 'rounded',
			'on_label'  => esc_html__('Show', 'softing'),
			'off_label' => esc_html__('Hide', 'softing'),
			'std' 		=> 1,
			'tab'  		=> 'tab1',
		),
		array(
			'id'      	=> 'softing_page_logo',
			'name' 		=> esc_html__( 'Logo', 'softing' ),
			'desc' 		=> esc_html__( 'Upload your Logo. If left blank theme will use site default logo', 'softing' ),
			'type'    	=> 'image_advanced',
			'max_file_uploads' 	=> 1,
			'tab'  		=> 'tab1',
		),
		array(
			'id'      	=> 'softing_page_logo_sticky',
			'name' 		=> esc_html__( 'Transparent Menu Logo', 'softing' ),
			'desc' 		=> esc_html__( 'Upload your second logo for transparent menu.', 'softing' ),
			'type'    	=> 'image_advanced',
			'max_file_uploads' 	=> 1,
			'tab'  		=> 'tab1',
		),
		array(
			'id'   		=> 'softing_page_nav_bgtype',
			'name' 		=> esc_html__('Header Navigation Background Type', 'softing'),
			'type' 		=> 'select',
			'options'  	=> array(
				'normal' => esc_html__( 'Default background', 'softing' ),
				'trans' => esc_html__( 'Transparent', 'softing' ),
				'fixed' => esc_html__( 'Fixed No Background', 'softing' ),
			),
			'std'       => 'normal',
			'tab'  		=> 'tab1',
		),
		array(
			'id'   		=> 'softing_page_nav_bgcolor',
			'name' 		=> esc_html__( 'Menu Background Color', 'softing' ),
			'type' 		=> 'color',
			'alpha_channel' => true,
			 'tab'  	=> 'tab1',
		),
		array(
			'id'   		=> 'softing_page_nav_color',
			'name' 		=> esc_html__( 'Menu Item Color', 'softing' ),
			'type' 		=> 'color',
			 'tab'  	=> 'tab1',
		),
		array(
			'id'   		=> 'softing_page_nav_hovercolor',
			'name' 		=> esc_html__( 'Hover Menu Item Color', 'softing' ),
			'type' 		=> 'color',
			 'tab'  	=> 'tab1',
		),
		array(
			'id'   		=> 'softing_page_nav_hoverbgcolor',
			'name' 		=> esc_html__( 'Hover Menu Item Background Color', 'softing' ),
			'type' 		=> 'color',
			 'tab'  	=> 'tab1',
		),
		array(
			'type' 		=> 'divider',
			'tab'  		=> 'tab1',
		),
		array(
			'id'   		=> 'softing_page_nav_pt',
			'name'		=> esc_html__( 'Menu Padding Top', 'softing' ),
			'desc' 		=> esc_html__('Set the padding top of the theme header navigation for this page or leave it blank.e.g: 30px,30%...', 'softing'),
			'type' 		=> 'number',
			'min'  		=> 0,
			'step' 		=> 1,
		 	'tab'  		=> 'tab1',
		),
		array(
			'id'   		=> 'softing_page_nav_pb',
			'name'		=> esc_html__( 'Menu Padding Bottom', 'softing' ),
			'desc' 		=> esc_html__('Set the padding bottom of the theme header navigation for this page or leave it blank.e.g: 30px,30%...', 'softing'),
			'type' 		=> 'number',
			'min'  		=> 0,
			'step' 		=> 1,
		 	'tab'  		=> 'tab1',
		),
		array(
			'type' 		=> 'divider',
			'tab'  		=> 'tab1',
		),
		array(
			'id'   		=> 'softing_page_subnav_bg',
			'name' 		=> esc_html__( 'SubMenu Background Color', 'softing' ),
			'type' 		=> 'color',
			'alpha_channel' => true,
			 'tab'  	=> 'tab1',
		),
		array(
			'id'   		=> 'softing_page_subnav_minw',
			'name' 		=> esc_html__( 'SubMenu Width (px)', 'softing' ),
			'type' 		=> 'number',
			'min'   	=> 0,
			'max'   	=> 50,
			'step'  	=> 1,
			'tab'  		=> 'tab1',
		),
		array(
			'id'   		=> 'softing_page_subnav_clr',
			'name' 		=> esc_html__( 'SubMenu Menu Item Color', 'softing' ),
			'type' 		=> 'color',
			 'tab'  	=> 'tab1',
		),
		array(
			'id'   		=> 'softing_page_subnav_hvrclr',
			'name' 		=> esc_html__( 'Hover SubMenu Item Color', 'softing' ),
			'type' 		=> 'color',
			 'tab'  	=> 'tab1',
		),
		array(
			'id'		=> 'softing_page_subnav_pad',
			'name'		=> esc_html__( 'SubMenu Padding', 'softing' ),
			'desc' 		=> esc_html__('Set the padding of the theme header submenu for this page or leave it blank.e.g: 30px,30%...', 'softing'),
			'type'    	=> 'text_list',
			'class'    	=> 'default-column',
			'clone'    	=> false,
			'options' 	=> array(
				'top'    	=> 'Top',
				'right' 	=> 'Right',
				'bottom'   	=> 'Bottom',
				'left'   	=> 'Left',
			),
			'tab'  		=> 'tab1',
		),
		//info nav off
		array(
			'type' => 'custom_html',
			'std'  => '<div id="page-nav-off-info" class="nt-page-info"><span class="dashicons dashicons-hidden"></span>'.esc_html__('The Site Primary Menu is Disabled', 'softing').'</div>',
			'tab'  => 'tab1',
		),
		// tab2 header button
		array(
			'id'   		=> 'softing_page_nav_btn_tab',
			'name'		=> esc_html__( 'Header Right Button Options', 'softing' ),
			'type' 		=> 'heading',
		 	'tab'  		=> 'tab2',
		),
		array(
			'id'        => 'softing_page_nav_btn',
			'name' 		=> esc_html__('Button Display', 'softing'),
			'type'      => 'switch',
			'style'     => 'rounded',
			'on_label'  => esc_html__( 'Show', 'softing' ),
			'off_label' => esc_html__( 'Hide', 'softing' ),
			'std' 		=> 1,
			'tab'  		=> 'tab2',
		),
		array(
			'id'		=> 'softing_page_nav_btn1_title',
			'name'		=> esc_html__( 'Button 1 Title', 'softing' ),
			'clone'		=> false,
			'type'		=> 'text',
			'tab'  		=> 'tab2',
		),
		array(
			'id'		=> 'softing_page_nav_btn1_url',
			'name'		=> esc_html__( 'Button 1 URL', 'softing' ),
			'clone'		=> false,
			'type'		=> 'text',
			'tab'  		=> 'tab2',
		),
		array(
			'id'   		=> 'softing_page_nav_btn1_target',
			'name' 		=> esc_html__('Button 1 Target', 'softing'),
			'type' 		=> 'select',
			'options'  	=> array(
				'' => esc_html__( 'Select Button Target Type', 'softing' ),
				'_blank' => esc_html__( 'Blank', 'softing' ),
				'_parent' => esc_html__( 'Parent', 'softing' ),
				'_self' => esc_html__( 'Self', 'softing' ),
				'_top' => esc_html__( 'Top', 'softing' ),
			),
			'std'       => '',
			'tab'  		=> 'tab2',
		),
		array(
			'id'		=> 'softing_page_nav_btn2_title',
			'name'		=> esc_html__( 'Button 2 Title', 'softing' ),
			'clone'		=> false,
			'type'		=> 'text',
			'tab'  		=> 'tab2',
		),
		array(
			'id'		=> 'softing_page_nav_btn2_url',
			'name'		=> esc_html__( 'Button 2 URL', 'softing' ),
			'clone'		=> false,
			'type'		=> 'text',
			'tab'  		=> 'tab2',
		),
		array(
			'id'   		=> 'softing_page_nav_btn2_target',
			'name' 		=> esc_html__('Button 2 Target', 'softing'),
			'type' 		=> 'select',
			'options'  	=> array(
				'' => esc_html__( 'Select Button Target Type', 'softing' ),
				'_blank' => esc_html__( 'Blank', 'softing' ),
				'_parent' => esc_html__( 'Parent', 'softing' ),
				'_self' => esc_html__( 'Self', 'softing' ),
				'_top' => esc_html__( 'Top', 'softing' ),
			),
			'std'       => '',
			'tab'  		=> 'tab2',
		),
		array(
			'type' => 'custom_html',
			'std'  => '<div id="page-nav-btn-off-info" class="nt-page-info"><span class="dashicons dashicons-hidden"></span>'.esc_html__('The Header Right Button is Disabled', 'softing').'</div>',
			'tab'  => 'tab2',
		),
		// TAB3 FOOTER
		array(
			'id'   		=> 'softing_page_footer_tab',
			'name'		=> esc_html__( 'Page Footer', 'softing' ),
			'type' 		=> 'heading',
			'tab'  		=> 'tab3',
		),
		array(
			'id'        => 'page_footer_onoff',
			'name' 		=> esc_html__('Footer Display', 'softing'),
			'type'      => 'switch',
			'style'     => 'rounded',
			'on_label'  => esc_html__('Show', 'softing'),
			'off_label' => esc_html__('Hide', 'softing'),
			'std' 		=> 1,
			'tab'  		=> 'tab3',
		),
		array(
			'type' 		=> 'divider',
			'tab'  		=> 'tab3',
		),
		array(
			'id'   		=> 'softing_p_f_bg',
			'name' 		=> esc_html__( 'Footer Background Color', 'softing' ),
			'type' 		=> 'color',
			'tab'  		=> 'tab3',
		),
		array(
			'id'   		=> 'softing_p_f_c',
			'name' 		=> esc_html__( 'Copyright Text Color', 'softing' ),
			'type' 		=> 'color',
			'tab'  		=> 'tab3',
		),
		array(
			'type' 		=> 'divider',
			'tab'  		=> 'tab3',
		),
		array(
			'id'   		=> 'softing_p_f_pt',
			'name' 		=> esc_html__( 'Footer Top Spacing (px)', 'softing' ),
			'desc' 		=> esc_html__( 'Use simple number without px or unit.Default : 75)', 'softing' ),
			'type' 		=> 'number',
			'min'   	=> 0,
			'step'  	=> 1,
			'placeholder'  	=> esc_html__( 'padding-top', 'softing' ),
			'tab'  		=> 'tab3',
		),
		array(
			'id'   		=> 'softing_p_f_pb',
			'name' 		=> esc_html__( 'Footer Bottom Spacing (px)', 'softing' ),
			'desc' 		=> esc_html__( 'Use simple number without px or unit.Default : 75)', 'softing' ),
			'type' 		=> 'number',
			'min'   	=> 0,
			'step'  	=> 1,
			'placeholder'  	=> esc_html__( 'padding-bottom', 'softing' ),
			'tab'  		=> 'tab3',
		),
		//info footer off
		array(
			'type' => 'custom_html',
			'std'  => '<div id="page-footer-off-info" class="nt-page-info"><span class="dashicons dashicons-hidden"></span>'.esc_html__('The Site Main Footer Section is Disabled', 'softing').'</div>',
			'tab'  => 'tab3',
		),
		// TAB4 FOOTER WIDGET AREA
		array(
			'id'   		=> 'softing_page_widget_section',
			'name'		=> esc_html__( 'Page Footer Widget Area', 'softing' ),
			'type' 		=> 'heading',
			'tab'  		=> 'tab4',
		),
		array(
			'id'        => 'softing_page_fw_onoff',
			'name' 		=> esc_html__('Widget Area Display', 'softing'),
			'type'      => 'switch',
			'style'     => 'rounded',
			'on_label'  => esc_html__('Show', 'softing'),
			'off_label' => esc_html__('Hide', 'softing'),
			'std' 		=> 0,
			'tab'  		=> 'tab4',
		),
		array(
			'type' 		=> 'divider',
			'tab'  		=> 'tab4',
		),
		array(
			'id'   		=> 'softing_p_fw_bg',
			'name' 		=> esc_html__( 'Widget Area Background Image', 'softing' ),
			'type' 		=> 'background',
			'tab'  		=> 'tab4',
		),
		array(
			'id'   		=> 'softing_p_fw_bg_o',
			'name' 		=> esc_html__( 'Background Image Overlay Color', 'softing' ),
			'type' 		=> 'color',
			'alpha_channel' => true,
			'tab'  		=> 'tab4',
		),
		array(
			'type' 		=> 'divider',
			'tab'  		=> 'tab4',
		),
		array(
			'id'   		=> 'softing_p_fw_t_c',
			'name' 		=> esc_html__( 'General Text Color', 'softing' ),
			'type' 		=> 'color',
			'tab'  		=> 'tab4',
		),
		array(
			'id'   		=> 'softing_p_fw_h_c',
			'name' 		=> esc_html__( 'Widget Heading Color', 'softing' ),
			'type' 		=> 'color',
			'tab'  		=> 'tab4',
		),
		array(
			'id'   		=> 'softing_p_fw_a',
			'name' 		=> esc_html__( 'Widget Link Color', 'softing' ),
			'type' 		=> 'color',
			'tab'  		=> 'tab4',
		),
		array(
			'id'   		=> 'softing_p_fw_hvra',
			'name' 		=> esc_html__( 'Widget Hover Link Color', 'softing' ),
			'type' 		=> 'color',
			'tab'  		=> 'tab4',
		),
		array(
			'type' 		=> 'divider',
			'tab'  		=> 'tab4',
		),
		array(
			'id'   		=> 'softing_p_fw_pt',
			'name' 		=> esc_html__( 'Widget Area Top Spacing (px)', 'softing' ),
			'desc' 		=> esc_html__( 'Use simple number without px or unit.Default : 150)', 'softing' ),
			'type' 		=> 'number',
			'min'   	=> 0,
			'step'  	=> 1,
			'placeholder'  	=> esc_html__( 'padding-top', 'softing' ),
			'tab'  		=> 'tab4',
		),
		array(
			'id'   		=> 'softing_p_fw_pb',
			'name' 		=> esc_html__( 'Widget Area Bottom Spacing (px)', 'softing' ),
			'desc' 		=> esc_html__( 'Use simple number without px or unit.Default : 150)', 'softing' ),
			'type' 		=> 'number',
			'min'   	=> 0,
			'step'  	=> 1,
			'placeholder'  	=> esc_html__( 'padding-bottom', 'softing' ),
			'tab'  		=> 'tab4',
		),
		array(
			'type' => 'custom_html',
			'std'  => '<div id="page-fw-off-info" class="nt-page-info"><span class="dashicons dashicons-hidden"></span>'.esc_html__('The Footer Widget Area Section is Disabled', 'softing').'</div>',
			'tab'  => 'tab4',
		),
	)
);

/* ----------------------------------------------------- */
// PAGE HERO OPTIONS
/* ----------------------------------------------------- */

$meta_boxes[] = array(
	'title' 	=> esc_html__( 'Page Hero Options', 'softing' ),
	'id' 		=> 'pageherosettings',
	'pages' 	=> array( 'page' ),
	'context' 	=> 'normal',
	'priority'	=> 'high',
	'tab_style' => 'box',
	'show' 		=> array( 'template' => 'default-page.php' ),
	'tabs'    	=> array(
		'tab0' 	=> 'Hero General',
		'tab1' 	=> 'Title',
		'tab2' 	=> 'Slogan',
		'tab3' 	=> 'Description',
	),
	'fields' 	=> array(
		// tab0
		array(
			'id'   		=> 'softing_page_hero_tab',
			'name'		=> esc_html__( 'Page Hero Options', 'softing' ),
			'type' 		=> 'heading',
		 	'tab'  		=> 'tab0',
		),
		array(
			'id'        => 'softing_page_hero_display',
			'name' 		=> esc_html__('Page Hero Display', 'softing'),
			'type'      => 'switch',
			'style'     => 'rounded',
			'on_label'  => esc_html__( 'Show', 'softing' ),
			'off_label' => esc_html__( 'Hide', 'softing' ),
			'std' 		=> 1,
			'tab'  		=> 'tab0',
		),
		array(
			'type' 		=> 'divider',
			'tab'  		=> 'tab0',
		),
		// hero align
		array(
			'id'   		=> 'softing_page_hero_align',
			'name' 		=> esc_html__('Hero Text Alignment', 'softing'),
			'desc' 		=> esc_html__('Select page hero text align.', 'softing'),
			'type' 		=> 'select',
			'options'  	=> array(
				'text-left' 	=> esc_html__( 'Left', 'softing' ),
				'text-center' 	=> esc_html__( 'Center', 'softing' ),
				'text-right' 	=> esc_html__( 'Right', 'softing' ),
			),
			'std'       => 'text-center',
			'tab'  		=> 'tab0',
		),
		array(
			'type' 		=> 'divider',
			'tab'  		=> 'tab0',
		),
		array(
			'id'   		=> 'softing_p_h_bg',
			'name' 		=> esc_html__( 'Page Hero Background Image', 'softing' ),
			'type' 		=> 'background',
			'tab'  		=> 'tab0',
		),

		array(
			'id'   		=> 'softing_page_hero_overlay_type',
			'name' 		=> esc_html__('Background Image Overlay Type', 'softing'),
			'desc' 		=> esc_html__('Select page hero background image overlay pattern type.', 'softing'),
			'type' 		=> 'select',
			'options'  	=> array(
				'dark' => esc_html__( 'Dark', 'softing' ),
				'custom' => esc_html__( 'Custom color', 'softing' ),
			),
			'std'       => 'dark',
			'tab'  		=> 'tab0',
		),
		array(
			'id'   		=> 'softing_p_h_overlay',
			'name' 		=> esc_html__( 'Background Image Overlay Color', 'softing' ),
			'type' 		=> 'color',
			'alpha_channel' => true,
		 	'tab'  		=> 'tab0',
		),
		array(
			'type' 		=> 'divider',
			'tab'  		=> 'tab0',
		),
		array(
			'id'   		=> 'softing_p_h_pt',
			'name' 		=> esc_html__( 'Hero Top Spacing (px)', 'softing' ),
			'desc' 		=> esc_html__( 'Use simple number without px or unit.Default : 150)', 'softing' ),
			'type' 		=> 'number',
			'min'  		=> 0,
			'step' 		=> 1,
			'placeholder' => 'padding-top',
		 	'tab'  		=> 'tab0',
		),
		array(
			'id'   		=> 'softing_p_h_pb',
			'name' 		=> esc_html__( 'Hero Bottom Spacing (px)', 'softing' ),
			'desc' 		=> esc_html__( 'Use simple number without px or unit.Default : 150)', 'softing' ),
			'type' 		=> 'number',
			'min'  		=> 0,
			'step' 		=> 1,
			'placeholder' => 'padding-bottom',
		 	'tab'  		=> 'tab0',
		),
		array(
			'type' => 'custom_html',
			'std'  => '<div id="page-hero-off-info" class="nt-page-info"><span class="dashicons dashicons-hidden"></span>'.esc_html__('The Hero Section is Disabled', 'softing').'</div>',
			'tab'  => 'tab0',
		),
		// tab1
		array(
			'id'   		=> 'softing_page_title_tab',
			'name'		=> esc_html__( 'Page Title Options', 'softing' ),
			'type' 		=> 'heading',
		 	'tab'  		=> 'tab1',
		),
		array(
			'id'		=> 'softing_page_heading',
			'name'		=> esc_html__( 'Alternate Page Title', 'softing' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> '',
		 	'tab'  		=> 'tab1',
		),
		array(
			'id'   		=> 'softing_p_t_clr',
			'name' 		=> esc_html__( 'Page Title Color', 'softing' ),
			'type' 		=> 'color',
		 	'tab'  		=> 'tab1',
		),
		array(
			'id'   		=> 'softing_p_t_fs',
			'name' 		=> esc_html__( 'Page Title Font Size', 'softing' ),
			'type' 		=> 'number',
			'min'  		=> 0,
			'step' 		=> 1,
		 	'tab'  		=> 'tab1',
		),
		array(
			'id'   		=> 'softing_p_t_mb',
			'name' 		=> esc_html__( 'Page Title margin-bottom', 'softing' ),
			'type' 		=> 'number',
			'min'  		=> 0,
			'step' 		=> 1,
		 	'tab'  		=> 'tab1',
		),
		array(
			'type' 		=> 'divider',
			'tab'  		=> 'tab1',
		),
		// tab4
		array(
			'id'   		=> 'softing_page_slogan_tab',
			'name'		=> esc_html__( 'Page Slogan Options', 'softing' ),
			'type' 		=> 'heading',
		 	'tab'  		=> 'tab2',
		),
		array(
			'id'		=> 'softing_page_slogan',
			'name'		=> esc_html__( 'Page Slogan', 'softing' ),
			'clone'		=> false,
			'type'		=> 'textarea',
			'tab'  		=> 'tab2',
		),
		array(
			'id'   		=> 'softing_p_s_clr',
			'name' 		=> esc_html__( 'Page Slogan Color', 'softing' ),
			'type' 		=> 'color',
		 	'tab'  		=> 'tab2',
		),
		array(
			'id'   		=> 'softing_p_s_fs',
			'name' 		=> esc_html__( 'Page Slogan Font Size', 'softing' ),
			'type' 		=> 'number',
			'min'  		=> 0,
			'step' 		=> 1,
		 	'tab'  		=> 'tab2',
		),
		// tab3
		array(
			'id'   		=> 'softing_page_desc_tab',
			'name'		=> esc_html__( 'Page Description Options', 'softing' ),
			'type' 		=> 'heading',
		 	'tab'  		=> 'tab3',
		),
		array(
			'id'		=> 'softing_page_desc',
			'name'		=> esc_html__( 'Page Description', 'softing' ),
			'clone'		=> false,
			'type'		=> 'textarea',
			'tab'  		=> 'tab3',
		),
		array(
			'id'   		=> 'softing_p_d_clr',
			'name' 		=> esc_html__( 'Page Description Color', 'softing' ),
			'type' 		=> 'color',
		 	'tab'  		=> 'tab3',
		),
		array(
			'id'   		=> 'softing_p_d_fs',
			'name' 		=> esc_html__( 'Page Description Font Size', 'softing' ),
			'type' 		=> 'number',
			'min'  		=> 0,
			'step' 		=> 1,
		 	'tab'  		=> 'tab3',
		),
	)
);

/* ----------------------------------------------------- */
// PAGE HERO OPTIONS
/* ----------------------------------------------------- */

$meta_boxes[] = array(
	'title' 	=> esc_html__( 'Page Content Options', 'softing' ),
	'id' 		=> 'pagecontentsettings',
	'pages' 	=> array( 'page' ),
	'context' 	=> 'normal',
	'priority'	=> 'high',
	'tab_style' => 'box',
	'show' 		=> array( 'template' => 'default-page.php' ),
	'fields' 	=> array(

		array(
			'id'   		=> 'softing_p_c_pt',
			'name' 		=> esc_html__( 'Page Content Top Spacing (px)', 'softing' ),
			'desc' 		=> esc_html__( 'Use simple number without px or unit.Default : 150', 'softing' ),
			'type' 		=> 'number',
			'min'  		=> 0,
			'step' 		=> 1,
			'placeholder' => 'padding-top',
		),
		array(
			'id'   		=> 'softing_p_c_pb',
			'name' 		=> esc_html__( 'Page Content Bottom Spacing (px)', 'softing' ),
			'desc' 		=> esc_html__( 'Use simple number without px or unit.Default : 150', 'softing' ),
			'type' 		=> 'number',
			'min'  		=> 0,
			'step' 		=> 1,
			'placeholder' => 'padding-bottom',
		)
	)
);

/* ----------------------------------------------------- */
// PAGE SIDEBAR
/* ----------------------------------------------------- */
$meta_boxes[] = array(
	'title' 	=> esc_html__( 'Page Sidebar Options', 'softing' ),
	'id' 		=> 'pagesidebarsettings',
	'pages' 	=> array( 'page' ),
	'context' 	=> 'normal',
	'priority'	=> 'high',
	'tab_style' => 'box',
 	'show'    	=> array( 'template'  => 'default-page.php' ),
	'fields' 	=> array(

		array(
			'id'   	   => 'softing_page_layout',
			'name'     => esc_html__( 'Page Layout', 'softing' ),
			'type'     => 'image_select',
			'options'  => array(
				'left-sidebar' 	=> get_template_directory_uri().'/images/sidebar-left.png',
				'full-width' 	=> get_template_directory_uri().'/images/sidebar-none.png',
				'right-sidebar' => get_template_directory_uri().'/images/sidebar-right.png',

			),
			'multiple' => false,
			'std'      => 'full-width',
		),
	)
);

/* ----------------------------------------------------- */
// PORTFOLIO SETTINGS
/* ----------------------------------------------------- */

$meta_boxes[] = array(
	'id' 		=> 'portfoliosettings',
	'title' 	=> esc_html__( 'Portfolio Post General', 'softing' ),
	'pages' 	=> array( 'portfolio' ),
	'context' 	=> 'normal',
	'priority' 	=> 'high',
	'fields' 	=> array(

		array(
			'type' 		=> 'heading',
			'id'   		=> 'softing_page_design_section',
			'name'		=> esc_html__( 'Portfolio Popup Video', 'softing' ),
		),
		array(
			'name' 		=> esc_html__( 'Show in lightbox', 'softing' ),
			'desc' 		=> esc_html__( 'If selected, the image will be displayed in the light box when the image is clicked.', 'softing' ),
			'id'   		=> 'softing_port_showlbx',
			'type' 		=> 'checkbox',
			'std'  		=> 0,
		),
		array(
			'name'		=> esc_html__( 'Video url ( for simple in Lightbox )', 'softing' ),
			'desc'  	=> sprintf( esc_html__( 'This option for portfolio shortcode.You can add youtube or vimeo video for portfolio item. %s %s and %s %s', 'softing' ), '<b>Youtube URL format:</b>', '<code>https://www.youtube.com/watch?v=ZqnAGgjQ7Rs</code>', '<b>Vimeo URL format:</b>', '<code>https://vimeo.com/203116933</code>', 'softing' ),
			'id'   		=> 'softing_port_vidurl',
			'type'		=> 'text',
		),

	)
);


/* ----------------------------------------------------- */
// EVENT POST SETTINGS
/* ----------------------------------------------------- */

$meta_boxes[] = array(
	'id' 		=> 'portfoliosettings',
	'title' 	=> esc_html__( 'Event Post General', 'softing' ),
	'pages' 	=> array( 'event' ),
	'context' 	=> 'normal',
	'priority' 	=> 'high',
	'fields' 	=> array(

		array(
			'type' 		=> 'heading',
			'id'   		=> 'softing_post_design_section',
			'name'		=> esc_html__( 'Event Post Details', 'softing' ),
		),
		array(
			'id'		=> 'softing_event_map',
			'name'		=> esc_html__( 'Event avunue', 'softing' ),
			'clone'		=> false,
			'type'		=> 'text',
		),
		array(
			'id'		=> 'softing_event_eventdate',
			'name'		=> esc_html__( 'Event time', 'softing' ),
			'clone'		=> false,
			'type'		=> 'text',
		),
		array(
			'id'		=> 'softing_event_speakers',
			'name'		=> esc_html__( 'Event speakers', 'softing' ),
			'clone'		=> false,
			'type'		=> 'text',
		),
		array(
			'id'		=> 'softing_event_speakersjob',
			'name'		=> esc_html__( 'Event speakers position', 'softing' ),
			'clone'		=> false,
			'type'		=> 'text',
		),
		array(
			'id'        => 'softing_event_speakersimg',
			'name'		=> esc_html__( 'Event speakers image', 'softing' ),
			'type'      => 'image_advanced',
			'max_file_uploads' => 1,
		),
		array(
			'name' 		=> esc_html__('Event single details slider images', 'softing'),
			'desc' 		=> esc_html__('Select the images from the media library.', 'softing'),
			'id'   		=> 'softing_single_gallery',
			'type' 		=> 'image_advanced',
		)
	)
);

/*----------------------------------------------------------------------------------*/
/*  GALLERY POST FORMAT
/*-----------------------------------------------------------------------------------*/

$meta_boxes[] = array(
	'title'    	=> esc_html__('Gallery Settings', 'softing'),
	'id'    	=> 'gallery-settings',
	'pages'    	=> array('post'),
	'fields' 	=> array(
		array(
			'name' 		=> esc_html__('Select Images', 'softing'),
			'desc' 		=> esc_html__('Select the images from the media library or upload your new ones.', 'softing'),
			'id'   		=> 'softing_gallery',
			'type' 		=> 'image_advanced',
		)
	)
);


/*----------------------------------------------------------------------------------*/
/*  VIDEO & AUDIO EMBED POST FORMAT
/*-----------------------------------------------------------------------------------*/

$meta_boxes[] = array(
	'title'    	=> esc_html__('Embeded Content', 'softing'),
	'id'    	=> 'embed-settings',
	'pages'    	=> array('post'),
	'fields' 	=> array(

		array(
			'name' 		=> esc_html__('Embeded Code', 'softing'),
			'desc' 		=> esc_html__('You can add any content before post content box.', 'softing'),
			'id'   		=> 'softing_embed_content',
			'type' 		=> 'textarea',
			'rows' 		=> 8
		)
	)
);
	//end
	return $meta_boxes;
}
