<?php

	get_header();

	$softing_blog_layout = isset($softing['index_layout']) && $softing['index_layout'] != '' ? $softing['index_layout'] : 'right-sidebar';
	$softing_index_hero_off = isset($softing['blog_hero']) && $softing['blog_hero'] == '0' ? ' hero-off' : '';
	$softing_blog_layout_ctrl = $softing_blog_layout == 'full-width' ? 'col-lg-12 col-md-12' :  'col-lg-8 col-md-8'; // sidebar setting
	$softing_index_sidebar = $softing_blog_layout == 'full-width' ? ' no-sidebar '.$softing_blog_layout : ' has-sidebar '.$softing_blog_layout;

	do_action("softing_before_index");

?>

<!-- Index Page General -->
<div id="nt-blog" class="nt-blog">

	<?php softing_hero_section(); ?>

	<!-- Blog Content -->
	<div class="nt-theme-inner-container blog-area full-width bg-gray default-padding<?php echo esc_attr( $softing_index_sidebar.$softing_index_hero_off ); ?>">
		<!-- Section Content -->
		<div class="container">
			<!-- Row -->
			<div class="row">

				<div class="blog-items">

					<!-- Left Sidebar -->
					<?php
						if( $softing_blog_layout == 'left-sidebar' ) {
							get_sidebar();
						}
					?>

					<!-- Column -->
					<?php if (  is_active_sidebar( 'sidebar-1' )  ) { ?>
					<div class="<?php echo esc_attr( $softing_blog_layout_ctrl ); ?>">
					<?php } else { ?>
					<div class="col-lg-12 col-md-12">
					<?php } ?>

					<?php

						if ( have_posts() ) :

							while ( have_posts() ) : the_post();

								// if there are posts, run softing_post_format function -> contain all post formats
								softing_post_format();

							endwhile;

							// this function working with wp reading settins + posts
							softing_index_loop_pagination();

						else :
							// if there are no posts, read content none function
							softing_content_none();

						endif;

					?>

					</div>
					<!-- End Column -->

				</div>
				<!-- End Blog-Items-->

				<!-- Right Sidebar -->
				<?php if( $softing_blog_layout == 'right-sidebar' || $softing_blog_layout == '' ){
					get_sidebar();
				} ?>

			</div>
			<!-- End Row -->
		</div>
		<!-- End Section Content -->
	</div>
	<!-- End Blog Content -->

</div>
<!-- End Index Page General-->

<?php

	do_action("softing_after_index");

	get_footer();

?>
