<?php

	get_header();

	$softing_page_layout = rwmb_meta( 'softing_page_layout' );
	$softing_page_layout_ctrl = ( $softing_page_layout == 'left-sidebar' OR $softing_page_layout == 'right-sidebar' ) ? 'col-lg-8' : 'col-lg-12' ; // sidebar setting
	$softing_page_sidebar = ( $softing_page_layout == 'left-sidebar' OR $softing_page_layout == 'right-sidebar' ) ? ' has-sidebar '.$softing_page_layout : ' no-sidebar '.$softing_page_layout;
	$softing_page_hero = rwmb_meta( 'softing_page_hero_display' );
	$softing_page_hero_off = $softing_page_hero == '1' ? ' hero-off' : '';

	do_action("softing_before_page");

?>

<!-- Default Page General -->
<div id="nt-page" class="nt-page">

	<!-- Hero Section -->
	<?php softing_hero_section(); // this function using on all inner pages ?>

	<!-- Page Content -->
	<div class="nt-theme-inner-container bg-gray default-padding<?php echo esc_attr( $softing_page_sidebar.$softing_page_hero_off ); ?>">
		<!-- Section Content -->
		<div class="container">
			<!-- Row -->
			<div class="row">

				<!-- Left Sidebar -->
				<?php if ( $softing_page_layout == 'left-sidebar' ){
					get_sidebar();
				} ?>

				<!-- Content -->
				<?php if (  is_active_sidebar( 'sidebar-1' )  ) { ?>
				<div class="<?php echo esc_attr( $softing_page_layout_ctrl ); ?>">
				<?php } else { ?>
				<div class="col-lg-12 col-md-12">
				<?php } ?>

				<?php

					while ( have_posts() ) : the_post(); ?>

					<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

						<div class="nt-page-template-content nt-theme-content nt-clearfix">

							<?php

								/* translators: %s: Name of current post */
								the_content( sprintf(
									esc_html__( 'Continue reading %s', 'softing' ),
									the_title( '<span class="screen-reader-text">', '</span>', false )
								) );

								/* theme page link pagination */
								softing_wp_link_pages();

								// If comments are open or we have at least one comment, load up the comment template.
								if ( comments_open() || get_comments_number() ) {
									comments_template();
								}

							?>

						</div>

				<?php


					// End the loop.
					endwhile;

				?>

				<!-- End Template Content -->

				</div>
				<!--End Post -->

				</div>
				<!-- End Sidebar None -->

				<!-- Right Sidebar -->
				<?php if( $softing_page_layout =='right-sidebar' ){
					get_sidebar();
				} ?>

			</div>
			<!-- Row -->
		</div>
		<!-- End Section Content -->
	</div>
	<!-- End Page Content -->
</div>
<!-- End Page Page General -->

<?php

	do_action("softing_after_page");

	get_footer();

?>
