<?php

	get_header();

	$softing_search_layout = isset($softing['search_layout']) && $softing['search_layout'] != '' ? $softing['search_layout'] : 'right-sidebar';
	$softing_search_layout_ctrl = ( $softing_search_layout == 'left-sidebar' OR $softing_search_layout == 'right-sidebar' ) ? 'col-lg-8' : 'col-lg-12' ; // sidebar setting
	$softing_search_sidebar = ( $softing_search_layout == 'left-sidebar' OR $softing_search_layout == 'right-sidebar' ) ? ' has-sidebar '.$softing_search_layout : ' no-sidebar '.$softing_search_layout;
	$softing_search_hero_off = isset($softing['search_hero']) && $softing['search_hero'] == '0' ? ' hero-off' : '';

	do_action("softing_before_search");

?>

<!-- Search Page General -->
<div id="nt-search" class="nt-search">

	<!-- Hero Section -->
	<?php softing_hero_section(); // this function using on all inner pages ?>

	<!-- Search Content -->
	<div class="nt-theme-inner-container blog-area full-width bg-gray default-padding<?php echo esc_attr( $softing_search_sidebar.$softing_search_hero_off ); ?>">
		<!-- Section Content -->
		<div class="container">
			<!-- Row -->
			<div class="row">

				<div class="blog-items">

					<!-- Left Sidebar -->
					<?php if( $softing_search_layout == 'left-sidebar' ) { get_sidebar(); } ?>

					<!-- Content -->
					<?php if (  is_active_sidebar( 'sidebar-1' )  ) { ?>
					<div class="<?php echo esc_attr( $softing_search_layout_ctrl ); ?>">
					<?php } else { ?>
					<div class="col-lg-12 col-md-12">
					<?php } ?>

						<?php

							if ( have_posts() ) {
								while ( have_posts() ) : the_post();
										softing_post_format();
								endwhile;
							} else {
								// old file type was content-none.php
								softing_content_none();
							}
							// this function working with wp reading settins + posts
							softing_index_loop_pagination();

						?>

					</div>
					<!-- End Sidebar None -->
				</div>
				<!-- End Blog-items -->

				<!-- Right Sidebar -->
				<?php if( $softing_search_layout == 'right-sidebar' || $softing_search_layout == '' ){  get_sidebar(); } ?>

			</div>
			<!-- Row -->
		</div>
		<!-- End Section Content -->
	</div>
	<!-- End Search Content -->
</div>
<!-- End Search Page General -->

<?php

	do_action("softing_after_search");

	get_footer();

?>
