<?php

	get_header();

	$softing_single_layout = isset($softing['single_layout']) && $softing['single_layout'] != '' ? $softing['single_layout'] : 'right-sidebar';
	$softing_single_layout_ctrl = ( $softing_single_layout == 'left-sidebar' OR $softing_single_layout == 'right-sidebar' ) ? 'col-lg-8 col-md-8' : 'col-lg-12'; // sidebar setting
	$softing_single_sidebar = ( $softing_single_layout == 'left-sidebar' OR $softing_single_layout == 'right-sidebar' ) ? ' has-sidebar '.$softing_single_layout : ' no-sidebar '.$softing_single_layout;
	$softing_single_hero_off = isset($softing['single_hero']) && $softing['single_hero'] == '0' ? ' hero-off' : '';
	$softing_single_comment_off = isset($softing['single_comment_onoff']) && $softing['single_comment_onoff'] != '' ? $softing['single_comment_onoff'] : '1';

	do_action("softing_before_post_single");

?>

	<!-- Single page general div -->
	<div id="nt-single" class="nt-single">

		<!-- Hero Section -->
		<?php softing_hero_section(); //this function using on all inner pages ?>

		<!-- Single Content -->
		<div class="nt-theme-inner-container blog-area bg-gray full-width single default-padding<?php echo esc_attr( $softing_single_sidebar.$softing_single_hero_off ); ?>">
			<!-- Section Content -->
			<div class="container">
				<div class="row">

					<!-- Left sidebar -->
					<?php
						if( $softing_single_layout == 'left-sidebar' ) {
							if( is_active_sidebar('softing-single-sidebar') ){ ?>

								<div id="nt-sidebar" class="nt-sidebar col-lg-4 col-md-4">
									<div class="nt-sidebar-inner">

										<?php dynamic_sidebar('softing-single-sidebar'); ?>

									</div><!-- End nt-sidebar-inner -->
								</div><!-- End nt-sidebar -->

						<?php

							} else {
								get_sidebar();
							}

						}
					?>

					 <div class="blog-items">


						<!-- Content -->
						<?php if (  is_active_sidebar( 'sidebar-1' ) || is_active_sidebar('softing-single-sidebar') ) { ?>
						<div class="<?php echo esc_attr( $softing_single_layout_ctrl ); ?>">
						<?php } else { ?>
						<div class="col-lg-12 col-md-12 ">
						<?php } ?>

							<div class="item nt-theme-content nt-clearfix">

								<?php

									// Post content
									while ( have_posts() ) : the_post();

										// Post meta
										softing_single_post_content();

									endwhile;

									// Post navigation 1 = on and 0 = off
									softing_single_navigation();

									// Author box 1 = on and 0 = off
									softing_single_post_author_box();


									// Post comments
									if ( $softing_single_comment_off != '0' ) {
										if ( comments_open() || '0' != get_comments_number() ) {
											comments_template();
										}
									}

							echo '</div>'; // nt-theme-content

								// You may also like 1 = on and 0 = off
								softing_single_post_related();

							?>

						</div>
						<!-- End Column -->
					</div>
					<!-- End blog-items -->

					<!-- Right sidebar -->
					<?php
						if( $softing_single_layout == 'right-sidebar' || $softing_single_layout == '' ) {
							if( is_active_sidebar('softing-single-sidebar') ){ ?>

								<div id="nt-sidebar" class="nt-sidebar col-lg-4 col-md-4">
									<div class="nt-sidebar-inner">

										<?php dynamic_sidebar('softing-single-sidebar'); ?>

									</div><!-- End nt-sidebar-inner -->
								</div><!-- End nt-sidebar -->

						<?php

							} else {
								get_sidebar();
							}

						}
					?>

				</div>
				<!-- End row -->
			</div>
			<!-- End container -->
		</div>
		<!-- End Single Content -->
	</div>
	<!--End Single Page General Div -->

<?php

	do_action("softing_after_post_single");

	get_footer();

?>
