<?php


// Filter to replace default css class names for vc_row shortcode and vc_column
add_filter( 'vc_shortcodes_css_class', 'softing_css_classes_for_vc_row_and_vc_column', 10, 2 );
function softing_css_classes_for_vc_row_and_vc_column( $class_string, $tag ) {

  if ( $tag == 'vc_column' || $tag == 'vc_column_inner' ) {

  $class_string = preg_replace( '/vc_col-xs-(\d{1,2})/', 'col-$1', $class_string );
  $class_string = preg_replace( '/vc_col-xs-offset-(\d{1,2})/', 'col-$1', $class_string );
  $class_string = preg_replace( '/vc_col-sm-(\d{1,2})/', 'col-sm-$1', $class_string );
  $class_string = preg_replace( '/vc_col-sm-offset-(\d{1,2})/', 'col-sm-offset-$1', $class_string );
  $class_string = preg_replace( '/vc_col-md-(\d{1,2})/', 'col-md-$1', $class_string );
  $class_string = preg_replace( '/vc_col-md-offset-(\d{1,2})/', 'col-md-offset-$1', $class_string );
  $class_string = preg_replace( '/vc_col-lg-(\d{1,2})/', 'col-lg-$1', $class_string );
  $class_string = preg_replace( '/vc_col-lg-offset-(\d{1,2})/', 'col-lg-offset-$1', $class_string );

  }

  return $class_string; // Important: you should always return modified or original $class_string

}
if(function_exists('vc_add_shortcode_param')) { // ignore theme check

    vc_add_shortcode_param('nt_spacer', 'softing_param_settings_field');
    function softing_param_settings_field($settings, $value)
    {
        return '<div name="' . esc_attr( $settings['param_name'] ) . '" class="nt_spacer_block wpb_vc_param_value ' . esc_attr( $settings['param_name'] ) . '""></div>'; // emtpy param for group description
    }

    vc_add_shortcode_param('nt_hr', 'softing_param_type_hr_field');
    function softing_param_type_hr_field($settings, $value)
    {
        return '<div name="' . esc_attr( $settings['param_name'] ) . '" class="nt_hr wpb_vc_param_value ' . esc_attr( $settings['param_name'] ) . '""></div>'; // emtpy param for group description
    }

    vc_add_shortcode_param('nt_row_divider', 'softing_param_row_divider');
    function softing_param_row_divider( $settings, $value ) {
     return '<div name="' . esc_attr( $settings['param_name'] ) . '" class="nt-divider wpb_vc_param_value ' . esc_attr( $settings['param_name'] ) . '">
     <img src= "'.get_template_directory_uri() . '/vc_templates/divider/d'.$settings['value'].'.svg"></div>';
    }
}

/***************************************************
*custom vc responsive and extra css
*
*Usage fuction is available in the vc elements
*
*for example in vc_column and other vc_elements
****************************************************/

if ( ! function_exists( 'softing_vc_extra_css' ) ){
function softing_vc_extra_css($atts, $softing_unique_class = '', $softing_extra = ''){

  extract( $atts );

  //custom code start
  $unique_class = $softing_unique_class;

  // large device
  $lg_bg = array();
  $lg_bg[] = $softing_lg_bgpos != '' && $softing_lg_bgpos != 'custom' ? '.'.$unique_class.'{background-position:'.$softing_lg_bgpos.'!important;}' : '';
  $lg_bg[] = $softing_lg_bgpos=='customlgpos' && $softing_lg_custom_bgpos != '' ? '.'.$unique_class.'{background-position:'.$softing_lg_custom_bgpos.'!important;}' : '';
  $lg_bg = !empty($lg_bg) ? implode( ' ', array_filter( $lg_bg ) ) : '';

  // medium device
  $md_media = $md_custom_media == 'yes' && $md_custom_css_media != '' ? $md_custom_css_media : '@media (max-width: 992px)';
  $md_bg = array();
  $md_bg[] = $softing_md_hidebg == 'off' ? 'background-image:none!important;': '';
  $md_bg[] = $softing_md_bgpos != '' &&  $softing_md_bgpos != 'custom' ? 'background-position:'.$softing_md_bgpos.'!important;' : '';
  $md_bg[] = $softing_md_bgpos == 'custom' &&  $softing_md_custom_bgpos != '' ? 'background-position:'.$softing_md_custom_bgpos.'!important;' : '';
  $md_bg  = !empty($md_bg) ? implode( ' ', array_filter( $md_bg ) ) : '';

  // small device
  $sm_media = $sm_custom_media == 'yes' && $sm_custom_css_media != '' ? $sm_custom_css_media : '@media (max-width: 768px)';
  $sm_bg = array();
  $sm_bg[] = $softing_sm_hidebg == 'off' ? 'background-image:none!important;': '';
  $sm_bg[] = $softing_sm_bgpos != '' &&  $softing_sm_bgpos != 'custom' ? 'background-position:'.$softing_sm_bgpos.'!important;' : '';
  $sm_bg[] = $softing_sm_bgpos == 'custom' &&  $softing_sm_custom_bgpos != '' ? 'background-position:'.$softing_sm_custom_bgpos.'!important;' : '';
  $sm_bg  = !empty($sm_bg) ? implode( ' ', array_filter( $sm_bg ) ) : '';

  // extra small device
  $xs_media = $xs_custom_media == 'yes' && $xs_custom_css_media != '' ? $xs_custom_css_media : '@media (max-width: 576px)';
  $xs_bg = array();
  $xs_bg[] = $softing_xs_hidebg == 'off' ? 'background-image:none!important;': '';
  $xs_bg[] = $softing_xs_bgpos != '' &&  $softing_xs_bgpos != 'custom' ? 'background-position:'.$softing_xs_bgpos.'!important;' : '';
  $xs_bg[] = $softing_xs_bgpos == 'custom' &&  $softing_xs_custom_bgpos != '' ? 'background-position:'.$softing_xs_custom_bgpos.'!important;' : '';
  $xs_bg  = !empty($xs_bg) ? implode( ' ', array_filter( $xs_bg ) ) : '';


  //get only css properties from the css editor
  $md_css = preg_replace('/.vc_custom_[0-9]*{/', ' ', $softing_md_css );
  $md_css = preg_replace('/}/', ' ', $md_css );

  $sm_css = preg_replace('/.vc_custom_[0-9]*{/', ' ', $softing_sm_css );
  $sm_css = preg_replace('/}/', ' ', $sm_css );

  $xs_css = preg_replace('/.vc_custom_[0-9]*{/', ' ', $softing_xs_css );
  $xs_css = preg_replace('/}/', ' ', $xs_css );

  //create responsive media from css
  $respon = array();
  $respon[] = $lg_bg;
  $respon[] = $md_css != '' || $md_bg != '' ? $md_media.' {.'.$unique_class.'{'.$md_bg.$md_css.'}}' : '';
  $respon[] = $sm_css != '' || $sm_bg != '' ? $sm_media.' {.'.$unique_class.'{'.$sm_bg.$sm_css.'}}' : '';
  $respon[] = $xs_css != '' || $xs_bg != '' ? $xs_media.' {.'.$unique_class.'{'.$xs_bg.$xs_css.'}}' : '';

  $respon[] = is_array($softing_extra) && !empty($softing_extra) ? implode( ' ', array_filter( $softing_extra ) ) : $softing_extra;
  //add css to in attr data-res-css
  $respon = !empty($respon) ? implode( ' ', array_filter( $respon ) ) : false;
  $respon = $respon != false ? ' data-res-css="'.$respon.'"' : false;
  // end

	return $respon;
}
}


    //FOR ROW SVG divider OPTIONS
    $softing_vc_row_svg_divider = array(
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Use section svg shape divider?', 'softing'),
            'param_name' => 'nt_shape_divider',
            'value' => array( esc_html__('Yes', 'softing') => 'yes' ),
            'group' => esc_html__('Divider', 'softing'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Divider Type', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'divider_style',
            'value' => array(
                esc_html__('Select a option', 'softing') => '',
                esc_html__('Type 1', 'softing') => 'type-1',
                esc_html__('Type 2', 'softing') => 'type-2',
                esc_html__('Type 3', 'softing') => 'type-3',
                esc_html__('Type 4', 'softing') => 'type-4',
                esc_html__('Type 5', 'softing') => 'type-5',
                esc_html__('Type 6', 'softing') => 'type-6',
                esc_html__('Type 7', 'softing') => 'type-7',
                esc_html__('Type 8', 'softing') => 'type-8',
                esc_html__('Type 9', 'softing') => 'type-9',
                esc_html__('Type 10', 'softing') => 'type-10',
            ),
            'dependency' => array(
                'element' => 'nt_shape_divider',
                'not_empty' => true
            )
        ),
        array(
            'type' => 'nt_row_divider',
            'heading' => esc_html__('Preview', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'divider1',
            'value' => '1',
            'dependency' => array(
                'element' => 'divider_style',
                'value' => 'type-1'
            )
        ),
        array(
            'type' => 'nt_row_divider',
            'heading' => esc_html__('Preview', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'divider2',
            'value' => '2',
            'dependency' => array(
                'element' => 'divider_style',
                'value' => 'type-2'
            )
        ),
        array(
            'type' => 'nt_row_divider',
            'heading' => esc_html__('Preview', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'divider3',
            'value' => '3',
            'dependency' => array(
                'element' => 'divider_style',
                'value' => 'type-3'
            )
        ),
        array(
            'type' => 'nt_row_divider',
            'heading' => esc_html__('Preview', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'divider4',
            'value' => '4',
            'dependency' => array(
                'element' => 'divider_style',
                'value' => 'type-4'
            )
        ),
        array(
            'type' => 'nt_row_divider',
            'heading' => esc_html__('Preview', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'divider5',
            'value' => '5',
            'dependency' => array(
                'element' => 'divider_style',
                'value' => 'type-5'
            )
        ),
        array(
            'type' => 'nt_row_divider',
            'heading' => esc_html__('Preview', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'divider6',
            'value' => '6',
            'dependency' => array(
                'element' => 'divider_style',
                'value' => 'type-6'
            )
        ),
        array(
            'type' => 'nt_row_divider',
            'heading' => esc_html__('Preview', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'divider7',
            'value' => '7',
            'dependency' => array(
                'element' => 'divider_style',
                'value' => 'type-7'
            )
        ),
        array(
            'type' => 'nt_row_divider',
            'heading' => esc_html__('Preview', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'divider8',
            'value' => '8',
            'dependency' => array(
                'element' => 'divider_style',
                'value' => 'type-8'
            )
        ),
        array(
            'type' => 'nt_row_divider',
            'heading' => esc_html__('Preview', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'divider9',
            'value' => '9',
            'dependency' => array(
                'element' => 'divider_style',
                'value' => 'type-9'
            )
        ),
        array(
            'type' => 'nt_row_divider',
            'heading' => esc_html__('Preview', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'divider10',
            'value' => '10',
            'dependency' => array(
                'element' => 'divider_style',
                'value' => 'type-10'
            )
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Divider Position', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'divider_position',
            'edit_field_class' => 'vc_col-sm-4',
            'value' => array(
                esc_html__('Select a option', 'softing') => '',
                esc_html__('Top', 'softing') => 'top',
                esc_html__('Bottom', 'softing') => 'bottom',
            ),
            'dependency' => array(
                'element' => 'nt_shape_divider',
                'not_empty' => true
            )
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Divider Height', 'softing'),
            'description' => esc_html__('Use simple number.Default svg width is 450', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'divider_height',
            'edit_field_class' => 'vc_col-sm-4',
            'dependency' => array(
                'element' => 'nt_shape_divider',
                'not_empty' => true
            )
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Divider Color', 'softing'),
            'description' => esc_html__('Default color is white.', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'divider_color',
            'edit_field_class' => 'vc_col-sm-4',
            'dependency' => array(
                'element' => 'nt_shape_divider',
                'not_empty' => true
            )
        ),
        array(
            'type' => 'nt_spacer',
            'heading' => esc_html__('Rotation Options', 'softing'),
            'param_name' => 'divider_responsive_spacer',
            'group' => esc_html__('Divider', 'softing' ),
            'dependency' => array(
                'element' => 'nt_shape_divider',
                'not_empty' => true
            )
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Rotate X Axis (180deg)?', 'softing' ),
            'param_name' => 'divider_rotate_x',
            'value' => array( esc_html__( 'Yes', 'softing' ) => 'yes' ),
            'group' => esc_html__('Divider', 'softing' ),
            'edit_field_class' => 'vc_col-sm-4',
            'dependency' => array(
                'element' => 'nt_shape_divider',
                'not_empty' => true
            )
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Rotate Y Axis (180deg)?', 'softing' ),
            'param_name' => 'divider_rotate_y',
            'value' => array( esc_html__( 'Yes', 'softing' ) => 'yes' ),
            'group' => esc_html__('Divider', 'softing' ),
            'edit_field_class' => 'vc_col-sm-4',
            'dependency' => array(
                'element' => 'nt_shape_divider',
                'not_empty' => true
            )
        ),
        array(
            'type' => 'nt_spacer',
            'heading' => esc_html__('Resposive Options', 'softing'),
            'param_name' => 'divider_responsive_spacer2',
            'group' => esc_html__('Divider', 'softing' ),
            'dependency' => array(
                'element' => 'nt_shape_divider',
                'not_empty' => true
            )
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Desktop Height', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'lg_divider_height',
            'edit_field_class' => 'vc_col-sm-4',
            'dependency' => array(
                'element' => 'nt_shape_divider',
                'not_empty' => true
            )
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Tablet Height', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'md_divider_height',
            'edit_field_class' => 'vc_col-sm-4',
            'dependency' => array(
                'element' => 'nt_shape_divider',
                'not_empty' => true
            )
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Phone Height', 'softing'),
            'group' => esc_html__('Divider', 'softing'),
            'param_name' => 'sm_divider_height',
            'edit_field_class' => 'vc_col-sm-4',
            'dependency' => array(
                'element' => 'nt_shape_divider',
                'not_empty' => true
            )
        )
    );

	// add prebuilt padding and margin to vc_row, vc_row_inner
	$softing_add_responsive_spacing = array(
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Prebuilt padding spacing', 'softing' ),
		'param_name'	=> 'softing_row_prepad',
		'group'			=> esc_html__('Design Options', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6',
		'value'			=> array(
			esc_html__('Top and Bottom padding', 'softing' )	=> '',
			esc_html__('160px', 'softing' )	=> 'ptb-160',
			esc_html__('150px', 'softing' )	=> 'ptb-150',
			esc_html__('140px', 'softing' )	=> 'ptb-140',
			esc_html__('130px', 'softing' )	=> 'ptb-130',
			esc_html__('120px', 'softing' )	=> 'ptb-120',
			esc_html__('110px', 'softing' )	=> 'ptb-110',
			esc_html__('100px', 'softing' )	=> 'ptb-100',
			esc_html__('90px', 'softing' )	=> 'ptb-90',
			esc_html__('80px', 'softing' )	=> 'ptb-80',
			esc_html__('70px', 'softing' )	=> 'ptb-70',
			esc_html__('60px', 'softing' )	=> 'ptb-60',
			esc_html__('50px', 'softing' )	=> 'ptb-50',
			esc_html__('40px', 'softing' )	=> 'ptb-40',
			esc_html__('30px', 'softing' )	=> 'ptb-30',
			esc_html__('20px', 'softing' )	=> 'ptb-20',
			esc_html__('10px', 'softing' )	=> 'ptb-10',
			),
		),
	);
	$softing_add_responsive_order_column = array(
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Equal Height?', 'softing' ),
		'param_name'    => 'softing_col_eqheight',
		'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'equal-height' ),
		),
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('1200px display', 'softing' ),
		'param_name'	=> 'softing_col_lg_order',
		'weight' 		=> -1,
		'group'			=> esc_html__('Responsive Options', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		'value'			=> array(
			esc_html__('Column display', 'softing' ) => '',
			esc_html__('table-cell', 'softing' ) => 'lg-table-cell',
			esc_html__('block', 'softing' )	=> 'lg-block',
			),
		),
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('992px display', 'softing' ),
		'param_name'	=> 'softing_col_md_order',
		'weight' 		=> -1,
		'group'			=> esc_html__('Responsive Options', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		'value'			=> array(
			esc_html__('Column display', 'softing' ) => '',
			esc_html__('table-cell', 'softing' ) => 'md-table-cell',
			esc_html__('block', 'softing' )	=> 'md-block',
			),
		),
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('768px display', 'softing' ),
		'param_name'	=> 'softing_col_sm_order',
		'weight' 		=> -2,
		'group'			=> esc_html__('Responsive Options', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		'value'			=> array(
			esc_html__('Column display', 'softing' ) => '',
			esc_html__('table-cell', 'softing' ) => 'sm-table-cell',
			esc_html__('block', 'softing' )	=> 'sm-block',
			),
		),
	);

	// add new option to vc elements
	$softing_add_responsive_editor = array(

		// lg resolution
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Background position', 'softing' ),
		'param_name'	=> 'softing_lg_bgpos',
		'description'	=> esc_html__('Select background-position', 'softing' ),
		'group'			=> esc_html__('Design Options', 'softing' ),
		'value'			=> array(
			esc_html__('Select a option', 'softing' )	=> '',
			esc_html__('center',   		'softing' )	=> 'center',
			esc_html__('left',    		'softing' )	=> 'left',
			esc_html__('right',    		'softing' )	=> 'right',
			esc_html__('top',   		'softing' )	=> 'top',
			esc_html__('bottom',   		'softing' )	=> 'bottom',
			esc_html__('center-left',   'softing' )	=> 'center left',
			esc_html__('center-right',  'softing' )	=> 'center right',
			esc_html__('center-top',    'softing' )	=> 'center top',
			esc_html__('center-bottom', 'softing' )	=> 'center bottom',
			esc_html__('left-center',   'softing' )	=> 'left center',
			esc_html__('left-top',   	'softing' )	=> 'left top',
			esc_html__('left-bottom',   'softing' )	=> 'left bottom',
			esc_html__('right-center',  'softing' )	=> 'right center',
			esc_html__('right-top',   	'softing' )	=> 'right top',
			esc_html__('right-bottom',  'softing' )	=> 'right bottom',
			esc_html__('top-center',   	'softing' )	=> 'top center',
			esc_html__('top-left',   	'softing' )	=> 'top left',
			esc_html__('top-right',   	'softing' )	=> 'top right',
			esc_html__('bottom-center', 'softing' )	=> 'bottom center',
			esc_html__('bottom-left',   'softing' )	=> 'bottom left',
			esc_html__('bottom-right',  'softing' )	=> 'bottom right',
			esc_html__('Custom position', 'softing' )	=> 'custom',
		),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Custom background position', 'softing' ),
		'param_name'	=> 'softing_lg_custom_bgpos',
		'description'	=> esc_html__('Set background image position.e.g: 100% or 400px or 300px 500px or 50% 50% or .....etc', 'softing' ),
		'group'			=> esc_html__('Design Options', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6',
		'dependency' 	=> array(
			'element' 	=> 'softing_lg_bgpos',
			'value'   	=> 'custom'
		)
		),
		// 992px resolution
		array(
		'type' 			=> 'nt_spacer',
		'holder' 		=> 'div',
		'heading' 		=> esc_html__('Resposive options ( maximum device width 992px )', 'softing'),
		'param_name' 	=> '992_desc',
		'weight' 		=> -1,
		'group'			=> esc_html__('992px', 'softing' )
		),
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Use custom medium device size', 'softing' ),
		'param_name'    => 'md_custom_media',
		'weight' 		=> -2,
		'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'yes' ),
		'description'   => sprintf( esc_html__( 'If checked, you can use custom css media.Default theme media is %s for medium device.', 'softing' ), '<code>@media ( max-width:992px )</code>' ),
		'group' 	  	=> esc_html__('992px', 'softing' ),
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Custom responsive medium media size', 'softing' ),
		'param_name'	=> 'md_custom_css_media',
		'weight' 		=> -3,
		'description'   => sprintf( esc_html__( 'Add your custom css media for medium device.e.g:  %s or %s or etc...', 'softing' ), '<code>@media ( max-width:1023px )</code>', '<code>@media ( min-width:1023px )</code>' ),
		'group' 	  	=> esc_html__('992px', 'softing' ),
		'dependency' 	=> array(
			'element' 	=> 'md_custom_media',
			'not_empty' => true
		)
		),
		array(
		'type' 			=> 'css_editor',
		'heading' 		=> esc_html__( 'Max width 992px resolution', 'softing' ),
		'param_name' 	=> 'softing_md_css',
		'weight' 		=> -8,
		'description' 	=> esc_html__( 'These options for 992px resolution - responsive media or your custom media size', 'softing' ),
		'group'			=> esc_html__('992px', 'softing' )
		),
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Background position', 'softing' ),
		'param_name'	=> 'softing_md_bgpos',
		'weight' 		=> -9,
		'description'	=> esc_html__('Select background-position', 'softing' ),
		'group'			=> esc_html__('992px', 'softing' ),
		'value'			=> array(
			esc_html__('Select a option', 'softing' )	=> '',
			esc_html__('center',   		'softing' )	=> 'center',
			esc_html__('left',    		'softing' )	=> 'left',
			esc_html__('right',    		'softing' )	=> 'right',
			esc_html__('top',   		'softing' )	=> 'top',
			esc_html__('bottom',   		'softing' )	=> 'bottom',
			esc_html__('center-left',   'softing' )	=> 'center left',
			esc_html__('center-right',  'softing' )	=> 'center right',
			esc_html__('center-top',    'softing' )	=> 'center top',
			esc_html__('center-bottom', 'softing' )	=> 'center bottom',
			esc_html__('left-center',   'softing' )	=> 'left center',
			esc_html__('left-top',   	'softing' )	=> 'left top',
			esc_html__('left-bottom',   'softing' )	=> 'left bottom',
			esc_html__('right-center',  'softing' )	=> 'right center',
			esc_html__('right-top',   	'softing' )	=> 'right top',
			esc_html__('right-bottom',  'softing' )	=> 'right bottom',
			esc_html__('top-center',   	'softing' )	=> 'top center',
			esc_html__('top-left',   	'softing' )	=> 'top left',
			esc_html__('top-right',   	'softing' )	=> 'top right',
			esc_html__('bottom-center', 'softing' )	=> 'bottom center',
			esc_html__('bottom-left',   'softing' )	=> 'bottom left',
			esc_html__('bottom-right',  'softing' )	=> 'bottom right',
			esc_html__('Custom position', 'softing' )	=> 'custom',
		),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type' 			=> 'checkbox',
		'heading' 		=> esc_html__( 'Disable background image?', 'softing' ),
		'param_name' 	=> 'softing_md_hidebg',
		'weight' 		=> -10,
		'description' 	=> esc_html__( 'If checked, disables background image on devices with a maximum width of 992 pixels or your custom media size.', 'softing' ),
		'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'off' ),
		'group'			=> esc_html__('992px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Custom background position', 'softing' ),
		'param_name'	=> 'softing_md_custom_bgpos',
		'weight' 		=> -11,
		'description'	=> esc_html__('Set background image position.e.g: 100% or 400px or 300px 500px or 50% 50% or .....etc', 'softing' ),
		'group'			=> esc_html__('992px', 'softing' ),
		'dependency' 	=> array(
			'element' 	=> 'softing_md_bgpos',
			'value'   	=> 'custom'
		)
		),
		// 768px resolution
		array(
		'type' 			=> 'nt_spacer',
		'holder' 		=> 'div',
		'weight' 		=> -1,
		'heading' 		=> esc_html__('Resposive options ( maximum device width 768px )', 'softing'),
		'param_name' 	=> '768_desc',
		'group'			=> esc_html__('768px', 'softing' )
		),
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Use custom small device size', 'softing' ),
		'param_name'    => 'sm_custom_media',
		'weight' 		=> -2,
		'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'yes' ),
		'description'   => sprintf( esc_html__( 'If checked, you can use custom css media.Default theme media is %s for small device.', 'softing' ), '<code>@media ( max-width:768px )</code>' ),
		'group' 	  	=> esc_html__('768px', 'softing' )
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Custom responsive small media size', 'softing' ),
		'param_name'	=> 'sm_custom_css_media',
		'weight' 		=> -3,
		'description'   => sprintf( esc_html__( 'Add your custom css media for small device.e.g:  %s or %s or etc...', 'softing' ), '<code>@media ( max-width:800px )</code>', '<code>@media ( min-width:800px )</code>' ),
		'group' 	  	=> esc_html__('768px', 'softing' ),
		'dependency' 	=> array(
			'element' 	=> 'sm_custom_media',
			'not_empty' => true
		)
		),
		array(
		'type' 			=> 'css_editor',
		'heading' 		=> esc_html__( 'Max width 768px resolution', 'softing' ),
		'param_name' 	=> 'softing_sm_css',
		'weight' 		=> -8,
		'description' 	=> esc_html__( 'These options for 768px resolution - responsive media or your custom media size', 'softing' ),
		'group'			=> esc_html__('768px', 'softing' )
		),
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Background position', 'softing' ),
		'param_name'	=> 'softing_sm_bgpos',
		'weight' 		=> -9,
		'description'	=> esc_html__('Select background-position', 'softing' ),
		'group'			=> esc_html__('768px', 'softing' ),
		'value'			=> array(
			esc_html__('Select a option',   'softing' )	=> '',
			esc_html__('center',   		'softing' )	=> 'center',
			esc_html__('left',    		'softing' )	=> 'left',
			esc_html__('right',    		'softing' )	=> 'right',
			esc_html__('top',   		'softing' )	=> 'top',
			esc_html__('bottom',   		'softing' )	=> 'bottom',
			esc_html__('center-left',   'softing' )	=> 'center left',
			esc_html__('center-right',  'softing' )	=> 'center right',
			esc_html__('center-top',    'softing' )	=> 'center top',
			esc_html__('center-bottom', 'softing' )	=> 'center bottom',
			esc_html__('left-center',   'softing' )	=> 'left center',
			esc_html__('left-top',   	'softing' )	=> 'left top',
			esc_html__('left-bottom',   'softing' )	=> 'left bottom',
			esc_html__('right-center',  'softing' )	=> 'right center',
			esc_html__('right-top',   	'softing' )	=> 'right top',
			esc_html__('right-bottom',  'softing' )	=> 'right bottom',
			esc_html__('top-center',   	'softing' )	=> 'top center',
			esc_html__('top-left',   	'softing' )	=> 'top left',
			esc_html__('top-right',   	'softing' )	=> 'top right',
			esc_html__('bottom-center', 'softing' )	=> 'bottom center',
			esc_html__('bottom-left',   'softing' )	=> 'bottom left',
			esc_html__('bottom-right',  'softing' )	=> 'bottom right',
			esc_html__('Custom position', 'softing' )	=> 'custom',
		),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type' 			=> 'checkbox',
		'heading' 		=> esc_html__( 'Disable background image?', 'softing' ),
		'param_name' 	=> 'softing_sm_hidebg',
		'weight' 		=> -10,
		'description' 	=> esc_html__( 'f checked, disables background image on devices with a maximum width of 768 pixels or your custom media size.', 'softing' ),
		'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'off' ),
		'group'			=> esc_html__('768px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Custom background position', 'softing' ),
		'param_name'	=> 'softing_sm_custom_bgpos',
		'weight' 		=> -11,
		'description'	=> esc_html__('Set background image position.e.g: 100% or 400px or 300px 500px or 50% 50% or .....etc', 'softing' ),
		'group'			=> esc_html__('768px', 'softing' ),
		'dependency' 	=> array(
			'element' 	=> 'softing_sm_bgpos',
			'value'   	=> 'custom'
		)
		),
		//576px resolution
		array(
		'type' 			=> 'nt_spacer',
		'holder' 		=> 'div',
		'heading' 		=> esc_html__('Resposive options ( maximum device width 576px )', 'softing'),
		'param_name' 	=> '576_desc',
		'weight' 		=> -1,
		'group'			=> esc_html__('576px', 'softing' )
		),
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Use custom extra small device size', 'softing' ),
		'param_name'    => 'xs_custom_media',
		'weight' 		=> -2,
		'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'yes' ),
		'description'   => sprintf( esc_html__( 'If checked, you can use custom css media.Default theme media is %s for extra small device.', 'softing' ), '<code>@media ( max-width:576px )</code>' ),
		'group' 	  	=> esc_html__('576px', 'softing' )
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Custom responsive extra small media size', 'softing' ),
		'param_name'	=> 'xs_custom_css_media',
		'weight' 		=> -3,
		'description'   => sprintf( esc_html__( 'Add your custom css media for extra small device.e.g:  %s or %s or etc...', 'softing' ), '<code>@media ( max-width:600px )</code>', '<code>@media ( min-width:600px )</code>' ),
		'group' 	  	=> esc_html__('576px', 'softing' ),
		'dependency' 	=> array(
			'element' 	=> 'xs_custom_media',
			'not_empty' => true
		)
		),
		array(
		'type' 			=> 'css_editor',
		'heading' 		=> esc_html__( 'Max width 576px resolution', 'softing' ),
		'param_name' 	=> 'softing_xs_css',
		'weight' 		=> -8,
		'description' 	=> esc_html__( 'These options for 576px resolution - responsive media or your custom media size', 'softing' ),
		'group'			=> esc_html__('576px', 'softing' )
		),
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Background position', 'softing' ),
		'param_name'	=> 'softing_xs_bgpos',
		'weight' 		=> -9,
		'description'	=> esc_html__('Select background-position', 'softing' ),
		'group'			=> esc_html__('576px', 'softing' ),
		'value'			=> array(
			esc_html__('Select a option',   'softing' )	=> '',
			esc_html__('center',   		'softing' )	=> 'center',
			esc_html__('left',    		'softing' )	=> 'left',
			esc_html__('right',    		'softing' )	=> 'right',
			esc_html__('top',   		'softing' )	=> 'top',
			esc_html__('bottom',   		'softing' )	=> 'bottom',
			esc_html__('center-left',   'softing' )	=> 'center left',
			esc_html__('center-right',  'softing' )	=> 'center right',
			esc_html__('center-top',    'softing' )	=> 'center top',
			esc_html__('center-bottom', 'softing' )	=> 'center bottom',
			esc_html__('left-center',   'softing' )	=> 'left center',
			esc_html__('left-top',   	'softing' )	=> 'left top',
			esc_html__('left-bottom',   'softing' )	=> 'left bottom',
			esc_html__('right-center',  'softing' )	=> 'right center',
			esc_html__('right-top',   	'softing' )	=> 'right top',
			esc_html__('right-bottom',  'softing' )	=> 'right bottom',
			esc_html__('top-center',   	'softing' )	=> 'top center',
			esc_html__('top-left',   	'softing' )	=> 'top left',
			esc_html__('top-right',   	'softing' )	=> 'top right',
			esc_html__('bottom-center', 'softing' )	=> 'bottom center',
			esc_html__('bottom-left',   'softing' )	=> 'bottom left',
			esc_html__('bottom-right',  'softing' )	=> 'bottom right',
			esc_html__('Custom position', 'softing' )	=> 'custom',
		),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type' 			=> 'checkbox',
		'heading' 		=> esc_html__( 'Disable background image?', 'softing' ),
		'param_name' 	=> 'softing_xs_hidebg',
		'weight' 		=> -10,
		'description' 	=> esc_html__( 'f checked, disables background image on devices with a maximum width of 576 pixels or your custom media size.', 'softing' ),
		'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'off' ),
		'group'			=> esc_html__('576px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Custom background position', 'softing' ),
		'param_name'	=> 'softing_xs_custom_bgpos',
		'weight' 		=> -11,
		'description'	=> esc_html__('Set background image position.e.g: 100% or 400px or 300px 500px or 50% 50% or .....etc', 'softing' ),
		'group'			=> esc_html__('576px', 'softing' ),
		'dependency' 	=> array(
			'element' 	=> 'softing_xs_bgpos',
			'value'   	=> 'custom'
		)
		)
	);


	/*-----------------------------------------------------------------------------------*/
	/*	Shortcode Filter
	/*-----------------------------------------------------------------------------------*/
    add_action( 'vc_after_init', 'softing_vc_shortcode_extra' );
    function softing_vc_shortcode_extra() {

		//Get current values stored in the color param in "Call to Action" element
		$param = WPBMap::getParam( 'vc_row', 'full_width' );
		//Append new value to the 'value' array
		$param['value'][esc_html__( 'Null', 'softing' )] = 'clear_layout';
		$param['admin_label'] = true;
		//Finally "mutate" param with new values
		vc_update_shortcode_param( 'vc_row', $param );
		//Get current values stored in the color param in "Call to Action" element
		$param = WPBMap::getParam( 'vc_row', 'parallax' );
		//Append new value to the 'value' array
		$param['value'][esc_html__( 'Theme scroll (extra)', 'softing' )] = 'softing-scroll';
		$param['value'][esc_html__( 'Theme scale (extra)', 'softing' )] = 'softing-scale';
		$param['value'][esc_html__( 'Theme opacity (extra)', 'softing' )] = 'softing-opacity';
		$param['value'][esc_html__( 'Theme scroll-opacity (extra)', 'softing' )] = 'softing-scroll-opacity';
		$param['value'][esc_html__( 'Theme scale-opacity (extra)', 'softing' )] = 'softing-scale-opacity';
		 //Finally "mutate" param with new values
		vc_update_shortcode_param( 'vc_row', $param );
		//Get current values stored in the color param in "Call to Action" element
		$param = WPBMap::getParam( 'vc_row', 'parallax_speed_bg' );
		$param['dependency']['not_empty']= 'value';
		WPBMap::mutateParam('vc_row', $param);

		$param = WPBMap::getParam( 'vc_row', 'parallax_speed_bg' );
		$param['dependency']['value']= array('content-moving', 'content-moving-fade');
		WPBMap::mutateParam('vc_row', $param);

		$param = WPBMap::getParam('vc_row', 'parallax_speed_bg');
		$param['weight'] = -1;
		vc_update_shortcode_param('vc_row', $param);

		$param = WPBMap::getParam('vc_row', 'css_animation');
		$param['weight'] = -2;
		vc_update_shortcode_param('vc_row', $param);

		$param = WPBMap::getParam('vc_row', 'el_id');
		$param['weight'] = -3;
		vc_update_shortcode_param('vc_row', $param);

		$param = WPBMap::getParam('vc_row', 'disable_element');
		$param['weight'] = -4;
		vc_update_shortcode_param('vc_row', $param);

		$param = WPBMap::getParam('vc_row', 'el_class');
		$param['weight'] = -5;
		vc_update_shortcode_param('vc_row', $param);

		//vc_single_image
		$param = WPBMap::getParam('vc_single_image', 'onclick');
        if (false != $param ) {
            $param['value'][esc_html__('Open Softing Lightbox', 'softing')] = 'mfp';
    		vc_update_shortcode_param('vc_single_image', $param);
        }
        $param = WPBMap::getParam('vc_single_image', 'el_id');
        if (false != $param ) {
    		$param['weight'] = -3;
    		vc_update_shortcode_param('vc_single_image', $param);
        }
        $param = WPBMap::getParam('vc_single_image', 'el_class');
        if (false != $param ) {
    		$param['weight'] = -4;
    		vc_update_shortcode_param('vc_single_image', $param);
        }
        $param = WPBMap::getParam('vc_single_image', 'css_animation');
        if (false != $param ) {
    		$param['weight'] = -2;
    		vc_update_shortcode_param('vc_single_image', $param);
        }

		//vc_btn_custom
		$param = WPBMap::getParam('vc_btn', 'style');
		$param['value'][esc_html__('Softing Button Default', 'softing')] = 'border';
		$param['value'][esc_html__('Softing Button Active', 'softing')] = 'effect';
		vc_update_shortcode_param('vc_btn', $param);
		$param = WPBMap::getParam('vc_btn', 'shape');
		$param['dependency']['element']= 'style';
		$param['dependency']['value_not_equal_to']= array('border', 'effect');
		vc_update_shortcode_param('vc_btn', $param);
		$param = WPBMap::getParam('vc_btn', 'color');
		$param['dependency']['element']= 'style';
		$param['dependency']['value_not_equal_to']= array('border', 'effect');
		vc_update_shortcode_param('vc_btn', $param);
		$param = WPBMap::getParam('vc_btn', 'add_icon');
		$param['dependency']['element']= 'style';
		$param['dependency']['value_not_equal_to']= array('border', 'effect');
		vc_update_shortcode_param('vc_btn', $param);
		$param = WPBMap::getParam('vc_btn', 'css_animation');
		$param['dependency']['element']= 'style';
		$param['dependency']['value_not_equal_to']= array('border', 'effect');
		vc_update_shortcode_param('vc_btn', $param);
		$param = WPBMap::getParam('vc_btn', 'el_id');
        if (false != $param ) {
    		$param['dependency']['element']= 'style';
    		$param['dependency']['value_not_equal_to']= array('border', 'effect');
    		vc_update_shortcode_param('vc_btn', $param);
        }
		$param = WPBMap::getParam('vc_btn', 'el_class');
		$param['dependency']['element']= 'style';
		$param['dependency']['value_not_equal_to']= array('border', 'effect');
		vc_update_shortcode_param('vc_btn', $param);
		$param = WPBMap::getParam('vc_btn', 'custom_onclick');
		$param['dependency']['element']= 'style';
		$param['dependency']['value_not_equal_to']= array('border', 'effect');
		vc_update_shortcode_param('vc_btn', $param);
		$param = WPBMap::getParam('vc_btn', 'align');
		$param['dependency']['element']= 'style';
		$param['dependency']['value_not_equal_to']= array('border', 'effect');
		vc_update_shortcode_param('vc_btn', $param);

		//vc_btn_custom
		$param = WPBMap::getParam('vc_tta_tabs', 'style');
		$param['value'][esc_html__('Softing Style', 'softing')] = 'theme';
		vc_update_shortcode_param('vc_tta_tabs', $param);
		//vc_btn_custom
		$param = WPBMap::getParam('vc_tta_accordion', 'style');
		$param['value'][esc_html__('Softing Style', 'softing')] = 'theme-accordion';
		vc_update_shortcode_param('vc_tta_accordion', $param);

		//vc_seperator
		$param = WPBMap::getParam('vc_separator', 'el_width');
		$param['value'][esc_html__('100px', 'softing')] = '1n';
		$param['value'][esc_html__('90px', 'softing')] = '9';
		$param['value'][esc_html__('80px', 'softing')] = '8';
		$param['value'][esc_html__('70px', 'softing')] = '7';
		$param['value'][esc_html__('60px', 'softing')] = '6';
		$param['value'][esc_html__('50px', 'softing')] = '5';
		$param['value'][esc_html__('40px', 'softing')] = '4';
		$param['value'][esc_html__('30px', 'softing')] = '3';
		$param['value'][esc_html__('20px', 'softing')] = '2';
		$param['value'][esc_html__('10px', 'softing')] = '1';
		vc_update_shortcode_param('vc_separator', $param);

    }

	//FOR CUSTOM VC BUTTON
	$softing_vc_custom_btn_extra = array(
		array(
		'type' 			=> 'textfield',
		'heading' 		=> esc_html__( 'Border width(px)', 'softing' ),
		'description'	=> esc_html__('Use number in px.e.g:2px', 'softing' ),
		'param_name' 	=> 'softing_vc_btn_brd',
		'edit_field_class' => 'vc_col-sm-3',
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'   	=> array('border', 'effect')
		),
		),
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Border style', 'softing' ),
		'param_name'	=> 'softing_vc_btn_brdstyle',
		'edit_field_class' => 'vc_col-sm-3',
		'value'			=> array(
			esc_html__('Select a option',   'softing' )	=> '',
			esc_html__('solid', 'softing' ) => 'solid',
			esc_html__('dotted', 'softing' ) => 'dotted',
			esc_html__('dashed', 'softing' ) => 'dashed',
		),
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'   	=> array('border', 'effect')
		),
		),
		array(
		'type' 			=> 'colorpicker',
		'heading' 		=> esc_html__( 'Border color', 'softing' ),
		'param_name' 	=> 'softing_vc_btn_brdclr',
		'edit_field_class' => 'vc_col-sm-3',
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'   	=> array('border', 'effect')
		),
		),
		array(
		'type' 			=> 'colorpicker',
		'heading' 		=> esc_html__( 'Hover Border', 'softing' ),
		'param_name' 	=> 'softing_vc_btn_hvrbrdclr',
		'edit_field_class' => 'vc_col-sm-3',
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'   	=> array('border', 'effect')
		),
		),
		array(
		'type' 			=> 'colorpicker',
		'heading' 		=> esc_html__( 'Background color', 'softing' ),
		'param_name' 	=> 'softing_vc_btn_bg',
		'edit_field_class' => 'vc_col-sm-3',
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'   	=> array('border', 'effect')
		),
		),
		array(
		'type' 			=> 'colorpicker',
		'heading' 		=> esc_html__( 'Hover Background', 'softing' ),
		'param_name' 	=> 'softing_vc_btn_hvrbg',
		'edit_field_class' => 'vc_col-sm-3',
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'   	=> array('border', 'effect')
		),
		),
		array(
		'type' 			=> 'colorpicker',
		'heading' 		=> esc_html__( 'Title color', 'softing' ),
		'param_name' 	=> 'softing_vc_btn_title',
		'edit_field_class' => 'vc_col-sm-3',
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'   	=> array('border', 'effect')
		),
		),
		array(
		'type' 			=> 'colorpicker',
		'heading' 		=> esc_html__( 'Hover Title', 'softing' ),
		'param_name' 	=> 'softing_vc_btn_hvrtitle',
		'edit_field_class' => 'vc_col-sm-3',
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'   	=> array('border', 'effect')
		)
		),
	);

	//FOR CUSTOM VC BUTTON
	vc_add_params( 'vc_btn', $softing_vc_custom_btn_extra );

	//FOR ROW EXTRA RESPONSIVE
	$softing_vc_row_extra_attributes = array(

	//new options for paralax
	array(
	'type' 			=> 'textfield',
	'heading' 		=> esc_html__( 'Theme Parallax speed', 'softing' ),
	'description' 	=> esc_html__( 'Enter parallax speed ratio (Note: Default value is 0.2, min value is 0.1)', 'softing' ),
	'param_name' 	=> 'softing_parallax_speed',
	'value' 		=> '0.2',
	'edit_field_class' => 'vc_col-sm-6',
	'dependency' 	=> array(
		'element' 	=> 'parallax',
		'value'   	=> array( 'softing-scroll', 'softing-scale','softing-opacity','softing-scroll-opacity','softing-scale-opacity' ),
	),
	),
	array(
	'type'			=> 'dropdown',
	'heading'		=> esc_html__('Parallax background opacity', 'softing' ),
	'description'	=> esc_html__('Select background-attachment', 'softing' ),
	'param_name'	=> 'softing_parallax_bg_opacity',
	'edit_field_class' => 'vc_col-sm-6',
	'value'			=> array(
		esc_html__('Select a option', 'softing' )	=> '',
		esc_html__('0.1', 'softing' )	=> '01',
		esc_html__('0.2', 'softing' )	=> '02',
		esc_html__('0.3', 'softing' )	=> '03',
		esc_html__('0.4', 'softing' )	=> '04',
		esc_html__('0.5', 'softing' )	=> '05',
		esc_html__('0.6', 'softing' )	=> '06',
		esc_html__('0.7', 'softing' )	=> '07',
		esc_html__('0.8', 'softing' )	=> '08',
		esc_html__('0.9', 'softing' )	=> '09',
		esc_html__('1',   'softing' )	=> '1',
		),
	'dependency' 	=> array(
		'element' 	=> 'parallax',
		'value'   	=> array( 'softing-scroll', 'softing-scale','softing-opacity','softing-scroll-opacity','softing-scale-opacity' ),
	),
	),
	array(
	'type'			=> 'dropdown',
	'heading'		=> esc_html__('Background size', 'softing' ),
	'description'	=> esc_html__('Select background-attachment', 'softing' ),
	'param_name'	=> 'softing_bg_size',
	'edit_field_class' => 'vc_col-sm-4',
	'value'			=> array(
		esc_html__('Select a option', 'softing' )	=> '',
		esc_html__('auto', 'softing' ) => 'auto',
		esc_html__('cover', 'softing' ) => 'cover',
		esc_html__('contain', 'softing' )	=> 'contain',
		esc_html__('Custom size',	'softing' ) => 'custom',
		),
	'dependency' 	=> array(
		'element' 	=> 'parallax',
		'value'   	=> array( 'softing-scroll', 'softing-scale','softing-opacity','softing-scroll-opacity','softing-scale-opacity' ),
	),
	),
	array(
	'type'			=> 'dropdown',
	'heading'		=> esc_html__('Background position', 'softing' ),
	'description'	=> esc_html__('Select background-position', 'softing' ),
	'param_name'	=> 'softing_bg_pos',
	'edit_field_class' => 'vc_col-sm-4',
	'value'			=> array(
		esc_html__('Select a option',   'softing' )	=> '',
		esc_html__('center',   		'softing' )	=> 'center',
		esc_html__('left',    		'softing' )	=> 'left',
		esc_html__('right',    		'softing' )	=> 'right',
		esc_html__('top',   		'softing' )	=> 'top',
		esc_html__('bottom',   		'softing' )	=> 'bottom',
		esc_html__('center-left',   'softing' )	=> 'center left',
		esc_html__('center-right',  'softing' )	=> 'center right',
		esc_html__('center-top',    'softing' )	=> 'center top',
		esc_html__('center-bottom', 'softing' )	=> 'center bottom',
		esc_html__('left-center',   'softing' )	=> 'left center',
		esc_html__('left-top',   	'softing' )	=> 'left top',
		esc_html__('left-bottom',   'softing' )	=> 'left bottom',
		esc_html__('right-center',  'softing' )	=> 'right center',
		esc_html__('right-top',   	'softing' )	=> 'right top',
		esc_html__('right-bottom',  'softing' )	=> 'right bottom',
		esc_html__('top-center',   	'softing' )	=> 'top center',
		esc_html__('top-left',   	'softing' )	=> 'top left',
		esc_html__('top-right',   	'softing' )	=> 'top right',
		esc_html__('bottom-center', 'softing' )	=> 'bottom center',
		esc_html__('bottom-left',   'softing' )	=> 'bottom left',
		esc_html__('bottom-right',  'softing' )	=> 'bottom right',
		esc_html__('Custom position','softing' )	=> 'custom',
		),
	'dependency' 	=> array(
		'element' 	=> 'parallax',
		'value'   	=> array( 'softing-scroll', 'softing-scale','softing-opacity','softing-scroll-opacity','softing-scale-opacity' ),
	),
	),
	array(
	'type'			=> 'dropdown',
	'heading'		=> esc_html__('Background repeat', 'softing' ),
	'description'	=> esc_html__('Select background-repeat', 'softing' ),
	'param_name'	=> 'softing_bg_repet',
	'edit_field_class' => 'vc_col-sm-4',
	'value'			=> array(
		esc_html__('Select a option',  'softing' )	=> '',
		esc_html__('no-repeat',   		'softing' )	=> 'no-repeat',
		esc_html__('repeat',   			'softing' )	=> 'repeat',
		esc_html__('repeat-x',   		'softing' )	=> 'repeat-x',
		esc_html__('repeat-y',   		'softing' )	=> 'repeat-y',
	),
	'dependency' 	=> array(
		'element' 	=> 'parallax',
		'value'   	=> array( 'softing-scroll', 'softing-scale','softing-opacity','softing-scroll-opacity','softing-scale-opacity' ),
	),
	),
	array(
	'type'			=> 'textfield',
	'heading'		=> esc_html__('Custom background size', 'softing' ),
	'description'	=> esc_html__('Set background image size.e.g: 100% or 400px or 300px 500px or 50% 50% or .....etc', 'softing' ),
	'param_name'	=> 'softing_custom_bg_size',
	'edit_field_class' => 'vc_col-sm-6',
	'dependency' 	=> array(
		'element' 	=> 'softing_bg_size',
		'value'   	=> 'custom'
	),
	),
	array(
	'type'			=> 'textfield',
	'heading'		=> esc_html__('Custom background position', 'softing' ),
	'description'	=> esc_html__('Set background image position.e.g: 100% or 400px or 300px 500px or 50% 50% or .....etc', 'softing' ),
	'param_name'	=> 'softing_custom_bg_pos',
	'edit_field_class' => 'vc_col-sm-6',
	'dependency' 	=> array(
		'element' 	=> 'softing_bg_pos',
		'value'   	=> 'custom'
	),
	),
	array(
	'type' 			=> 'checkbox',
	'heading' 		=> esc_html__( 'Disable Parallax on mobile devices?', 'softing' ),
	'description' 	=> esc_html__( 'Disables parallax on mobile devices if checked.', 'softing' ),
	'param_name' 	=> 'softing_mobile_parallax',
	'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'off' ),
	'dependency' 	=> array(
		'element' 	=> 'parallax',
		'value'   	=> array( 'softing-scroll', 'softing-scale','softing-opacity','softing-scroll-opacity','softing-scale-opacity' ),
	),
	),
	array(
	'type'			=> 'dropdown',
	'heading'		=> esc_html__('Row overflow', 'softing' ),
	'description'	=> esc_html__('Select row overflow', 'softing' ),
	'param_name'	=> 'softing_row_overflow',
	'value'			=> array(
		esc_html__('Select a option', 'softing' )	=> '',
		esc_html__('visible', 'softing' )	=> 'visible',
		esc_html__('hidden', 'softing' ) => 'hidden',
	),
	),
	array(
	'type'			=> 'textfield',
	'heading'		=> esc_html__('Row Z-index', 'softing' ),
	'description'	=> esc_html__('Add z-idex number for overflowed row', 'softing' ),
	'param_name'	=> 'softing_bg_zindex',
	'dependency' 	=> array(
		'element' 	=> 'softing_row_overflow',
		'value'   	=> 'visible',
	),
	),
	//design options grup
	array(
	'type'			=> 'dropdown',
	'heading'		=> esc_html__('Background overlay type', 'softing' ),
	'param_name'	=> 'softing_row_overlay_type',
	'group'			=> esc_html__('Design Options', 'softing' ),
	'value'			=> array(
		esc_html__('Select a option', 'softing' )	=> '',
		esc_html__('Black pattern image', 'softing' )	=> 'pattern-black',
		esc_html__('White pattern image', 'softing' )	=> 'pattern-white',
		esc_html__('Custom color', 'softing' )	=> 'custom',
	),
	'edit_field_class' => 'vc_col-sm-6',
	),
	array(
	'type' 			=> 'colorpicker',
	'heading' 		=> esc_html__( 'Row overlay color', 'softing' ),
	'description' 	=> esc_html__( 'Add overlay on background image.', 'softing' ),
	'param_name' 	=> 'softing_row_overlayclr',
	'group'			=> esc_html__('Design Options', 'softing' ),
	'dependency' 	=> array(
		'element' 	=> 'softing_row_overlay_type',
		'value'   	=> 'custom',
	),
	'edit_field_class' => 'vc_col-sm-6',
	),
	array(
	'type'			=> 'dropdown',
	'heading'		=> esc_html__('Background attachment', 'softing' ),
	'param_name'	=> 'softing_bg_attachment',
	'description'	=> esc_html__('Select background-position', 'softing' ),
	'group'			=> esc_html__('Design Options', 'softing' ),
	'value'			=> array(
		esc_html__('Select a option', 'softing' )	=> '',
		esc_html__('fixed', 'softing' ) => 'fixed',
		esc_html__('scroll', 'softing' ) => 'scroll',
		esc_html__('inherit', 'softing' )	=> 'inherit',
	),
	'edit_field_class' => 'vc_col-sm-4',
	),
);

$softing_vc_single_img_extra = array(
	array(
	'type'			=> 'textfield',
	'heading'		=> esc_html__('Lightbox title', 'softing'),
	'param_name'	=> 'softing_img_title',
	'description'	=> esc_html__('Add description for lightbox image', 'softing'),
	'std'			=> 'This is an example of a creative caption',
	'weight'		=> -1,
	'dependency' 	=> array(
		'element' 	=> 'onclick',
		'value' 	=> 'mfp',
	),
	),
	//overlay image
	array(
	'type'			=> 'dropdown',
	'heading'		=> esc_html__('Image Hover Style', 'softing' ),
	'param_name'	=> 'softing_hover_style',
	'group'			=> esc_html__('softing Extra', 'softing' ),
	'value'			=> array(
		esc_html__('Select a option','softing' )=> '',
		esc_html__('opacity','softing' )		=> 'has_opacity',
		esc_html__('overlay color','softing' )	=> 'has_overlay',
		esc_html__('scale transform','softing' )=> 'has_transform',
	),
	),
	//Opacity
	array(
	'type'			=> 'textfield',
	'heading'		=> esc_html__('Opacity', 'softing' ),
	'param_name'	=> 'softing_img_op',
	'description'	=> esc_html__('Use simple number.Min: 0 and Max: 1. example:0.65', 'softing' ),
	'group'			=> esc_html__('softing Extra', 'softing' ),
	'edit_field_class' => 'vc_col-sm-6',
	'dependency' 	=> array(
		'element' 	=> 'softing_hover_style',
		'value' 	=> 'has_opacity',
	),
	),
	array(
	'type'			=> 'textfield',
	'heading'		=> esc_html__('Hover Opacity', 'softing' ),
	'param_name'	=> 'softing_img_hvr_op',
	'description'	=> esc_html__('Use simple number.Min: 0 and Max: 1. example:0.9', 'softing' ),
	'group'			=> esc_html__('softing Extra', 'softing' ),
	'edit_field_class' => 'vc_col-sm-6',
	'dependency' 	=> array(
		'element' 	=> 'softing_hover_style',
		'value' 	=> 'has_opacity',
	),
	),
	//Overlay
	array(
	'type'			=> 'colorpicker',
	'heading'		=> esc_html__('Overlay color', 'softing'),
	'param_name'	=> 'softing_img_overlay',
	'description'	=> esc_html__('Change overlay color.default: transparent black', 'softing'),
	'group'			=> esc_html__('softing Extra', 'softing' ),
	'dependency' 	=> array(
		'element' 	=> 'softing_hover_style',
		'value' 	=> 'has_overlay',
	),
	),
	//scale
	array(
	'type'			=> 'textfield',
	'heading'		=> esc_html__('Scale', 'softing' ),
	'param_name'	=> 'softing_img_trans',
	'description'	=> esc_html__('Enter the maximum growth scale of the image.example:1.1', 'softing' ),
	'group'			=> esc_html__('softing Extra', 'softing' ),
	'dependency' 	=> array(
		'element' 	=> 'softing_hover_style',
		'value' 	=> 'has_transform',
	),
	),
	//max-width
	array(
	'type'			=> 'textfield',
	'heading'		=> esc_html__('Image max-width', 'softing' ),
	'param_name'	=> 'softing_maxwidth',
	'description'	=> esc_html__('Use simple number in px or unit.example:62px, 50%....etc', 'softing' ),
	'group'			=> esc_html__('softing Extra', 'softing' ),
	),

	// 992px resolution group
	array(
	'type'			=> 'dropdown',
	'heading'		=> esc_html__('Image alignment', 'softing' ),
	'param_name'	=> 'res_img_md_aling',
	'group'			=> esc_html__('992px', 'softing' ),
	'value'			=> array(
		esc_html__('Select a option', 'softing' )	=> '',
		esc_html__('center', 'softing' ) => 'center',
		esc_html__('left', 'softing' ) => 'left',
		esc_html__('right', 'softing' ) => 'right',
	),
	),
	// 768px resolution group
	array(
	'type'			=> 'dropdown',
	'heading'		=> esc_html__('Image alignment', 'softing' ),
	'param_name'	=> 'res_img_sm_aling',
	'group'			=> esc_html__('768px', 'softing' ),
	'value'			=> array(
		esc_html__('Select a option',   'softing' )	=> '',
		esc_html__('center', 'softing' ) => 'center',
		esc_html__('left', 'softing' ) => 'left',
		esc_html__('right', 'softing' ) => 'right',
	),
	),
	// 576px resolution group
	array(
	'type'			=> 'dropdown',
	'heading'		=> esc_html__('Image alignment', 'softing' ),
	'param_name'	=> 'res_img_xs_aling',
	'group'			=> esc_html__('576px', 'softing' ),
	'value'			=> array(
		esc_html__('Select a option', 'softing' )	=> '',
		esc_html__('center', 'softing' ) => 'center',
		esc_html__('left', 'softing' ) => 'left',
		esc_html__('right', 'softing' ) => 'right',
	),
	),
	);


   //FOR CUSTOM HEADING
	$softing_vc_custom_heading_extra = array(

		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Font-family', 'softing' ),
		'param_name'	=> 'softing_ch_family',
		'description'	=> esc_html__('You can select an option for using general theme font weight', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		'value'			=> array(
			esc_html__('Select', 'softing' ) => '',
			esc_html__('Open Sans', 'softing' ) => 'open-sans',
			esc_html__('Poppins', 'softing' )	=> 'poppins',
		),
		'dependency' 	=> array(
			'element' 	=> 'use_theme_fonts',
			'not_empty' => true
		)
		),
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Font-weight', 'softing' ),
		'param_name'	=> 'softing_ch_fw',
		'description'	=> esc_html__('You can select an option for using general theme font weight', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		'value'			=> array(
			esc_html__('Select a option', 'softing' ) => '',
			esc_html__('Open Sans 400', 'softing' )	=> 'fw-400',
			esc_html__('Open Sans 600', 'softing' ) => 'fw-600',
			esc_html__('Open Sans 700', 'softing' ) => 'fw-700',
			esc_html__('Open Sans 800', 'softing' ) => 'fw-800',
			esc_html__('Poppins 400', 'softing' )	=> 'fw-400',
			esc_html__('Poppins 500', 'softing' ) => 'fw-500',
			esc_html__('Poppins 600', 'softing' ) => 'fw-600',
			esc_html__('Poppins 700', 'softing' ) => 'fw-700',
			esc_html__('Poppins 800', 'softing' ) => 'fw-800',
		),
		'dependency' 	=> array(
			'element' 	=> 'use_theme_fonts',
			'not_empty' => true,
		)
		),
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Text transform', 'softing' ),
		'param_name'	=> 'softing_ch_trans',
		'description'	=> esc_html__('You can select an option for text transform', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		'value'			=> array(
			esc_html__('inherit', 'softing' )	=> 'inherit',
			esc_html__('none', 'softing' ) => 'none',
			esc_html__('uppercase', 'softing' ) => 'uppercase',
			esc_html__('lowercase', 'softing' ) => 'lowercase',
			esc_html__('capitalize', 'softing' )=> 'capitalize',
		),
		'dependency' 	=> array(
			'element' 	=> 'use_theme_fonts',
			'not_empty' => true
		)
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Letter spacing', 'softing' ),
		'param_name'	=> 'softing_ch_lts',
		'description'	=> esc_html__('Use number in px or unit.e.g: 2px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		'dependency' 	=> array(
			'element' 	=> 'use_theme_fonts',
			'not_empty' => true
		)
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Word spacing', 'softing' ),
		'param_name'	=> 'softing_ch_wrds',
		'description'	=> esc_html__('Use number in px or unit.e.g: 5px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		'dependency' 	=> array(
			'element' 	=> 'use_theme_fonts',
			'not_empty' => true
		)
		),
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Prebuilt margin bottom', 'softing' ),
		'param_name'	=> 'softing_ch_premarb',
		'edit_field_class' => 'vc_col-sm-4',
		'value'			=> array(
			esc_html__('Bottom padding', 'softing' ) => '',
			esc_html__('60px', 'softing' )	=> 'mb-60',
			esc_html__('55px', 'softing' )	=> 'mb-55',
			esc_html__('50px', 'softing' )	=> 'mb-50',
			esc_html__('45px', 'softing' )	=> 'mb-45',
			esc_html__('40px', 'softing' )	=> 'mb-40',
			esc_html__('35px', 'softing' )	=> 'mb-35',
			esc_html__('30px', 'softing' )	=> 'mb-30',
			esc_html__('25px', 'softing' )	=> 'mb-25',
			esc_html__('20px', 'softing' )	=> 'mb-20',
			esc_html__('15px', 'softing' )	=> 'mb-15',
			esc_html__('10px', 'softing' )	=> 'mb-10',
			esc_html__('5px', 'softing' )	=> 'mb-5',
			esc_html__('0px', 'softing' )	=> 'mb-0',
			),
		'dependency' 	=> array(
			'element' 	=> 'use_theme_fonts',
			'not_empty' => true
		)
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Bold text color', 'softing'),
		'param_name'	=> 'softing_ch_bclr',
		'dependency' 	=> array(
			'element' 	=> 'use_theme_fonts',
			'not_empty' => true
		)
		),


		// 992px
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Text-align', 'softing' ),
		'param_name'	=> 'res_md_align',
		'weight' 		=> -4,
		'group'			=> esc_html__('992px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		'value'			=> array(
			esc_html__('Select alignment', 'softing' ) => '',
			esc_html__('center', 'softing' ) => 'center',
			esc_html__('left', 'softing' ) => 'left',
			esc_html__('right', 'softing' ) => 'right'
		)
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Font-size', 'softing' ),
		'param_name'	=> 'res_md_ch_fs',
		'weight' 		=> -5,
		'description'	=> esc_html__('Use number in px or unit', 'softing' ),
		'group' 	  	=> esc_html__('992px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Line-height', 'softing' ),
		'param_name'	=> 'res_md_lh',
		'weight' 		=> -6,
		'description'	=> esc_html__('Use number in px or unit', 'softing' ),
		'group' 	  	=> esc_html__('992px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Letter-spacing', 'softing' ),
		'param_name'	=> 'res_md_lts',
		'weight' 		=> -7,
		'description'	=> esc_html__('Use number in px or unit', 'softing' ),
		'group' 	  	=> esc_html__('992px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3'
		),
		// RESPOSIVE 768PX
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Text-align', 'softing' ),
		'param_name'	=> 'res_sm_align',
		'weight' 		=> -4,
		'group'			=> esc_html__('768px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		'value'			=> array(
			esc_html__('Select option', 'softing' )	=> '',
			esc_html__('center', 'softing' ) => 'center',
			esc_html__('left', 'softing' ) => 'left',
			esc_html__('right', 'softing' ) => 'right'
		)
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Font-size', 'softing' ),
		'param_name'	=> 'res_sm_ch_fs',
		'weight' 		=> -5,
		'description'	=> esc_html__('Use number in px or unit', 'softing' ),
		'group' 	  	=> esc_html__('768px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Line-height', 'softing' ),
		'param_name'	=> 'res_sm_lh',
		'weight' 		=> -6,
		'description'	=> esc_html__('Use number in px or unit', 'softing' ),
		'group' 	  	=> esc_html__('768px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Letter-spacing', 'softing' ),
		'param_name'	=> 'res_sm_lts',
		'weight' 		=> -7,
		'description'	=> esc_html__('Use number in px or unit', 'softing' ),
		'group' 	  	=> esc_html__('768px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3'
		),
		// RESPOSIVE 576PX
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Text-align', 'softing' ),
		'param_name'	=> 'res_xs_align',
		'weight' 		=> -4,
		'group'			=> esc_html__('576px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		'value'			=> array(
			esc_html__('Select alignment', 	'softing' ) => '',
			esc_html__('center', 'softing' ) => 'center',
			esc_html__('left', 'softing' ) => 'left',
			esc_html__('right', 'softing' ) => 'right'
		)
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Font-size', 'softing' ),
		'param_name'	=> 'res_xs_ch_fs',
		'weight' 		=> -5,
		'description'	=> esc_html__('Use number in px or unit', 'softing' ),
		'group' 	  	=> esc_html__('576px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Line-height', 'softing' ),
		'param_name'	=> 'res_xs_lh',
		'weight' 		=> -6,
		'description'	=> esc_html__('Use number in px or unit', 'softing' ),
		'group' 	  	=> esc_html__('576px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Letter-spacing', 'softing' ),
		'param_name'	=> 'res_xs_lts',
		'weight' 		=> -7,
		'description'	=> esc_html__('Use number in px or unit', 'softing' ),
		'group' 	  	=> esc_html__('576px', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3'
		)
	);

	//for custom heading
	vc_add_params( 'vc_custom_heading', $softing_vc_custom_heading_extra );
	vc_add_params( 'vc_custom_heading', $softing_add_responsive_editor );
	//for row
	vc_add_params( 'vc_row', $softing_add_responsive_spacing );
	vc_add_params( 'vc_row', $softing_vc_row_extra_attributes );
    vc_add_params('vc_row', $softing_vc_row_svg_divider);
	vc_add_params( 'vc_row', $softing_add_responsive_editor );
	//for inner row
	vc_add_params( 'vc_row_inner', $softing_add_responsive_spacing );
	vc_add_params( 'vc_row_inner', $softing_add_responsive_editor );
	//for column
	vc_add_params( 'vc_column', $softing_add_responsive_order_column );
	vc_add_params( 'vc_column', $softing_add_responsive_editor );
	//for column inner
	vc_add_params( 'vc_column_inner', $softing_add_responsive_order_column );
	vc_add_params( 'vc_column_inner', $softing_add_responsive_editor );
	//for single image
	vc_add_params( 'vc_single_image', $softing_vc_single_img_extra );
	vc_add_params( 'vc_single_image', $softing_add_responsive_editor );


    // Add new custom font to Font Family selection in icon box module
    function softing_add_fontawesome()
    {
        $param = WPBMap::getParam('vc_icon', 'type');
        $param['value'][__('Fontawesome', 'softing')] = 'fontawesomeall';
        vc_update_shortcode_param('vc_icon', $param);
    }
    add_filter('init', 'softing_add_fontawesome', 40);

    // Add font picker setting to icon box module when you select your font family from the dropdown
    function softing_add_fontawesome_picker()
    {
        vc_add_param(
            'vc_icon',
            array(
                'type' => 'iconpicker',
                'weight' => 1,
                'heading' => esc_html__('Icon', 'softing'),
                'param_name' => 'icon_fontawesomeall',
                'settings' => array(
                        'emptyIcon' => false,
                        'type' => 'fontawesomeall',
                        'iconsPerPage' => 200,
                ),
                'dependency' => array(
                        'element' => 'type',
                        'value' => 'fontawesomeall',
                ),
            )
        );
    }
    add_filter('vc_after_init', 'softing_add_fontawesome_picker', 40);

add_filter('vc_iconpicker-type-fontawesomeall', 'softing_icon_fontawesome_array');
function softing_icon_fontawesome_array() {

    return array (
        array ('fab fa-500px' => esc_html__( '500px', 'softing' )),
        array ('fab fa-accessible-icon' => esc_html__( 'accessible-icon', 'softing' )),
        array ('fab fa-accusoft' => esc_html__( 'accusoft', 'softing' )),
        array ('fas fa-address-book' => esc_html__( 'address-book', 'softing' )),
        array ('far fa-address-book' => esc_html__( 'address-book', 'softing' )),
        array ('fas fa-address-card' => esc_html__( 'address-card', 'softing' )),
        array ('far fa-address-card' => esc_html__( 'address-card', 'softing' )),
        array ('fas fa-adjust' => esc_html__( 'adjust', 'softing' )),
        array ('fab fa-adn' => esc_html__( 'adn', 'softing' )),
        array ('fab fa-adversal' => esc_html__( 'adversal', 'softing' )),
        array ('fab fa-affiliatetheme' => esc_html__( 'affiliatetheme', 'softing' )),
        array ('fab fa-algolia' => esc_html__( 'algolia', 'softing' )),
        array ('fas fa-align-center' => esc_html__( 'align-center', 'softing' )),
        array ('fas fa-align-justify' => esc_html__( 'align-justify', 'softing' )),
        array ('fas fa-align-left' => esc_html__( 'align-left', 'softing' )),
        array ('fas fa-align-right' => esc_html__( 'align-right', 'softing' )),
        array ('fas fa-allergies' => esc_html__( 'allergies', 'softing' )),
        array ('fab fa-amazon' => esc_html__( 'amazon', 'softing' )),
        array ('fab fa-amazon-pay' => esc_html__( 'amazon-pay', 'softing' )),
        array ('fas fa-ambulance' => esc_html__( 'ambulance', 'softing' )),
        array ('fas fa-american-sign-language-interpreting' => esc_html__( 'american-sign-language-interpreting', 'softing' )),
        array ('fab fa-amilia' => esc_html__( 'amilia', 'softing' )),
        array ('fas fa-anchor' => esc_html__( 'anchor', 'softing' )),
        array ('fab fa-android' => esc_html__( 'android', 'softing' )),
        array ('fab fa-angellist' => esc_html__( 'angellist', 'softing' )),
        array ('fas fa-angle-double-down' => esc_html__( 'angle-double-down', 'softing' )),
        array ('fas fa-angle-double-left' => esc_html__( 'angle-double-left', 'softing' )),
        array ('fas fa-angle-double-right' => esc_html__( 'angle-double-right', 'softing' )),
        array ('fas fa-angle-double-up' => esc_html__( 'angle-double-up', 'softing' )),
        array ('fas fa-angle-down' => esc_html__( 'angle-down', 'softing' )),
        array ('fas fa-angle-left' => esc_html__( 'angle-left', 'softing' )),
        array ('fas fa-angle-right' => esc_html__( 'angle-right', 'softing' )),
        array ('fas fa-angle-up' => esc_html__( 'angle-up', 'softing' )),
        array ('fab fa-angrycreative' => esc_html__( 'angrycreative', 'softing' )),
        array ('fab fa-angular' => esc_html__( 'angular', 'softing' )),
        array ('fab fa-app-store' => esc_html__( 'app-store', 'softing' )),
        array ('fab fa-app-store-ios' => esc_html__( 'app-store-ios', 'softing' )),
        array ('fab fa-apper' => esc_html__( 'apper', 'softing' )),
        array ('fab fa-apple' => esc_html__( 'apple', 'softing' )),
        array ('fab fa-apple-pay' => esc_html__( 'apple-pay', 'softing' )),
        array ('fas fa-archive' => esc_html__( 'archive', 'softing' )),
        array ('fas fa-arrow-alt-circle-down' => esc_html__( 'arrow-alt-circle-down', 'softing' )),
        array ('far fa-arrow-alt-circle-down' => esc_html__( 'arrow-alt-circle-down', 'softing' )),
        array ('fas fa-arrow-alt-circle-left' => esc_html__( 'arrow-alt-circle-left', 'softing' )),
        array ('far fa-arrow-alt-circle-left' => esc_html__( 'arrow-alt-circle-left', 'softing' )),
        array ('fas fa-arrow-alt-circle-right' => esc_html__( 'arrow-alt-circle-right', 'softing' )),
        array ('far fa-arrow-alt-circle-right' => esc_html__( 'arrow-alt-circle-right', 'softing' )),
        array ('fas fa-arrow-alt-circle-up' => esc_html__( 'arrow-alt-circle-up', 'softing' )),
        array ('far fa-arrow-alt-circle-up' => esc_html__( 'arrow-alt-circle-up', 'softing' )),
        array ('fas fa-arrow-circle-down' => esc_html__( 'arrow-circle-down', 'softing' )),
        array ('fas fa-arrow-circle-left' => esc_html__( 'arrow-circle-left', 'softing' )),
        array ('fas fa-arrow-circle-right' => esc_html__( 'arrow-circle-right', 'softing' )),
        array ('fas fa-arrow-circle-up' => esc_html__( 'arrow-circle-up', 'softing' )),
        array ('fas fa-arrow-down' => esc_html__( 'arrow-down', 'softing' )),
        array ('fas fa-arrow-left' => esc_html__( 'arrow-left', 'softing' )),
        array ('fas fa-arrow-right' => esc_html__( 'arrow-right', 'softing' )),
        array ('fas fa-arrow-up' => esc_html__( 'arrow-up', 'softing' )),
        array ('fas fa-arrows-alt' => esc_html__( 'arrows-alt', 'softing' )),
        array ('fas fa-arrows-alt-h' => esc_html__( 'arrows-alt-h', 'softing' )),
        array ('fas fa-arrows-alt-v' => esc_html__( 'arrows-alt-v', 'softing' )),
        array ('fas fa-assistive-listening-systems' => esc_html__( 'assistive-listening-systems', 'softing' )),
        array ('fas fa-asterisk' => esc_html__( 'asterisk', 'softing' )),
        array ('fab fa-asymmetrik' => esc_html__( 'asymmetrik', 'softing' )),
        array ('fas fa-at' => esc_html__( 'at', 'softing' )),
        array ('fab fa-audible' => esc_html__( 'audible', 'softing' )),
        array ('fas fa-audio-description' => esc_html__( 'audio-description', 'softing' )),
        array ('fab fa-autoprefixer' => esc_html__( 'autoprefixer', 'softing' )),
        array ('fab fa-avianex' => esc_html__( 'avianex', 'softing' )),
        array ('fab fa-aviato' => esc_html__( 'aviato', 'softing' )),
        array ('fab fa-aws' => esc_html__( 'aws', 'softing' )),
        array ('fas fa-backward' => esc_html__( 'backward', 'softing' )),
        array ('fas fa-balance-scale' => esc_html__( 'balance-scale', 'softing' )),
        array ('fas fa-ban' => esc_html__( 'ban', 'softing' )),
        array ('fas fa-band-aid' => esc_html__( 'band-aid', 'softing' )),
        array ('fab fa-bandcamp' => esc_html__( 'bandcamp', 'softing' )),
        array ('fas fa-barcode' => esc_html__( 'barcode', 'softing' )),
        array ('fas fa-bars' => esc_html__( 'bars', 'softing' )),
        array ('fas fa-baseball-ball' => esc_html__( 'baseball-ball', 'softing' )),
        array ('fas fa-basketball-ball' => esc_html__( 'basketball-ball', 'softing' )),
        array ('fas fa-bath' => esc_html__( 'bath', 'softing' )),
        array ('fas fa-battery-empty' => esc_html__( 'battery-empty', 'softing' )),
        array ('fas fa-battery-full' => esc_html__( 'battery-full', 'softing' )),
        array ('fas fa-battery-half' => esc_html__( 'battery-half', 'softing' )),
        array ('fas fa-battery-quarter' => esc_html__( 'battery-quarter', 'softing' )),
        array ('fas fa-battery-three-quarters' => esc_html__( 'battery-three-quarters', 'softing' )),
        array ('fas fa-bed' => esc_html__( 'bed', 'softing' )),
        array ('fas fa-beer' => esc_html__( 'beer', 'softing' )),
        array ('fab fa-behance' => esc_html__( 'behance', 'softing' )),
        array ('fab fa-behance-square' => esc_html__( 'behance-square', 'softing' )),
        array ('fas fa-bell' => esc_html__( 'bell', 'softing' )),
        array ('far fa-bell' => esc_html__( 'bell', 'softing' )),
        array ('fas fa-bell-slash' => esc_html__( 'bell-slash', 'softing' )),
        array ('far fa-bell-slash' => esc_html__( 'bell-slash', 'softing' )),
        array ('fas fa-bicycle' => esc_html__( 'bicycle', 'softing' )),
        array ('fab fa-bimobject' => esc_html__( 'bimobject', 'softing' )),
        array ('fas fa-binoculars' => esc_html__( 'binoculars', 'softing' )),
        array ('fas fa-birthday-cake' => esc_html__( 'birthday-cake', 'softing' )),
        array ('fab fa-bitbucket' => esc_html__( 'bitbucket', 'softing' )),
        array ('fab fa-bitcoin' => esc_html__( 'bitcoin', 'softing' )),
        array ('fab fa-bity' => esc_html__( 'bity', 'softing' )),
        array ('fab fa-black-tie' => esc_html__( 'black-tie', 'softing' )),
        array ('fab fa-blackberry' => esc_html__( 'blackberry', 'softing' )),
        array ('fas fa-blind' => esc_html__( 'blind', 'softing' )),
        array ('fab fa-blogger' => esc_html__( 'blogger', 'softing' )),
        array ('fab fa-blogger-b' => esc_html__( 'blogger-b', 'softing' )),
        array ('fab fa-bluetooth' => esc_html__( 'bluetooth', 'softing' )),
        array ('fab fa-bluetooth-b' => esc_html__( 'bluetooth-b', 'softing' )),
        array ('fas fa-bold' => esc_html__( 'bold', 'softing' )),
        array ('fas fa-bolt' => esc_html__( 'bolt', 'softing' )),
        array ('fas fa-bomb' => esc_html__( 'bomb', 'softing' )),
        array ('fas fa-book' => esc_html__( 'book', 'softing' )),
        array ('fas fa-bookmark' => esc_html__( 'bookmark', 'softing' )),
        array ('far fa-bookmark' => esc_html__( 'bookmark', 'softing' )),
        array ('fas fa-bowling-ball' => esc_html__( 'bowling-ball', 'softing' )),
        array ('fas fa-box' => esc_html__( 'box', 'softing' )),
        array ('fas fa-box-open' => esc_html__( 'box-open', 'softing' )),
        array ('fas fa-boxes' => esc_html__( 'boxes', 'softing' )),
        array ('fas fa-braille' => esc_html__( 'braille', 'softing' )),
        array ('fas fa-briefcase' => esc_html__( 'briefcase', 'softing' )),
        array ('fas fa-briefcase-medical' => esc_html__( 'briefcase-medical', 'softing' )),
        array ('fab fa-btc' => esc_html__( 'btc', 'softing' )),
        array ('fas fa-bug' => esc_html__( 'bug', 'softing' )),
        array ('fas fa-building' => esc_html__( 'building', 'softing' )),
        array ('far fa-building' => esc_html__( 'building', 'softing' )),
        array ('fas fa-bullhorn' => esc_html__( 'bullhorn', 'softing' )),
        array ('fas fa-bullseye' => esc_html__( 'bullseye', 'softing' )),
        array ('fas fa-burn' => esc_html__( 'burn', 'softing' )),
        array ('fab fa-buromobelexperte' => esc_html__( 'buromobelexperte', 'softing' )),
        array ('fas fa-bus' => esc_html__( 'bus', 'softing' )),
        array ('fab fa-buysellads' => esc_html__( 'buysellads', 'softing' )),
        array ('fas fa-calculator' => esc_html__( 'calculator', 'softing' )),
        array ('fas fa-calendar' => esc_html__( 'calendar', 'softing' )),
        array ('far fa-calendar' => esc_html__( 'calendar', 'softing' )),
        array ('fas fa-calendar-alt' => esc_html__( 'calendar-alt', 'softing' )),
        array ('far fa-calendar-alt' => esc_html__( 'calendar-alt', 'softing' )),
        array ('fas fa-calendar-check' => esc_html__( 'calendar-check', 'softing' )),
        array ('far fa-calendar-check' => esc_html__( 'calendar-check', 'softing' )),
        array ('fas fa-calendar-minus' => esc_html__( 'calendar-minus', 'softing' )),
        array ('far fa-calendar-minus' => esc_html__( 'calendar-minus', 'softing' )),
        array ('fas fa-calendar-plus' => esc_html__( 'calendar-plus', 'softing' )),
        array ('far fa-calendar-plus' => esc_html__( 'calendar-plus', 'softing' )),
        array ('fas fa-calendar-times' => esc_html__( 'calendar-times', 'softing' )),
        array ('far fa-calendar-times' => esc_html__( 'calendar-times', 'softing' )),
        array ('fas fa-camera' => esc_html__( 'camera', 'softing' )),
        array ('fas fa-camera-retro' => esc_html__( 'camera-retro', 'softing' )),
        array ('fas fa-capsules' => esc_html__( 'capsules', 'softing' )),
        array ('fas fa-car' => esc_html__( 'car', 'softing' )),
        array ('fas fa-caret-down' => esc_html__( 'caret-down', 'softing' )),
        array ('fas fa-caret-left' => esc_html__( 'caret-left', 'softing' )),
        array ('fas fa-caret-right' => esc_html__( 'caret-right', 'softing' )),
        array ('fas fa-caret-square-down' => esc_html__( 'caret-square-down', 'softing' )),
        array ('far fa-caret-square-down' => esc_html__( 'caret-square-down', 'softing' )),
        array ('fas fa-caret-square-left' => esc_html__( 'caret-square-left', 'softing' )),
        array ('far fa-caret-square-left' => esc_html__( 'caret-square-left', 'softing' )),
        array ('fas fa-caret-square-right' => esc_html__( 'caret-square-right', 'softing' )),
        array ('far fa-caret-square-right' => esc_html__( 'caret-square-right', 'softing' )),
        array ('fas fa-caret-square-up' => esc_html__( 'caret-square-up', 'softing' )),
        array ('far fa-caret-square-up' => esc_html__( 'caret-square-up', 'softing' )),
        array ('fas fa-caret-up' => esc_html__( 'caret-up', 'softing' )),
        array ('fas fa-cart-arrow-down' => esc_html__( 'cart-arrow-down', 'softing' )),
        array ('fas fa-cart-plus' => esc_html__( 'cart-plus', 'softing' )),
        array ('fab fa-cc-amazon-pay' => esc_html__( 'cc-amazon-pay', 'softing' )),
        array ('fab fa-cc-amex' => esc_html__( 'cc-amex', 'softing' )),
        array ('fab fa-cc-apple-pay' => esc_html__( 'cc-apple-pay', 'softing' )),
        array ('fab fa-cc-diners-club' => esc_html__( 'cc-diners-club', 'softing' )),
        array ('fab fa-cc-discover' => esc_html__( 'cc-discover', 'softing' )),
        array ('fab fa-cc-jcb' => esc_html__( 'cc-jcb', 'softing' )),
        array ('fab fa-cc-mastercard' => esc_html__( 'cc-mastercard', 'softing' )),
        array ('fab fa-cc-paypal' => esc_html__( 'cc-paypal', 'softing' )),
        array ('fab fa-cc-stripe' => esc_html__( 'cc-stripe', 'softing' )),
        array ('fab fa-cc-visa' => esc_html__( 'cc-visa', 'softing' )),
        array ('fab fa-centercode' => esc_html__( 'centercode', 'softing' )),
        array ('fas fa-certificate' => esc_html__( 'certificate', 'softing' )),
        array ('fas fa-chart-area' => esc_html__( 'chart-area', 'softing' )),
        array ('fas fa-chart-bar' => esc_html__( 'chart-bar', 'softing' )),
        array ('far fa-chart-bar' => esc_html__( 'chart-bar', 'softing' )),
        array ('fas fa-chart-line' => esc_html__( 'chart-line', 'softing' )),
        array ('fas fa-chart-pie' => esc_html__( 'chart-pie', 'softing' )),
        array ('fas fa-check' => esc_html__( 'check', 'softing' )),
        array ('fas fa-check-circle' => esc_html__( 'check-circle', 'softing' )),
        array ('far fa-check-circle' => esc_html__( 'check-circle', 'softing' )),
        array ('fas fa-check-square' => esc_html__( 'check-square', 'softing' )),
        array ('far fa-check-square' => esc_html__( 'check-square', 'softing' )),
        array ('fas fa-chess' => esc_html__( 'chess', 'softing' )),
        array ('fas fa-chess-bishop' => esc_html__( 'chess-bishop', 'softing' )),
        array ('fas fa-chess-board' => esc_html__( 'chess-board', 'softing' )),
        array ('fas fa-chess-king' => esc_html__( 'chess-king', 'softing' )),
        array ('fas fa-chess-knight' => esc_html__( 'chess-knight', 'softing' )),
        array ('fas fa-chess-pawn' => esc_html__( 'chess-pawn', 'softing' )),
        array ('fas fa-chess-queen' => esc_html__( 'chess-queen', 'softing' )),
        array ('fas fa-chess-rook' => esc_html__( 'chess-rook', 'softing' )),
        array ('fas fa-chevron-circle-down' => esc_html__( 'chevron-circle-down', 'softing' )),
        array ('fas fa-chevron-circle-left' => esc_html__( 'chevron-circle-left', 'softing' )),
        array ('fas fa-chevron-circle-right' => esc_html__( 'chevron-circle-right', 'softing' )),
        array ('fas fa-chevron-circle-up' => esc_html__( 'chevron-circle-up', 'softing' )),
        array ('fas fa-chevron-down' => esc_html__( 'chevron-down', 'softing' )),
        array ('fas fa-chevron-left' => esc_html__( 'chevron-left', 'softing' )),
        array ('fas fa-chevron-right' => esc_html__( 'chevron-right', 'softing' )),
        array ('fas fa-chevron-up' => esc_html__( 'chevron-up', 'softing' )),
        array ('fas fa-child' => esc_html__( 'child', 'softing' )),
        array ('fab fa-chrome' => esc_html__( 'chrome', 'softing' )),
        array ('fas fa-circle' => esc_html__( 'circle', 'softing' )),
        array ('far fa-circle' => esc_html__( 'circle', 'softing' )),
        array ('fas fa-circle-notch' => esc_html__( 'circle-notch', 'softing' )),
        array ('fas fa-clipboard' => esc_html__( 'clipboard', 'softing' )),
        array ('far fa-clipboard' => esc_html__( 'clipboard', 'softing' )),
        array ('fas fa-clipboard-check' => esc_html__( 'clipboard-check', 'softing' )),
        array ('fas fa-clipboard-list' => esc_html__( 'clipboard-list', 'softing' )),
        array ('fas fa-clock' => esc_html__( 'clock', 'softing' )),
        array ('far fa-clock' => esc_html__( 'clock', 'softing' )),
        array ('fas fa-clone' => esc_html__( 'clone', 'softing' )),
        array ('far fa-clone' => esc_html__( 'clone', 'softing' )),
        array ('fas fa-closed-captioning' => esc_html__( 'closed-captioning', 'softing' )),
        array ('far fa-closed-captioning' => esc_html__( 'closed-captioning', 'softing' )),
        array ('fas fa-cloud' => esc_html__( 'cloud', 'softing' )),
        array ('fas fa-cloud-download-alt' => esc_html__( 'cloud-download-alt', 'softing' )),
        array ('fas fa-cloud-upload-alt' => esc_html__( 'cloud-upload-alt', 'softing' )),
        array ('fab fa-cloudscale' => esc_html__( 'cloudscale', 'softing' )),
        array ('fab fa-cloudsmith' => esc_html__( 'cloudsmith', 'softing' )),
        array ('fab fa-cloudversify' => esc_html__( 'cloudversify', 'softing' )),
        array ('fas fa-code' => esc_html__( 'code', 'softing' )),
        array ('fas fa-code-branch' => esc_html__( 'code-branch', 'softing' )),
        array ('fab fa-codepen' => esc_html__( 'codepen', 'softing' )),
        array ('fab fa-codiepie' => esc_html__( 'codiepie', 'softing' )),
        array ('fas fa-coffee' => esc_html__( 'coffee', 'softing' )),
        array ('fas fa-cog' => esc_html__( 'cog', 'softing' )),
        array ('fas fa-cogs' => esc_html__( 'cogs', 'softing' )),
        array ('fas fa-columns' => esc_html__( 'columns', 'softing' )),
        array ('fas fa-comment' => esc_html__( 'comment', 'softing' )),
        array ('far fa-comment' => esc_html__( 'comment', 'softing' )),
        array ('fas fa-comment-alt' => esc_html__( 'comment-alt', 'softing' )),
        array ('far fa-comment-alt' => esc_html__( 'comment-alt', 'softing' )),
        array ('fas fa-comment-dots' => esc_html__( 'comment-dots', 'softing' )),
        array ('fas fa-comment-slash' => esc_html__( 'comment-slash', 'softing' )),
        array ('fas fa-comments' => esc_html__( 'comments', 'softing' )),
        array ('far fa-comments' => esc_html__( 'comments', 'softing' )),
        array ('fas fa-compass' => esc_html__( 'compass', 'softing' )),
        array ('far fa-compass' => esc_html__( 'compass', 'softing' )),
        array ('fas fa-compress' => esc_html__( 'compress', 'softing' )),
        array ('fab fa-connectdevelop' => esc_html__( 'connectdevelop', 'softing' )),
        array ('fab fa-contao' => esc_html__( 'contao', 'softing' )),
        array ('fas fa-copy' => esc_html__( 'copy', 'softing' )),
        array ('far fa-copy' => esc_html__( 'copy', 'softing' )),
        array ('fas fa-copyright' => esc_html__( 'copyright', 'softing' )),
        array ('far fa-copyright' => esc_html__( 'copyright', 'softing' )),
        array ('fas fa-couch' => esc_html__( 'couch', 'softing' )),
        array ('fab fa-cpanel' => esc_html__( 'cpanel', 'softing' )),
        array ('fab fa-creative-commons' => esc_html__( 'creative-commons', 'softing' )),
        array ('fas fa-credit-card' => esc_html__( 'credit-card', 'softing' )),
        array ('far fa-credit-card' => esc_html__( 'credit-card', 'softing' )),
        array ('fas fa-crop' => esc_html__( 'crop', 'softing' )),
        array ('fas fa-crosshairs' => esc_html__( 'crosshairs', 'softing' )),
        array ('fab fa-css3' => esc_html__( 'css3', 'softing' )),
        array ('fab fa-css3-alt' => esc_html__( 'css3-alt', 'softing' )),
        array ('fas fa-cube' => esc_html__( 'cube', 'softing' )),
        array ('fas fa-cubes' => esc_html__( 'cubes', 'softing' )),
        array ('fas fa-cut' => esc_html__( 'cut', 'softing' )),
        array ('fab fa-cuttlefish' => esc_html__( 'cuttlefish', 'softing' )),
        array ('fab fa-d-and-d' => esc_html__( 'd-and-d', 'softing' )),
        array ('fab fa-dashcube' => esc_html__( 'dashcube', 'softing' )),
        array ('fas fa-database' => esc_html__( 'database', 'softing' )),
        array ('fas fa-deaf' => esc_html__( 'deaf', 'softing' )),
        array ('fab fa-delicious' => esc_html__( 'delicious', 'softing' )),
        array ('fab fa-deploydog' => esc_html__( 'deploydog', 'softing' )),
        array ('fab fa-deskpro' => esc_html__( 'deskpro', 'softing' )),
        array ('fas fa-desktop' => esc_html__( 'desktop', 'softing' )),
        array ('fab fa-deviantart' => esc_html__( 'deviantart', 'softing' )),
        array ('fas fa-diagnoses' => esc_html__( 'diagnoses', 'softing' )),
        array ('fab fa-digg' => esc_html__( 'digg', 'softing' )),
        array ('fab fa-digital-ocean' => esc_html__( 'digital-ocean', 'softing' )),
        array ('fab fa-discord' => esc_html__( 'discord', 'softing' )),
        array ('fab fa-discourse' => esc_html__( 'discourse', 'softing' )),
        array ('fas fa-dna' => esc_html__( 'dna', 'softing' )),
        array ('fab fa-dochub' => esc_html__( 'dochub', 'softing' )),
        array ('fab fa-docker' => esc_html__( 'docker', 'softing' )),
        array ('fas fa-dollar-sign' => esc_html__( 'dollar-sign', 'softing' )),
        array ('fas fa-dolly' => esc_html__( 'dolly', 'softing' )),
        array ('fas fa-dolly-flatbed' => esc_html__( 'dolly-flatbed', 'softing' )),
        array ('fas fa-donate' => esc_html__( 'donate', 'softing' )),
        array ('fas fa-dot-circle' => esc_html__( 'dot-circle', 'softing' )),
        array ('far fa-dot-circle' => esc_html__( 'dot-circle', 'softing' )),
        array ('fas fa-dove' => esc_html__( 'dove', 'softing' )),
        array ('fas fa-download' => esc_html__( 'download', 'softing' )),
        array ('fab fa-draft2digital' => esc_html__( 'draft2digital', 'softing' )),
        array ('fab fa-dribbble' => esc_html__( 'dribbble', 'softing' )),
        array ('fab fa-dribbble-square' => esc_html__( 'dribbble-square', 'softing' )),
        array ('fab fa-dropbox' => esc_html__( 'dropbox', 'softing' )),
        array ('fab fa-drupal' => esc_html__( 'drupal', 'softing' )),
        array ('fab fa-dyalog' => esc_html__( 'dyalog', 'softing' )),
        array ('fab fa-earlybirds' => esc_html__( 'earlybirds', 'softing' )),
        array ('fab fa-edge' => esc_html__( 'edge', 'softing' )),
        array ('fas fa-edit' => esc_html__( 'edit', 'softing' )),
        array ('far fa-edit' => esc_html__( 'edit', 'softing' )),
        array ('fas fa-eject' => esc_html__( 'eject', 'softing' )),
        array ('fab fa-elementor' => esc_html__( 'elementor', 'softing' )),
        array ('fas fa-ellipsis-h' => esc_html__( 'ellipsis-h', 'softing' )),
        array ('fas fa-ellipsis-v' => esc_html__( 'ellipsis-v', 'softing' )),
        array ('fab fa-ember' => esc_html__( 'ember', 'softing' )),
        array ('fab fa-empire' => esc_html__( 'empire', 'softing' )),
        array ('fas fa-envelope' => esc_html__( 'envelope', 'softing' )),
        array ('far fa-envelope' => esc_html__( 'envelope', 'softing' )),
        array ('fas fa-envelope-open' => esc_html__( 'envelope-open', 'softing' )),
        array ('far fa-envelope-open' => esc_html__( 'envelope-open', 'softing' )),
        array ('fas fa-envelope-square' => esc_html__( 'envelope-square', 'softing' )),
        array ('fab fa-envira' => esc_html__( 'envira', 'softing' )),
        array ('fas fa-eraser' => esc_html__( 'eraser', 'softing' )),
        array ('fab fa-erlang' => esc_html__( 'erlang', 'softing' )),
        array ('fab fa-ethereum' => esc_html__( 'ethereum', 'softing' )),
        array ('fab fa-etsy' => esc_html__( 'etsy', 'softing' )),
        array ('fas fa-euro-sign' => esc_html__( 'euro-sign', 'softing' )),
        array ('fas fa-exchange-alt' => esc_html__( 'exchange-alt', 'softing' )),
        array ('fas fa-exclamation' => esc_html__( 'exclamation', 'softing' )),
        array ('fas fa-exclamation-circle' => esc_html__( 'exclamation-circle', 'softing' )),
        array ('fas fa-exclamation-triangle' => esc_html__( 'exclamation-triangle', 'softing' )),
        array ('fas fa-expand' => esc_html__( 'expand', 'softing' )),
        array ('fas fa-expand-arrows-alt' => esc_html__( 'expand-arrows-alt', 'softing' )),
        array ('fab fa-expeditedssl' => esc_html__( 'expeditedssl', 'softing' )),
        array ('fas fa-external-link-alt' => esc_html__( 'external-link-alt', 'softing' )),
        array ('fas fa-external-link-square-alt' => esc_html__( 'external-link-square-alt', 'softing' )),
        array ('fas fa-eye' => esc_html__( 'eye', 'softing' )),
        array ('fas fa-eye-dropper' => esc_html__( 'eye-dropper', 'softing' )),
        array ('fas fa-eye-slash' => esc_html__( 'eye-slash', 'softing' )),
        array ('far fa-eye-slash' => esc_html__( 'eye-slash', 'softing' )),
        array ('fab fa-facebook' => esc_html__( 'facebook', 'softing' )),
        array ('fab fa-facebook-f' => esc_html__( 'facebook-f', 'softing' )),
        array ('fab fa-facebook-messenger' => esc_html__( 'facebook-messenger', 'softing' )),
        array ('fab fa-facebook-square' => esc_html__( 'facebook-square', 'softing' )),
        array ('fas fa-fast-backward' => esc_html__( 'fast-backward', 'softing' )),
        array ('fas fa-fast-forward' => esc_html__( 'fast-forward', 'softing' )),
        array ('fas fa-fax' => esc_html__( 'fax', 'softing' )),
        array ('fas fa-female' => esc_html__( 'female', 'softing' )),
        array ('fas fa-fighter-jet' => esc_html__( 'fighter-jet', 'softing' )),
        array ('fas fa-file' => esc_html__( 'file', 'softing' )),
        array ('far fa-file' => esc_html__( 'file', 'softing' )),
        array ('fas fa-file-alt' => esc_html__( 'file-alt', 'softing' )),
        array ('far fa-file-alt' => esc_html__( 'file-alt', 'softing' )),
        array ('fas fa-file-archive' => esc_html__( 'file-archive', 'softing' )),
        array ('far fa-file-archive' => esc_html__( 'file-archive', 'softing' )),
        array ('fas fa-file-audio' => esc_html__( 'file-audio', 'softing' )),
        array ('far fa-file-audio' => esc_html__( 'file-audio', 'softing' )),
        array ('fas fa-file-code' => esc_html__( 'file-code', 'softing' )),
        array ('far fa-file-code' => esc_html__( 'file-code', 'softing' )),
        array ('fas fa-file-excel' => esc_html__( 'file-excel', 'softing' )),
        array ('far fa-file-excel' => esc_html__( 'file-excel', 'softing' )),
        array ('fas fa-file-image' => esc_html__( 'file-image', 'softing' )),
        array ('far fa-file-image' => esc_html__( 'file-image', 'softing' )),
        array ('fas fa-file-medical' => esc_html__( 'file-medical', 'softing' )),
        array ('fas fa-file-medical-alt' => esc_html__( 'file-medical-alt', 'softing' )),
        array ('fas fa-file-pdf' => esc_html__( 'file-pdf', 'softing' )),
        array ('far fa-file-pdf' => esc_html__( 'file-pdf', 'softing' )),
        array ('fas fa-file-powerpoint' => esc_html__( 'file-powerpoint', 'softing' )),
        array ('far fa-file-powerpoint' => esc_html__( 'file-powerpoint', 'softing' )),
        array ('fas fa-file-video' => esc_html__( 'file-video', 'softing' )),
        array ('far fa-file-video' => esc_html__( 'file-video', 'softing' )),
        array ('fas fa-file-word' => esc_html__( 'file-word', 'softing' )),
        array ('far fa-file-word' => esc_html__( 'file-word', 'softing' )),
        array ('fas fa-film' => esc_html__( 'film', 'softing' )),
        array ('fas fa-filter' => esc_html__( 'filter', 'softing' )),
        array ('fas fa-fire' => esc_html__( 'fire', 'softing' )),
        array ('fas fa-fire-extinguisher' => esc_html__( 'fire-extinguisher', 'softing' )),
        array ('fab fa-firefox' => esc_html__( 'firefox', 'softing' )),
        array ('fas fa-first-aid' => esc_html__( 'first-aid', 'softing' )),
        array ('fab fa-first-order' => esc_html__( 'first-order', 'softing' )),
        array ('fab fa-firstdraft' => esc_html__( 'firstdraft', 'softing' )),
        array ('fas fa-flag' => esc_html__( 'flag', 'softing' )),
        array ('far fa-flag' => esc_html__( 'flag', 'softing' )),
        array ('fas fa-flag-checkered' => esc_html__( 'flag-checkered', 'softing' )),
        array ('fas fa-flask' => esc_html__( 'flask', 'softing' )),
        array ('fab fa-flickr' => esc_html__( 'flickr', 'softing' )),
        array ('fab fa-flipboard' => esc_html__( 'flipboard', 'softing' )),
        array ('fab fa-fly' => esc_html__( 'fly', 'softing' )),
        array ('fas fa-folder' => esc_html__( 'folder', 'softing' )),
        array ('far fa-folder' => esc_html__( 'folder', 'softing' )),
        array ('fas fa-folder-open' => esc_html__( 'folder-open', 'softing' )),
        array ('far fa-folder-open' => esc_html__( 'folder-open', 'softing' )),
        array ('fas fa-font' => esc_html__( 'font', 'softing' )),
        array ('fab fa-font-awesome' => esc_html__( 'font-awesome', 'softing' )),
        array ('fab fa-font-awesome-alt' => esc_html__( 'font-awesome-alt', 'softing' )),
        array ('fab fa-font-awesome-flag' => esc_html__( 'font-awesome-flag', 'softing' )),
        array ('fab fa-fonticons' => esc_html__( 'fonticons', 'softing' )),
        array ('fab fa-fonticons-fi' => esc_html__( 'fonticons-fi', 'softing' )),
        array ('fas fa-football-ball' => esc_html__( 'football-ball', 'softing' )),
        array ('fab fa-fort-awesome' => esc_html__( 'fort-awesome', 'softing' )),
        array ('fab fa-fort-awesome-alt' => esc_html__( 'fort-awesome-alt', 'softing' )),
        array ('fab fa-forumbee' => esc_html__( 'forumbee', 'softing' )),
        array ('fas fa-forward' => esc_html__( 'forward', 'softing' )),
        array ('fab fa-foursquare' => esc_html__( 'foursquare', 'softing' )),
        array ('fab fa-free-code-camp' => esc_html__( 'free-code-camp', 'softing' )),
        array ('fab fa-freebsd' => esc_html__( 'freebsd', 'softing' )),
        array ('fas fa-frown' => esc_html__( 'frown', 'softing' )),
        array ('far fa-frown' => esc_html__( 'frown', 'softing' )),
        array ('fas fa-futbol' => esc_html__( 'futbol', 'softing' )),
        array ('far fa-futbol' => esc_html__( 'futbol', 'softing' )),
        array ('fas fa-gamepad' => esc_html__( 'gamepad', 'softing' )),
        array ('fas fa-gavel' => esc_html__( 'gavel', 'softing' )),
        array ('fas fa-gem' => esc_html__( 'gem', 'softing' )),
        array ('far fa-gem' => esc_html__( 'gem', 'softing' )),
        array ('fas fa-genderless' => esc_html__( 'genderless', 'softing' )),
        array ('fab fa-get-pocket' => esc_html__( 'get-pocket', 'softing' )),
        array ('fab fa-gg' => esc_html__( 'gg', 'softing' )),
        array ('fab fa-gg-circle' => esc_html__( 'gg-circle', 'softing' )),
        array ('fas fa-gift' => esc_html__( 'gift', 'softing' )),
        array ('fab fa-git' => esc_html__( 'git', 'softing' )),
        array ('fab fa-git-square' => esc_html__( 'git-square', 'softing' )),
        array ('fab fa-github' => esc_html__( 'github', 'softing' )),
        array ('fab fa-github-alt' => esc_html__( 'github-alt', 'softing' )),
        array ('fab fa-github-square' => esc_html__( 'github-square', 'softing' )),
        array ('fab fa-gitkraken' => esc_html__( 'gitkraken', 'softing' )),
        array ('fab fa-gitlab' => esc_html__( 'gitlab', 'softing' )),
        array ('fab fa-gitter' => esc_html__( 'gitter', 'softing' )),
        array ('fas fa-glass-martini' => esc_html__( 'glass-martini', 'softing' )),
        array ('fab fa-glide' => esc_html__( 'glide', 'softing' )),
        array ('fab fa-glide-g' => esc_html__( 'glide-g', 'softing' )),
        array ('fas fa-globe' => esc_html__( 'globe', 'softing' )),
        array ('fab fa-gofore' => esc_html__( 'gofore', 'softing' )),
        array ('fas fa-golf-ball' => esc_html__( 'golf-ball', 'softing' )),
        array ('fab fa-goodreads' => esc_html__( 'goodreads', 'softing' )),
        array ('fab fa-goodreads-g' => esc_html__( 'goodreads-g', 'softing' )),
        array ('fab fa-google' => esc_html__( 'google', 'softing' )),
        array ('fab fa-google-drive' => esc_html__( 'google-drive', 'softing' )),
        array ('fab fa-google-play' => esc_html__( 'google-play', 'softing' )),
        array ('fab fa-google-plus' => esc_html__( 'google-plus', 'softing' )),
        array ('fab fa-google-plus-g' => esc_html__( 'google-plus-g', 'softing' )),
        array ('fab fa-google-plus-square' => esc_html__( 'google-plus-square', 'softing' )),
        array ('fab fa-google-wallet' => esc_html__( 'google-wallet', 'softing' )),
        array ('fas fa-graduation-cap' => esc_html__( 'graduation-cap', 'softing' )),
        array ('fab fa-gratipay' => esc_html__( 'gratipay', 'softing' )),
        array ('fab fa-grav' => esc_html__( 'grav', 'softing' )),
        array ('fab fa-gripfire' => esc_html__( 'gripfire', 'softing' )),
        array ('fab fa-grunt' => esc_html__( 'grunt', 'softing' )),
        array ('fab fa-gulp' => esc_html__( 'gulp', 'softing' )),
        array ('fas fa-h-square' => esc_html__( 'h-square', 'softing' )),
        array ('fab fa-hacker-news' => esc_html__( 'hacker-news', 'softing' )),
        array ('fab fa-hacker-news-square' => esc_html__( 'hacker-news-square', 'softing' )),
        array ('fas fa-hand-holding' => esc_html__( 'hand-holding', 'softing' )),
        array ('fas fa-hand-holding-heart' => esc_html__( 'hand-holding-heart', 'softing' )),
        array ('fas fa-hand-holding-usd' => esc_html__( 'hand-holding-usd', 'softing' )),
        array ('fas fa-hand-lizard' => esc_html__( 'hand-lizard', 'softing' )),
        array ('far fa-hand-lizard' => esc_html__( 'hand-lizard', 'softing' )),
        array ('fas fa-hand-paper' => esc_html__( 'hand-paper', 'softing' )),
        array ('far fa-hand-paper' => esc_html__( 'hand-paper', 'softing' )),
        array ('fas fa-hand-peace' => esc_html__( 'hand-peace', 'softing' )),
        array ('far fa-hand-peace' => esc_html__( 'hand-peace', 'softing' )),
        array ('fas fa-hand-point-down' => esc_html__( 'hand-point-down', 'softing' )),
        array ('far fa-hand-point-down' => esc_html__( 'hand-point-down', 'softing' )),
        array ('fas fa-hand-point-left' => esc_html__( 'hand-point-left', 'softing' )),
        array ('far fa-hand-point-left' => esc_html__( 'hand-point-left', 'softing' )),
        array ('fas fa-hand-point-right' => esc_html__( 'hand-point-right', 'softing' )),
        array ('far fa-hand-point-right' => esc_html__( 'hand-point-right', 'softing' )),
        array ('fas fa-hand-point-up' => esc_html__( 'hand-point-up', 'softing' )),
        array ('far fa-hand-point-up' => esc_html__( 'hand-point-up', 'softing' )),
        array ('fas fa-hand-pointer' => esc_html__( 'hand-pointer', 'softing' )),
        array ('far fa-hand-pointer' => esc_html__( 'hand-pointer', 'softing' )),
        array ('fas fa-hand-rock' => esc_html__( 'hand-rock', 'softing' )),
        array ('far fa-hand-rock' => esc_html__( 'hand-rock', 'softing' )),
        array ('fas fa-hand-scissors' => esc_html__( 'hand-scissors', 'softing' )),
        array ('far fa-hand-scissors' => esc_html__( 'hand-scissors', 'softing' )),
        array ('fas fa-hand-spock' => esc_html__( 'hand-spock', 'softing' )),
        array ('far fa-hand-spock' => esc_html__( 'hand-spock', 'softing' )),
        array ('fas fa-hands' => esc_html__( 'hands', 'softing' )),
        array ('fas fa-hands-helping' => esc_html__( 'hands-helping', 'softing' )),
        array ('fas fa-handshake' => esc_html__( 'handshake', 'softing' )),
        array ('far fa-handshake' => esc_html__( 'handshake', 'softing' )),
        array ('fas fa-hashtag' => esc_html__( 'hashtag', 'softing' )),
        array ('fas fa-hdd' => esc_html__( 'hdd', 'softing' )),
        array ('far fa-hdd' => esc_html__( 'hdd', 'softing' )),
        array ('fas fa-heading' => esc_html__( 'heading', 'softing' )),
        array ('fas fa-headphones' => esc_html__( 'headphones', 'softing' )),
        array ('fas fa-heart' => esc_html__( 'heart', 'softing' )),
        array ('far fa-heart' => esc_html__( 'heart', 'softing' )),
        array ('fas fa-heartbeat' => esc_html__( 'heartbeat', 'softing' )),
        array ('fab fa-hips' => esc_html__( 'hips', 'softing' )),
        array ('fab fa-hire-a-helper' => esc_html__( 'hire-a-helper', 'softing' )),
        array ('fas fa-history' => esc_html__( 'history', 'softing' )),
        array ('fas fa-hockey-puck' => esc_html__( 'hockey-puck', 'softing' )),
        array ('fas fa-home' => esc_html__( 'home', 'softing' )),
        array ('fab fa-hooli' => esc_html__( 'hooli', 'softing' )),
        array ('fas fa-hospital' => esc_html__( 'hospital', 'softing' )),
        array ('far fa-hospital' => esc_html__( 'hospital', 'softing' )),
        array ('fas fa-hospital-alt' => esc_html__( 'hospital-alt', 'softing' )),
        array ('fas fa-hospital-symbol' => esc_html__( 'hospital-symbol', 'softing' )),
        array ('fab fa-hotjar' => esc_html__( 'hotjar', 'softing' )),
        array ('fas fa-hourglass' => esc_html__( 'hourglass', 'softing' )),
        array ('far fa-hourglass' => esc_html__( 'hourglass', 'softing' )),
        array ('fas fa-hourglass-end' => esc_html__( 'hourglass-end', 'softing' )),
        array ('fas fa-hourglass-half' => esc_html__( 'hourglass-half', 'softing' )),
        array ('fas fa-hourglass-start' => esc_html__( 'hourglass-start', 'softing' )),
        array ('fab fa-houzz' => esc_html__( 'houzz', 'softing' )),
        array ('fab fa-html5' => esc_html__( 'html5', 'softing' )),
        array ('fab fa-hubspot' => esc_html__( 'hubspot', 'softing' )),
        array ('fas fa-i-cursor' => esc_html__( 'i-cursor', 'softing' )),
        array ('fas fa-id-badge' => esc_html__( 'id-badge', 'softing' )),
        array ('far fa-id-badge' => esc_html__( 'id-badge', 'softing' )),
        array ('fas fa-id-card' => esc_html__( 'id-card', 'softing' )),
        array ('far fa-id-card' => esc_html__( 'id-card', 'softing' )),
        array ('fas fa-id-card-alt' => esc_html__( 'id-card-alt', 'softing' )),
        array ('fas fa-image' => esc_html__( 'image', 'softing' )),
        array ('far fa-image' => esc_html__( 'image', 'softing' )),
        array ('fas fa-images' => esc_html__( 'images', 'softing' )),
        array ('far fa-images' => esc_html__( 'images', 'softing' )),
        array ('fab fa-imdb' => esc_html__( 'imdb', 'softing' )),
        array ('fas fa-inbox' => esc_html__( 'inbox', 'softing' )),
        array ('fas fa-indent' => esc_html__( 'indent', 'softing' )),
        array ('fas fa-industry' => esc_html__( 'industry', 'softing' )),
        array ('fas fa-info' => esc_html__( 'info', 'softing' )),
        array ('fas fa-info-circle' => esc_html__( 'info-circle', 'softing' )),
        array ('fab fa-instagram' => esc_html__( 'instagram', 'softing' )),
        array ('fab fa-internet-explorer' => esc_html__( 'internet-explorer', 'softing' )),
        array ('fab fa-ioxhost' => esc_html__( 'ioxhost', 'softing' )),
        array ('fas fa-italic' => esc_html__( 'italic', 'softing' )),
        array ('fab fa-itunes' => esc_html__( 'itunes', 'softing' )),
        array ('fab fa-itunes-note' => esc_html__( 'itunes-note', 'softing' )),
        array ('fab fa-java' => esc_html__( 'java', 'softing' )),
        array ('fab fa-jenkins' => esc_html__( 'jenkins', 'softing' )),
        array ('fab fa-joget' => esc_html__( 'joget', 'softing' )),
        array ('fab fa-joomla' => esc_html__( 'joomla', 'softing' )),
        array ('fab fa-js' => esc_html__( 'js', 'softing' )),
        array ('fab fa-js-square' => esc_html__( 'js-square', 'softing' )),
        array ('fab fa-jsfiddle' => esc_html__( 'jsfiddle', 'softing' )),
        array ('fas fa-key' => esc_html__( 'key', 'softing' )),
        array ('fas fa-keyboard' => esc_html__( 'keyboard', 'softing' )),
        array ('far fa-keyboard' => esc_html__( 'keyboard', 'softing' )),
        array ('fab fa-keycdn' => esc_html__( 'keycdn', 'softing' )),
        array ('fab fa-kickstarter' => esc_html__( 'kickstarter', 'softing' )),
        array ('fab fa-kickstarter-k' => esc_html__( 'kickstarter-k', 'softing' )),
        array ('fab fa-korvue' => esc_html__( 'korvue', 'softing' )),
        array ('fas fa-language' => esc_html__( 'language', 'softing' )),
        array ('fas fa-laptop' => esc_html__( 'laptop', 'softing' )),
        array ('fab fa-laravel' => esc_html__( 'laravel', 'softing' )),
        array ('fab fa-lastfm' => esc_html__( 'lastfm', 'softing' )),
        array ('fab fa-lastfm-square' => esc_html__( 'lastfm-square', 'softing' )),
        array ('fas fa-leaf' => esc_html__( 'leaf', 'softing' )),
        array ('fab fa-leanpub' => esc_html__( 'leanpub', 'softing' )),
        array ('fas fa-lemon' => esc_html__( 'lemon', 'softing' )),
        array ('far fa-lemon' => esc_html__( 'lemon', 'softing' )),
        array ('fab fa-less' => esc_html__( 'less', 'softing' )),
        array ('fas fa-level-down-alt' => esc_html__( 'level-down-alt', 'softing' )),
        array ('fas fa-level-up-alt' => esc_html__( 'level-up-alt', 'softing' )),
        array ('fas fa-life-ring' => esc_html__( 'life-ring', 'softing' )),
        array ('far fa-life-ring' => esc_html__( 'life-ring', 'softing' )),
        array ('fas fa-lightbulb' => esc_html__( 'lightbulb', 'softing' )),
        array ('far fa-lightbulb' => esc_html__( 'lightbulb', 'softing' )),
        array ('fab fa-line' => esc_html__( 'line', 'softing' )),
        array ('fas fa-link' => esc_html__( 'link', 'softing' )),
        array ('fab fa-linkedin' => esc_html__( 'linkedin', 'softing' )),
        array ('fab fa-linkedin-in' => esc_html__( 'linkedin-in', 'softing' )),
        array ('fab fa-linode' => esc_html__( 'linode', 'softing' )),
        array ('fab fa-linux' => esc_html__( 'linux', 'softing' )),
        array ('fas fa-lira-sign' => esc_html__( 'lira-sign', 'softing' )),
        array ('fas fa-list' => esc_html__( 'list', 'softing' )),
        array ('fas fa-list-alt' => esc_html__( 'list-alt', 'softing' )),
        array ('far fa-list-alt' => esc_html__( 'list-alt', 'softing' )),
        array ('fas fa-list-ol' => esc_html__( 'list-ol', 'softing' )),
        array ('fas fa-list-ul' => esc_html__( 'list-ul', 'softing' )),
        array ('fas fa-location-arrow' => esc_html__( 'location-arrow', 'softing' )),
        array ('fas fa-lock' => esc_html__( 'lock', 'softing' )),
        array ('fas fa-lock-open' => esc_html__( 'lock-open', 'softing' )),
        array ('fas fa-long-arrow-alt-down' => esc_html__( 'long-arrow-alt-down', 'softing' )),
        array ('fas fa-long-arrow-alt-left' => esc_html__( 'long-arrow-alt-left', 'softing' )),
        array ('fas fa-long-arrow-alt-right' => esc_html__( 'long-arrow-alt-right', 'softing' )),
        array ('fas fa-long-arrow-alt-up' => esc_html__( 'long-arrow-alt-up', 'softing' )),
        array ('fas fa-low-vision' => esc_html__( 'low-vision', 'softing' )),
        array ('fab fa-lyft' => esc_html__( 'lyft', 'softing' )),
        array ('fab fa-magento' => esc_html__( 'magento', 'softing' )),
        array ('fas fa-magic' => esc_html__( 'magic', 'softing' )),
        array ('fas fa-magnet' => esc_html__( 'magnet', 'softing' )),
        array ('fas fa-male' => esc_html__( 'male', 'softing' )),
        array ('fas fa-map' => esc_html__( 'map', 'softing' )),
        array ('far fa-map' => esc_html__( 'map', 'softing' )),
        array ('fas fa-map-marker' => esc_html__( 'map-marker', 'softing' )),
        array ('fas fa-map-marker-alt' => esc_html__( 'map-marker-alt', 'softing' )),
        array ('fas fa-map-pin' => esc_html__( 'map-pin', 'softing' )),
        array ('fas fa-map-signs' => esc_html__( 'map-signs', 'softing' )),
        array ('fas fa-mars' => esc_html__( 'mars', 'softing' )),
        array ('fas fa-mars-double' => esc_html__( 'mars-double', 'softing' )),
        array ('fas fa-mars-stroke' => esc_html__( 'mars-stroke', 'softing' )),
        array ('fas fa-mars-stroke-h' => esc_html__( 'mars-stroke-h', 'softing' )),
        array ('fas fa-mars-stroke-v' => esc_html__( 'mars-stroke-v', 'softing' )),
        array ('fab fa-maxcdn' => esc_html__( 'maxcdn', 'softing' )),
        array ('fab fa-medapps' => esc_html__( 'medapps', 'softing' )),
        array ('fab fa-medium' => esc_html__( 'medium', 'softing' )),
        array ('fab fa-medium-m' => esc_html__( 'medium-m', 'softing' )),
        array ('fas fa-medkit' => esc_html__( 'medkit', 'softing' )),
        array ('fab fa-medrt' => esc_html__( 'medrt', 'softing' )),
        array ('fab fa-meetup' => esc_html__( 'meetup', 'softing' )),
        array ('fas fa-meh' => esc_html__( 'meh', 'softing' )),
        array ('far fa-meh' => esc_html__( 'meh', 'softing' )),
        array ('fas fa-mercury' => esc_html__( 'mercury', 'softing' )),
        array ('fas fa-microchip' => esc_html__( 'microchip', 'softing' )),
        array ('fas fa-microphone' => esc_html__( 'microphone', 'softing' )),
        array ('fas fa-microphone-slash' => esc_html__( 'microphone-slash', 'softing' )),
        array ('fab fa-microsoft' => esc_html__( 'microsoft', 'softing' )),
        array ('fas fa-minus' => esc_html__( 'minus', 'softing' )),
        array ('fas fa-minus-circle' => esc_html__( 'minus-circle', 'softing' )),
        array ('fas fa-minus-square' => esc_html__( 'minus-square', 'softing' )),
        array ('far fa-minus-square' => esc_html__( 'minus-square', 'softing' )),
        array ('fab fa-mix' => esc_html__( 'mix', 'softing' )),
        array ('fab fa-mixcloud' => esc_html__( 'mixcloud', 'softing' )),
        array ('fab fa-mizuni' => esc_html__( 'mizuni', 'softing' )),
        array ('fas fa-mobile' => esc_html__( 'mobile', 'softing' )),
        array ('fas fa-mobile-alt' => esc_html__( 'mobile-alt', 'softing' )),
        array ('fab fa-modx' => esc_html__( 'modx', 'softing' )),
        array ('fab fa-monero' => esc_html__( 'monero', 'softing' )),
        array ('fas fa-money-bill-alt' => esc_html__( 'money-bill-alt', 'softing' )),
        array ('far fa-money-bill-alt' => esc_html__( 'money-bill-alt', 'softing' )),
        array ('fas fa-moon' => esc_html__( 'moon', 'softing' )),
        array ('far fa-moon' => esc_html__( 'moon', 'softing' )),
        array ('fas fa-motorcycle' => esc_html__( 'motorcycle', 'softing' )),
        array ('fas fa-mouse-pointer' => esc_html__( 'mouse-pointer', 'softing' )),
        array ('fas fa-music' => esc_html__( 'music', 'softing' )),
        array ('fab fa-napster' => esc_html__( 'napster', 'softing' )),
        array ('fas fa-neuter' => esc_html__( 'neuter', 'softing' )),
        array ('fas fa-newspaper' => esc_html__( 'newspaper', 'softing' )),
        array ('far fa-newspaper' => esc_html__( 'newspaper', 'softing' )),
        array ('fab fa-nintendo-switch' => esc_html__( 'nintendo-switch', 'softing' )),
        array ('fab fa-node' => esc_html__( 'node', 'softing' )),
        array ('fab fa-node-js' => esc_html__( 'node-js', 'softing' )),
        array ('fas fa-notes-medical' => esc_html__( 'notes-medical', 'softing' )),
        array ('fab fa-npm' => esc_html__( 'npm', 'softing' )),
        array ('fab fa-ns8' => esc_html__( 'ns8', 'softing' )),
        array ('fab fa-nutritionix' => esc_html__( 'nutritionix', 'softing' )),
        array ('fas fa-object-group' => esc_html__( 'object-group', 'softing' )),
        array ('far fa-object-group' => esc_html__( 'object-group', 'softing' )),
        array ('fas fa-object-ungroup' => esc_html__( 'object-ungroup', 'softing' )),
        array ('far fa-object-ungroup' => esc_html__( 'object-ungroup', 'softing' )),
        array ('fab fa-odnoklassniki' => esc_html__( 'odnoklassniki', 'softing' )),
        array ('fab fa-odnoklassniki-square' => esc_html__( 'odnoklassniki-square', 'softing' )),
        array ('fab fa-opencart' => esc_html__( 'opencart', 'softing' )),
        array ('fab fa-openid' => esc_html__( 'openid', 'softing' )),
        array ('fab fa-opera' => esc_html__( 'opera', 'softing' )),
        array ('fab fa-optin-monster' => esc_html__( 'optin-monster', 'softing' )),
        array ('fab fa-osi' => esc_html__( 'osi', 'softing' )),
        array ('fas fa-outdent' => esc_html__( 'outdent', 'softing' )),
        array ('fab fa-page4' => esc_html__( 'page4', 'softing' )),
        array ('fab fa-pagelines' => esc_html__( 'pagelines', 'softing' )),
        array ('fas fa-paint-brush' => esc_html__( 'paint-brush', 'softing' )),
        array ('fab fa-palfed' => esc_html__( 'palfed', 'softing' )),
        array ('fas fa-pallet' => esc_html__( 'pallet', 'softing' )),
        array ('fas fa-paper-plane' => esc_html__( 'paper-plane', 'softing' )),
        array ('far fa-paper-plane' => esc_html__( 'paper-plane', 'softing' )),
        array ('fas fa-paperclip' => esc_html__( 'paperclip', 'softing' )),
        array ('fas fa-parachute-box' => esc_html__( 'parachute-box', 'softing' )),
        array ('fas fa-paragraph' => esc_html__( 'paragraph', 'softing' )),
        array ('fas fa-paste' => esc_html__( 'paste', 'softing' )),
        array ('fab fa-patreon' => esc_html__( 'patreon', 'softing' )),
        array ('fas fa-pause' => esc_html__( 'pause', 'softing' )),
        array ('fas fa-pause-circle' => esc_html__( 'pause-circle', 'softing' )),
        array ('far fa-pause-circle' => esc_html__( 'pause-circle', 'softing' )),
        array ('fas fa-paw' => esc_html__( 'paw', 'softing' )),
        array ('fab fa-paypal' => esc_html__( 'paypal', 'softing' )),
        array ('fas fa-pen-square' => esc_html__( 'pen-square', 'softing' )),
        array ('fas fa-pencil-alt' => esc_html__( 'pencil-alt', 'softing' )),
        array ('fas fa-people-carry' => esc_html__( 'people-carry', 'softing' )),
        array ('fas fa-percent' => esc_html__( 'percent', 'softing' )),
        array ('fab fa-periscope' => esc_html__( 'periscope', 'softing' )),
        array ('fab fa-phabricator' => esc_html__( 'phabricator', 'softing' )),
        array ('fab fa-phoenix-framework' => esc_html__( 'phoenix-framework', 'softing' )),
        array ('fas fa-phone' => esc_html__( 'phone', 'softing' )),
        array ('fas fa-phone-slash' => esc_html__( 'phone-slash', 'softing' )),
        array ('fas fa-phone-square' => esc_html__( 'phone-square', 'softing' )),
        array ('fas fa-phone-volume' => esc_html__( 'phone-volume', 'softing' )),
        array ('fab fa-php' => esc_html__( 'php', 'softing' )),
        array ('fab fa-pied-piper' => esc_html__( 'pied-piper', 'softing' )),
        array ('fab fa-pied-piper-alt' => esc_html__( 'pied-piper-alt', 'softing' )),
        array ('fab fa-pied-piper-hat' => esc_html__( 'pied-piper-hat', 'softing' )),
        array ('fab fa-pied-piper-pp' => esc_html__( 'pied-piper-pp', 'softing' )),
        array ('fas fa-piggy-bank' => esc_html__( 'piggy-bank', 'softing' )),
        array ('fas fa-pills' => esc_html__( 'pills', 'softing' )),
        array ('fab fa-pinterest' => esc_html__( 'pinterest', 'softing' )),
        array ('fab fa-pinterest-p' => esc_html__( 'pinterest-p', 'softing' )),
        array ('fab fa-pinterest-square' => esc_html__( 'pinterest-square', 'softing' )),
        array ('fas fa-plane' => esc_html__( 'plane', 'softing' )),
        array ('fas fa-play' => esc_html__( 'play', 'softing' )),
        array ('fas fa-play-circle' => esc_html__( 'play-circle', 'softing' )),
        array ('far fa-play-circle' => esc_html__( 'play-circle', 'softing' )),
        array ('fab fa-playstation' => esc_html__( 'playstation', 'softing' )),
        array ('fas fa-plug' => esc_html__( 'plug', 'softing' )),
        array ('fas fa-plus' => esc_html__( 'plus', 'softing' )),
        array ('fas fa-plus-circle' => esc_html__( 'plus-circle', 'softing' )),
        array ('fas fa-plus-square' => esc_html__( 'plus-square', 'softing' )),
        array ('far fa-plus-square' => esc_html__( 'plus-square', 'softing' )),
        array ('fas fa-podcast' => esc_html__( 'podcast', 'softing' )),
        array ('fas fa-poo' => esc_html__( 'poo', 'softing' )),
        array ('fas fa-pound-sign' => esc_html__( 'pound-sign', 'softing' )),
        array ('fas fa-power-off' => esc_html__( 'power-off', 'softing' )),
        array ('fas fa-prescription-bottle' => esc_html__( 'prescription-bottle', 'softing' )),
        array ('fas fa-prescription-bottle-alt' => esc_html__( 'prescription-bottle-alt', 'softing' )),
        array ('fas fa-print' => esc_html__( 'print', 'softing' )),
        array ('fas fa-procedures' => esc_html__( 'procedures', 'softing' )),
        array ('fab fa-product-hunt' => esc_html__( 'product-hunt', 'softing' )),
        array ('fab fa-pushed' => esc_html__( 'pushed', 'softing' )),
        array ('fas fa-puzzle-piece' => esc_html__( 'puzzle-piece', 'softing' )),
        array ('fab fa-python' => esc_html__( 'python', 'softing' )),
        array ('fab fa-qq' => esc_html__( 'qq', 'softing' )),
        array ('fas fa-qrcode' => esc_html__( 'qrcode', 'softing' )),
        array ('fas fa-question' => esc_html__( 'question', 'softing' )),
        array ('fas fa-question-circle' => esc_html__( 'question-circle', 'softing' )),
        array ('far fa-question-circle' => esc_html__( 'question-circle', 'softing' )),
        array ('fas fa-quidditch' => esc_html__( 'quidditch', 'softing' )),
        array ('fab fa-quinscape' => esc_html__( 'quinscape', 'softing' )),
        array ('fab fa-quora' => esc_html__( 'quora', 'softing' )),
        array ('fas fa-quote-left' => esc_html__( 'quote-left', 'softing' )),
        array ('fas fa-quote-right' => esc_html__( 'quote-right', 'softing' )),
        array ('fas fa-random' => esc_html__( 'random', 'softing' )),
        array ('fab fa-ravelry' => esc_html__( 'ravelry', 'softing' )),
        array ('fab fa-react' => esc_html__( 'react', 'softing' )),
        array ('fab fa-readme' => esc_html__( 'readme', 'softing' )),
        array ('fab fa-rebel' => esc_html__( 'rebel', 'softing' )),
        array ('fas fa-recycle' => esc_html__( 'recycle', 'softing' )),
        array ('fab fa-red-river' => esc_html__( 'red-river', 'softing' )),
        array ('fab fa-reddit' => esc_html__( 'reddit', 'softing' )),
        array ('fab fa-reddit-alien' => esc_html__( 'reddit-alien', 'softing' )),
        array ('fab fa-reddit-square' => esc_html__( 'reddit-square', 'softing' )),
        array ('fas fa-redo' => esc_html__( 'redo', 'softing' )),
        array ('fas fa-redo-alt' => esc_html__( 'redo-alt', 'softing' )),
        array ('fas fa-registered' => esc_html__( 'registered', 'softing' )),
        array ('far fa-registered' => esc_html__( 'registered', 'softing' )),
        array ('fab fa-rendact' => esc_html__( 'rendact', 'softing' )),
        array ('fab fa-renren' => esc_html__( 'renren', 'softing' )),
        array ('fas fa-reply' => esc_html__( 'reply', 'softing' )),
        array ('fas fa-reply-all' => esc_html__( 'reply-all', 'softing' )),
        array ('fab fa-replyd' => esc_html__( 'replyd', 'softing' )),
        array ('fab fa-resolving' => esc_html__( 'resolving', 'softing' )),
        array ('fas fa-retweet' => esc_html__( 'retweet', 'softing' )),
        array ('fas fa-ribbon' => esc_html__( 'ribbon', 'softing' )),
        array ('fas fa-road' => esc_html__( 'road', 'softing' )),
        array ('fas fa-rocket' => esc_html__( 'rocket', 'softing' )),
        array ('fab fa-rocketchat' => esc_html__( 'rocketchat', 'softing' )),
        array ('fab fa-rockrms' => esc_html__( 'rockrms', 'softing' )),
        array ('fas fa-rss' => esc_html__( 'rss', 'softing' )),
        array ('fas fa-rss-square' => esc_html__( 'rss-square', 'softing' )),
        array ('fas fa-ruble-sign' => esc_html__( 'ruble-sign', 'softing' )),
        array ('fas fa-rupee-sign' => esc_html__( 'rupee-sign', 'softing' )),
        array ('fab fa-safari' => esc_html__( 'safari', 'softing' )),
        array ('fab fa-sass' => esc_html__( 'sass', 'softing' )),
        array ('fas fa-save' => esc_html__( 'save', 'softing' )),
        array ('far fa-save' => esc_html__( 'save', 'softing' )),
        array ('fab fa-schlix' => esc_html__( 'schlix', 'softing' )),
        array ('fab fa-scribd' => esc_html__( 'scribd', 'softing' )),
        array ('fas fa-search' => esc_html__( 'search', 'softing' )),
        array ('fas fa-search-minus' => esc_html__( 'search-minus', 'softing' )),
        array ('fas fa-search-plus' => esc_html__( 'search-plus', 'softing' )),
        array ('fab fa-searchengin' => esc_html__( 'searchengin', 'softing' )),
        array ('fas fa-seedling' => esc_html__( 'seedling', 'softing' )),
        array ('fab fa-sellcast' => esc_html__( 'sellcast', 'softing' )),
        array ('fab fa-sellsy' => esc_html__( 'sellsy', 'softing' )),
        array ('fas fa-server' => esc_html__( 'server', 'softing' )),
        array ('fab fa-servicestack' => esc_html__( 'servicestack', 'softing' )),
        array ('fas fa-share' => esc_html__( 'share', 'softing' )),
        array ('fas fa-share-alt' => esc_html__( 'share-alt', 'softing' )),
        array ('fas fa-share-alt-square' => esc_html__( 'share-alt-square', 'softing' )),
        array ('fas fa-share-square' => esc_html__( 'share-square', 'softing' )),
        array ('far fa-share-square' => esc_html__( 'share-square', 'softing' )),
        array ('fas fa-shekel-sign' => esc_html__( 'shekel-sign', 'softing' )),
        array ('fas fa-shield-alt' => esc_html__( 'shield-alt', 'softing' )),
        array ('fas fa-ship' => esc_html__( 'ship', 'softing' )),
        array ('fas fa-shipping-fast' => esc_html__( 'shipping-fast', 'softing' )),
        array ('fab fa-shirtsinbulk' => esc_html__( 'shirtsinbulk', 'softing' )),
        array ('fas fa-shopping-bag' => esc_html__( 'shopping-bag', 'softing' )),
        array ('fas fa-shopping-basket' => esc_html__( 'shopping-basket', 'softing' )),
        array ('fas fa-shopping-cart' => esc_html__( 'shopping-cart', 'softing' )),
        array ('fas fa-shower' => esc_html__( 'shower', 'softing' )),
        array ('fas fa-sign' => esc_html__( 'sign', 'softing' )),
        array ('fas fa-sign-in-alt' => esc_html__( 'sign-in-alt', 'softing' )),
        array ('fas fa-sign-language' => esc_html__( 'sign-language', 'softing' )),
        array ('fas fa-sign-out-alt' => esc_html__( 'sign-out-alt', 'softing' )),
        array ('fas fa-signal' => esc_html__( 'signal', 'softing' )),
        array ('fab fa-simplybuilt' => esc_html__( 'simplybuilt', 'softing' )),
        array ('fab fa-sistrix' => esc_html__( 'sistrix', 'softing' )),
        array ('fas fa-sitemap' => esc_html__( 'sitemap', 'softing' )),
        array ('fab fa-skyatlas' => esc_html__( 'skyatlas', 'softing' )),
        array ('fab fa-skype' => esc_html__( 'skype', 'softing' )),
        array ('fab fa-slack' => esc_html__( 'slack', 'softing' )),
        array ('fab fa-slack-hash' => esc_html__( 'slack-hash', 'softing' )),
        array ('fas fa-sliders-h' => esc_html__( 'sliders-h', 'softing' )),
        array ('fab fa-slideshare' => esc_html__( 'slideshare', 'softing' )),
        array ('fas fa-smile' => esc_html__( 'smile', 'softing' )),
        array ('far fa-smile' => esc_html__( 'smile', 'softing' )),
        array ('fas fa-smoking' => esc_html__( 'smoking', 'softing' )),
        array ('fab fa-snapchat' => esc_html__( 'snapchat', 'softing' )),
        array ('fab fa-snapchat-ghost' => esc_html__( 'snapchat-ghost', 'softing' )),
        array ('fab fa-snapchat-square' => esc_html__( 'snapchat-square', 'softing' )),
        array ('fas fa-snowflake' => esc_html__( 'snowflake', 'softing' )),
        array ('far fa-snowflake' => esc_html__( 'snowflake', 'softing' )),
        array ('fas fa-sort' => esc_html__( 'sort', 'softing' )),
        array ('fas fa-sort-alpha-down' => esc_html__( 'sort-alpha-down', 'softing' )),
        array ('fas fa-sort-alpha-up' => esc_html__( 'sort-alpha-up', 'softing' )),
        array ('fas fa-sort-amount-down' => esc_html__( 'sort-amount-down', 'softing' )),
        array ('fas fa-sort-amount-up' => esc_html__( 'sort-amount-up', 'softing' )),
        array ('fas fa-sort-down' => esc_html__( 'sort-down', 'softing' )),
        array ('fas fa-sort-numeric-down' => esc_html__( 'sort-numeric-down', 'softing' )),
        array ('fas fa-sort-numeric-up' => esc_html__( 'sort-numeric-up', 'softing' )),
        array ('fas fa-sort-up' => esc_html__( 'sort-up', 'softing' )),
        array ('fab fa-soundcloud' => esc_html__( 'soundcloud', 'softing' )),
        array ('fas fa-space-shuttle' => esc_html__( 'space-shuttle', 'softing' )),
        array ('fab fa-speakap' => esc_html__( 'speakap', 'softing' )),
        array ('fas fa-spinner' => esc_html__( 'spinner', 'softing' )),
        array ('fab fa-spotify' => esc_html__( 'spotify', 'softing' )),
        array ('fas fa-square' => esc_html__( 'square', 'softing' )),
        array ('far fa-square' => esc_html__( 'square', 'softing' )),
        array ('fas fa-square-full' => esc_html__( 'square-full', 'softing' )),
        array ('fab fa-stack-exchange' => esc_html__( 'stack-exchange', 'softing' )),
        array ('fab fa-stack-overflow' => esc_html__( 'stack-overflow', 'softing' )),
        array ('fas fa-star' => esc_html__( 'star', 'softing' )),
        array ('far fa-star' => esc_html__( 'star', 'softing' )),
        array ('fas fa-star-half' => esc_html__( 'star-half', 'softing' )),
        array ('far fa-star-half' => esc_html__( 'star-half', 'softing' )),
        array ('fab fa-staylinked' => esc_html__( 'staylinked', 'softing' )),
        array ('fab fa-steam' => esc_html__( 'steam', 'softing' )),
        array ('fab fa-steam-square' => esc_html__( 'steam-square', 'softing' )),
        array ('fab fa-steam-symbol' => esc_html__( 'steam-symbol', 'softing' )),
        array ('fas fa-step-backward' => esc_html__( 'step-backward', 'softing' )),
        array ('fas fa-step-forward' => esc_html__( 'step-forward', 'softing' )),
        array ('fas fa-stethoscope' => esc_html__( 'stethoscope', 'softing' )),
        array ('fab fa-sticker-mule' => esc_html__( 'sticker-mule', 'softing' )),
        array ('fas fa-sticky-note' => esc_html__( 'sticky-note', 'softing' )),
        array ('far fa-sticky-note' => esc_html__( 'sticky-note', 'softing' )),
        array ('fas fa-stop' => esc_html__( 'stop', 'softing' )),
        array ('fas fa-stop-circle' => esc_html__( 'stop-circle', 'softing' )),
        array ('far fa-stop-circle' => esc_html__( 'stop-circle', 'softing' )),
        array ('fas fa-stopwatch' => esc_html__( 'stopwatch', 'softing' )),
        array ('fab fa-strava' => esc_html__( 'strava', 'softing' )),
        array ('fas fa-street-view' => esc_html__( 'street-view', 'softing' )),
        array ('fas fa-strikethrough' => esc_html__( 'strikethrough', 'softing' )),
        array ('fab fa-stripe' => esc_html__( 'stripe', 'softing' )),
        array ('fab fa-stripe-s' => esc_html__( 'stripe-s', 'softing' )),
        array ('fab fa-studiovinari' => esc_html__( 'studiovinari', 'softing' )),
        array ('fab fa-stumbleupon' => esc_html__( 'stumbleupon', 'softing' )),
        array ('fab fa-stumbleupon-circle' => esc_html__( 'stumbleupon-circle', 'softing' )),
        array ('fas fa-subscript' => esc_html__( 'subscript', 'softing' )),
        array ('fas fa-subway' => esc_html__( 'subway', 'softing' )),
        array ('fas fa-suitcase' => esc_html__( 'suitcase', 'softing' )),
        array ('fas fa-sun' => esc_html__( 'sun', 'softing' )),
        array ('far fa-sun' => esc_html__( 'sun', 'softing' )),
        array ('fab fa-superpowers' => esc_html__( 'superpowers', 'softing' )),
        array ('fas fa-superscript' => esc_html__( 'superscript', 'softing' )),
        array ('fab fa-supple' => esc_html__( 'supple', 'softing' )),
        array ('fas fa-sync' => esc_html__( 'sync', 'softing' )),
        array ('fas fa-sync-alt' => esc_html__( 'sync-alt', 'softing' )),
        array ('fas fa-syringe' => esc_html__( 'syringe', 'softing' )),
        array ('fas fa-table' => esc_html__( 'table', 'softing' )),
        array ('fas fa-table-tennis' => esc_html__( 'table-tennis', 'softing' )),
        array ('fas fa-tablet' => esc_html__( 'tablet', 'softing' )),
        array ('fas fa-tablet-alt' => esc_html__( 'tablet-alt', 'softing' )),
        array ('fas fa-tablets' => esc_html__( 'tablets', 'softing' )),
        array ('fas fa-tachometer-alt' => esc_html__( 'tachometer-alt', 'softing' )),
        array ('fas fa-tag' => esc_html__( 'tag', 'softing' )),
        array ('fas fa-tags' => esc_html__( 'tags', 'softing' )),
        array ('fas fa-tape' => esc_html__( 'tape', 'softing' )),
        array ('fas fa-tasks' => esc_html__( 'tasks', 'softing' )),
        array ('fas fa-taxi' => esc_html__( 'taxi', 'softing' )),
        array ('fab fa-telegram' => esc_html__( 'telegram', 'softing' )),
        array ('fab fa-telegram-plane' => esc_html__( 'telegram-plane', 'softing' )),
        array ('fab fa-tencent-weibo' => esc_html__( 'tencent-weibo', 'softing' )),
        array ('fas fa-terminal' => esc_html__( 'terminal', 'softing' )),
        array ('fas fa-text-height' => esc_html__( 'text-height', 'softing' )),
        array ('fas fa-text-width' => esc_html__( 'text-width', 'softing' )),
        array ('fas fa-th' => esc_html__( 'th', 'softing' )),
        array ('fas fa-th-large' => esc_html__( 'th-large', 'softing' )),
        array ('fas fa-th-list' => esc_html__( 'th-list', 'softing' )),
        array ('fab fa-themeisle' => esc_html__( 'themeisle', 'softing' )),
        array ('fas fa-thermometer' => esc_html__( 'thermometer', 'softing' )),
        array ('fas fa-thermometer-empty' => esc_html__( 'thermometer-empty', 'softing' )),
        array ('fas fa-thermometer-full' => esc_html__( 'thermometer-full', 'softing' )),
        array ('fas fa-thermometer-half' => esc_html__( 'thermometer-half', 'softing' )),
        array ('fas fa-thermometer-quarter' => esc_html__( 'thermometer-quarter', 'softing' )),
        array ('fas fa-thermometer-three-quarters' => esc_html__( 'thermometer-three-quarters', 'softing' )),
        array ('fas fa-thumbs-down' => esc_html__( 'thumbs-down', 'softing' )),
        array ('far fa-thumbs-down' => esc_html__( 'thumbs-down', 'softing' )),
        array ('fas fa-thumbs-up' => esc_html__( 'thumbs-up', 'softing' )),
        array ('far fa-thumbs-up' => esc_html__( 'thumbs-up', 'softing' )),
        array ('fas fa-thumbtack' => esc_html__( 'thumbtack', 'softing' )),
        array ('fas fa-ticket-alt' => esc_html__( 'ticket-alt', 'softing' )),
        array ('fas fa-times' => esc_html__( 'times', 'softing' )),
        array ('fas fa-times-circle' => esc_html__( 'times-circle', 'softing' )),
        array ('far fa-times-circle' => esc_html__( 'times-circle', 'softing' )),
        array ('fas fa-tint' => esc_html__( 'tint', 'softing' )),
        array ('fas fa-toggle-off' => esc_html__( 'toggle-off', 'softing' )),
        array ('fas fa-toggle-on' => esc_html__( 'toggle-on', 'softing' )),
        array ('fas fa-trademark' => esc_html__( 'trademark', 'softing' )),
        array ('fas fa-train' => esc_html__( 'train', 'softing' )),
        array ('fas fa-transgender' => esc_html__( 'transgender', 'softing' )),
        array ('fas fa-transgender-alt' => esc_html__( 'transgender-alt', 'softing' )),
        array ('fas fa-trash' => esc_html__( 'trash', 'softing' )),
        array ('fas fa-trash-alt' => esc_html__( 'trash-alt', 'softing' )),
        array ('far fa-trash-alt' => esc_html__( 'trash-alt', 'softing' )),
        array ('fas fa-tree' => esc_html__( 'tree', 'softing' )),
        array ('fab fa-trello' => esc_html__( 'trello', 'softing' )),
        array ('fab fa-tripadvisor' => esc_html__( 'tripadvisor', 'softing' )),
        array ('fas fa-trophy' => esc_html__( 'trophy', 'softing' )),
        array ('fas fa-truck' => esc_html__( 'truck', 'softing' )),
        array ('fas fa-truck-loading' => esc_html__( 'truck-loading', 'softing' )),
        array ('fas fa-truck-moving' => esc_html__( 'truck-moving', 'softing' )),
        array ('fas fa-tty' => esc_html__( 'tty', 'softing' )),
        array ('fab fa-tumblr' => esc_html__( 'tumblr', 'softing' )),
        array ('fab fa-tumblr-square' => esc_html__( 'tumblr-square', 'softing' )),
        array ('fas fa-tv' => esc_html__( 'tv', 'softing' )),
        array ('fab fa-twitch' => esc_html__( 'twitch', 'softing' )),
        array ('fab fa-twitter' => esc_html__( 'twitter', 'softing' )),
        array ('fab fa-twitter-square' => esc_html__( 'twitter-square', 'softing' )),
        array ('fab fa-typo3' => esc_html__( 'typo3', 'softing' )),
        array ('fab fa-uber' => esc_html__( 'uber', 'softing' )),
        array ('fab fa-uikit' => esc_html__( 'uikit', 'softing' )),
        array ('fas fa-umbrella' => esc_html__( 'umbrella', 'softing' )),
        array ('fas fa-underline' => esc_html__( 'underline', 'softing' )),
        array ('fas fa-undo' => esc_html__( 'undo', 'softing' )),
        array ('fas fa-undo-alt' => esc_html__( 'undo-alt', 'softing' )),
        array ('fab fa-uniregistry' => esc_html__( 'uniregistry', 'softing' )),
        array ('fas fa-universal-access' => esc_html__( 'universal-access', 'softing' )),
        array ('fas fa-university' => esc_html__( 'university', 'softing' )),
        array ('fas fa-unlink' => esc_html__( 'unlink', 'softing' )),
        array ('fas fa-unlock' => esc_html__( 'unlock', 'softing' )),
        array ('fas fa-unlock-alt' => esc_html__( 'unlock-alt', 'softing' )),
        array ('fab fa-untappd' => esc_html__( 'untappd', 'softing' )),
        array ('fas fa-upload' => esc_html__( 'upload', 'softing' )),
        array ('fab fa-usb' => esc_html__( 'usb', 'softing' )),
        array ('fas fa-user' => esc_html__( 'user', 'softing' )),
        array ('far fa-user' => esc_html__( 'user', 'softing' )),
        array ('fas fa-user-circle' => esc_html__( 'user-circle', 'softing' )),
        array ('far fa-user-circle' => esc_html__( 'user-circle', 'softing' )),
        array ('fas fa-user-md' => esc_html__( 'user-md', 'softing' )),
        array ('fas fa-user-plus' => esc_html__( 'user-plus', 'softing' )),
        array ('fas fa-user-secret' => esc_html__( 'user-secret', 'softing' )),
        array ('fas fa-user-times' => esc_html__( 'user-times', 'softing' )),
        array ('fas fa-users' => esc_html__( 'users', 'softing' )),
        array ('fab fa-ussunnah' => esc_html__( 'ussunnah', 'softing' )),
        array ('fas fa-utensil-spoon' => esc_html__( 'utensil-spoon', 'softing' )),
        array ('fas fa-utensils' => esc_html__( 'utensils', 'softing' )),
        array ('fab fa-vaadin' => esc_html__( 'vaadin', 'softing' )),
        array ('fas fa-venus' => esc_html__( 'venus', 'softing' )),
        array ('fas fa-venus-double' => esc_html__( 'venus-double', 'softing' )),
        array ('fas fa-venus-mars' => esc_html__( 'venus-mars', 'softing' )),
        array ('fab fa-viacoin' => esc_html__( 'viacoin', 'softing' )),
        array ('fab fa-viadeo' => esc_html__( 'viadeo', 'softing' )),
        array ('fab fa-viadeo-square' => esc_html__( 'viadeo-square', 'softing' )),
        array ('fas fa-vial' => esc_html__( 'vial', 'softing' )),
        array ('fas fa-vials' => esc_html__( 'vials', 'softing' )),
        array ('fab fa-viber' => esc_html__( 'viber', 'softing' )),
        array ('fas fa-video' => esc_html__( 'video', 'softing' )),
        array ('fas fa-video-slash' => esc_html__( 'video-slash', 'softing' )),
        array ('fab fa-vimeo' => esc_html__( 'vimeo', 'softing' )),
        array ('fab fa-vimeo-square' => esc_html__( 'vimeo-square', 'softing' )),
        array ('fab fa-vimeo-v' => esc_html__( 'vimeo-v', 'softing' )),
        array ('fab fa-vine' => esc_html__( 'vine', 'softing' )),
        array ('fab fa-vk' => esc_html__( 'vk', 'softing' )),
        array ('fab fa-vnv' => esc_html__( 'vnv', 'softing' )),
        array ('fas fa-volleyball-ball' => esc_html__( 'volleyball-ball', 'softing' )),
        array ('fas fa-volume-down' => esc_html__( 'volume-down', 'softing' )),
        array ('fas fa-volume-off' => esc_html__( 'volume-off', 'softing' )),
        array ('fas fa-volume-up' => esc_html__( 'volume-up', 'softing' )),
        array ('fab fa-vuejs' => esc_html__( 'vuejs', 'softing' )),
        array ('fas fa-warehouse' => esc_html__( 'warehouse', 'softing' )),
        array ('fab fa-weibo' => esc_html__( 'weibo', 'softing' )),
        array ('fas fa-weight' => esc_html__( 'weight', 'softing' )),
        array ('fab fa-weixin' => esc_html__( 'weixin', 'softing' )),
        array ('fab fa-whatsapp' => esc_html__( 'whatsapp', 'softing' )),
        array ('fab fa-whatsapp-square' => esc_html__( 'whatsapp-square', 'softing' )),
        array ('fas fa-wheelchair' => esc_html__( 'wheelchair', 'softing' )),
        array ('fab fa-whmcs' => esc_html__( 'whmcs', 'softing' )),
        array ('fas fa-wifi' => esc_html__( 'wifi', 'softing' )),
        array ('fab fa-wikipedia-w' => esc_html__( 'wikipedia-w', 'softing' )),
        array ('fas fa-window-close' => esc_html__( 'window-close', 'softing' )),
        array ('far fa-window-close' => esc_html__( 'window-close', 'softing' )),
        array ('fas fa-window-maximize' => esc_html__( 'window-maximize', 'softing' )),
        array ('far fa-window-maximize' => esc_html__( 'window-maximize', 'softing' )),
        array ('fas fa-window-minimize' => esc_html__( 'window-minimize', 'softing' )),
        array ('far fa-window-minimize' => esc_html__( 'window-minimize', 'softing' )),
        array ('fas fa-window-restore' => esc_html__( 'window-restore', 'softing' )),
        array ('far fa-window-restore' => esc_html__( 'window-restore', 'softing' )),
        array ('fab fa-windows' => esc_html__( 'windows', 'softing' )),
        array ('fas fa-wine-glass' => esc_html__( 'wine-glass', 'softing' )),
        array ('fas fa-won-sign' => esc_html__( 'won-sign', 'softing' )),
        array ('fab fa-wordpress' => esc_html__( 'wordpress', 'softing' )),
        array ('fab fa-wordpress-simple' => esc_html__( 'wordpress-simple', 'softing' )),
        array ('fab fa-wpbeginner' => esc_html__( 'wpbeginner', 'softing' )),
        array ('fab fa-wpexplorer' => esc_html__( 'wpexplorer', 'softing' )),
        array ('fab fa-wpforms' => esc_html__( 'wpforms', 'softing' )),
        array ('fas fa-wrench' => esc_html__( 'wrench', 'softing' )),
        array ('fas fa-x-ray' => esc_html__( 'x-ray', 'softing' )),
        array ('fab fa-xbox' => esc_html__( 'xbox', 'softing' )),
        array ('fab fa-xing' => esc_html__( 'xing', 'softing' )),
        array ('fab fa-xing-square' => esc_html__( 'xing-square', 'softing' )),
        array ('fab fa-y-combinator' => esc_html__( 'y-combinator', 'softing' )),
        array ('fab fa-yahoo' => esc_html__( 'yahoo', 'softing' )),
        array ('fab fa-yandex' => esc_html__( 'yandex', 'softing' )),
        array ('fab fa-yandex-international' => esc_html__( 'yandex-international', 'softing' )),
        array ('fab fa-yelp' => esc_html__( 'yelp', 'softing' )),
        array ('fas fa-yen-sign' => esc_html__( 'yen-sign', 'softing' )),
        array ('fab fa-yoast' => esc_html__( 'yoast', 'softing' )),
        array ('fab fa-youtube' => esc_html__( 'youtube', 'softing' )),
        array ('fab fa-youtube-square' => esc_html__( 'youtube-square', 'softing' )),
    );
}


	// Add new custom font to Font Family selection in icon box module
	function softing_add_ionicons( ) {
		$param = WPBMap::getParam( 'vc_icon', 'type' );
		$param['value'][__( 'Ionicons', 'softing' )] = 'ionicons';
		vc_update_shortcode_param( 'vc_icon', $param );
		$param1 = WPBMap::getParam( 'vc_icon', 'size' );
		$param1['value'][__( 'Theme size', 'softing' )] = 'c-summary-1-icon';
		vc_update_shortcode_param( 'vc_icon', $param1 );
	}
	add_filter( 'init', 'softing_add_ionicons', 40 );

	// Add font picker setting to icon box module when you select your font family from the dropdown
	function softing_add_font_picker() {
		vc_add_param( 'vc_icon', array(
				'type' 			=> 'iconpicker',
				'weight' 		=> 1,
				'heading' 		=> esc_html__( 'Icon', 'softing' ),
				'param_name' 	=> 'icon_ionicons',
				'settings' 		=> array(
						'emptyIcon' 	=> false,
						'type' 			=> 'ionicons',
						'iconsPerPage' 	=> 200,
				),
				'dependency' 	=> array(
						'element' 	=> 'type',
						'value' 	=> 'ionicons',
				),
			)
		);
	}
	add_filter( 'vc_after_init', 'softing_add_font_picker', 40 );

	// Add array of your fonts so they can be displayed in the font selector
	function softing_icon_array() {
		return array(
         array('ionicons ion-alert' => 'alert'),
         array('ionicons ion-alert-circled' => 'alert-circled'),
         array('ionicons ion-android-add' => 'android-add'),
         array('ionicons ion-android-add-circle' => 'android-add-circle'),
         array('ionicons ion-android-alarm-clock' => 'android-alarm-clock'),
         array('ionicons ion-android-alert' => 'android-alert'),
         array('ionicons ion-android-apps' => 'android-apps'),
         array('ionicons ion-android-archive' => 'android-archive'),
         array('ionicons ion-android-arrow-back' => 'android-arrow-back'),
         array('ionicons ion-android-arrow-down' => 'android-arrow-down'),
         array('ionicons ion-android-arrow-dropdown' => 'android-arrow-dropdown'),
         array('ionicons ion-android-arrow-dropdown-circle' => 'android-arrow-dropdown-circle'),
         array('ionicons ion-android-arrow-dropleft' => 'android-arrow-dropleft'),
         array('ionicons ion-android-arrow-dropleft-circle' => 'android-arrow-dropleft-circle'),
         array('ionicons ion-android-arrow-dropright' => 'android-arrow-dropright'),
         array('ionicons ion-android-arrow-dropright-circle' => 'android-arrow-dropright-circle'),
         array('ionicons ion-android-arrow-dropup' => 'android-arrow-dropup'),
         array('ionicons ion-android-arrow-dropup-circle' => 'android-arrow-dropup-circle'),
         array('ionicons ion-android-arrow-forward' => 'android-arrow-forward'),
         array('ionicons ion-android-arrow-up' => 'android-arrow-up'),
         array('ionicons ion-android-attach' => 'android-attach'),
         array('ionicons ion-android-bar' => 'android-bar'),
         array('ionicons ion-android-bicycle' => 'android-bicycle'),
         array('ionicons ion-android-boat' => 'android-boat'),
         array('ionicons ion-android-bookmark' => 'android-bookmark'),
         array('ionicons ion-android-bulb' => 'android-bulb'),
         array('ionicons ion-android-bus' => 'android-bus'),
         array('ionicons ion-android-calendar' => 'android-calendar'),
         array('ionicons ion-android-call' => 'android-call'),
         array('ionicons ion-android-camera' => 'android-camera'),
         array('ionicons ion-android-cancel' => 'android-cancel'),
         array('ionicons ion-android-car' => 'android-car'),
         array('ionicons ion-android-cart' => 'android-cart'),
         array('ionicons ion-android-chat' => 'android-chat'),
         array('ionicons ion-android-checkbox' => 'android-checkbox'),
         array('ionicons ion-android-checkbox-blank' => 'android-checkbox-blank'),
         array('ionicons ion-android-checkbox-outline' => 'android-checkbox-outline'),
         array('ionicons ion-android-checkbox-outline-blank' => 'android-checkbox-outline-blank'),
         array('ionicons ion-android-checkmark-circle' => 'android-checkmark-circle'),
         array('ionicons ion-android-clipboard' => 'android-clipboard'),
         array('ionicons ion-android-close' => 'android-close'),
         array('ionicons ion-android-cloud' => 'android-cloud'),
         array('ionicons ion-android-cloud-circle' => 'android-cloud-circle'),
         array('ionicons ion-android-cloud-done' => 'android-cloud-done'),
         array('ionicons ion-android-cloud-outline' => 'android-cloud-outline'),
         array('ionicons ion-android-color-palette' => 'android-color-palette'),
         array('ionicons ion-android-compass' => 'android-compass'),
         array('ionicons ion-android-contact' => 'android-contact'),
         array('ionicons ion-android-contacts' => 'android-contacts'),
         array('ionicons ion-android-contract' => 'android-contract'),
         array('ionicons ion-android-create' => 'android-create'),
         array('ionicons ion-android-delete' => 'android-delete'),
         array('ionicons ion-android-desktop' => 'android-desktop'),
         array('ionicons ion-android-document' => 'android-document'),
         array('ionicons ion-android-done' => 'android-done'),
         array('ionicons ion-android-done-all' => 'android-done-all'),
         array('ionicons ion-android-download' => 'android-download'),
         array('ionicons ion-android-drafts' => 'android-drafts'),
         array('ionicons ion-android-exit' => 'android-exit'),
         array('ionicons ion-android-expand' => 'android-expand'),
         array('ionicons ion-android-favorite' => 'android-favorite'),
         array('ionicons ion-android-favorite-outline' => 'android-favorite-outline'),
         array('ionicons ion-android-film' => 'android-film'),
         array('ionicons ion-android-folder' => 'android-folder'),
         array('ionicons ion-android-folder-open' => 'android-folder-open'),
         array('ionicons ion-android-funnel' => 'android-funnel'),
         array('ionicons ion-android-globe' => 'android-globe'),
         array('ionicons ion-android-hand' => 'android-hand'),
         array('ionicons ion-android-hangout' => 'android-hangout'),
         array('ionicons ion-android-happy' => 'android-happy'),
         array('ionicons ion-android-home' => 'android-home'),
         array('ionicons ion-android-image' => 'android-image'),
         array('ionicons ion-android-laptop' => 'android-laptop'),
         array('ionicons ion-android-list' => 'android-list'),
         array('ionicons ion-android-locate' => 'android-locate'),
         array('ionicons ion-android-lock' => 'android-lock'),
         array('ionicons ion-android-mail' => 'android-mail'),
         array('ionicons ion-android-map' => 'android-map'),
         array('ionicons ion-android-menu' => 'android-menu'),
         array('ionicons ion-android-microphone' => 'android-microphone'),
         array('ionicons ion-android-microphone-off' => 'android-microphone-off'),
         array('ionicons ion-android-more-horizontal' => 'android-more-horizontal'),
         array('ionicons ion-android-more-vertical' => 'android-more-vertical'),
         array('ionicons ion-android-navigate' => 'android-navigate'),
         array('ionicons ion-android-notifications' => 'android-notifications'),
         array('ionicons ion-android-notifications-none' => 'android-notifications-none'),
         array('ionicons ion-android-notifications-off' => 'android-notifications-off'),
         array('ionicons ion-android-open' => 'android-open'),
         array('ionicons ion-android-options' => 'android-options'),
         array('ionicons ion-android-people' => 'android-people'),
         array('ionicons ion-android-person' => 'android-person'),
         array('ionicons ion-android-person-add' => 'android-person-add'),
         array('ionicons ion-android-phone-landscape' => 'android-phone-landscape'),
         array('ionicons ion-android-phone-portrait' => 'android-phone-portrait'),
         array('ionicons ion-android-pin' => 'android-pin'),
         array('ionicons ion-android-plane' => 'android-plane'),
         array('ionicons ion-android-playstore' => 'android-playstore'),
         array('ionicons ion-android-print' => 'android-print'),
         array('ionicons ion-android-radio-button-off' => 'android-radio-button-off'),
         array('ionicons ion-android-radio-button-on' => 'android-radio-button-on'),
         array('ionicons ion-android-refresh' => 'android-refresh'),
         array('ionicons ion-android-remove' => 'android-remove'),
         array('ionicons ion-android-remove-circle' => 'android-remove-circle'),
         array('ionicons ion-android-restaurant' => 'android-restaurant'),
         array('ionicons ion-android-sad' => 'android-sad'),
         array('ionicons ion-android-search' => 'android-search'),
         array('ionicons ion-android-send' => 'android-send'),
         array('ionicons ion-android-settings' => 'android-settings'),
         array('ionicons ion-android-share' => 'android-share'),
         array('ionicons ion-android-share-alt' => 'android-share-alt'),
         array('ionicons ion-android-star' => 'android-star'),
         array('ionicons ion-android-star-half' => 'android-star-half'),
         array('ionicons ion-android-star-outline' => 'android-star-outline'),
         array('ionicons ion-android-stopwatch' => 'android-stopwatch'),
         array('ionicons ion-android-subway' => 'android-subway'),
         array('ionicons ion-android-sunny' => 'android-sunny'),
         array('ionicons ion-android-sync' => 'android-sync'),
         array('ionicons ion-android-textsms' => 'android-textsms'),
         array('ionicons ion-android-time' => 'android-time'),
         array('ionicons ion-android-train' => 'android-train'),
         array('ionicons ion-android-unlock' => 'android-unlock'),
         array('ionicons ion-android-upload' => 'android-upload'),
         array('ionicons ion-android-volume-down' => 'android-volume-down'),
         array('ionicons ion-android-volume-mute' => 'android-volume-mute'),
         array('ionicons ion-android-volume-off' => 'android-volume-off'),
         array('ionicons ion-android-volume-up' => 'android-volume-up'),
         array('ionicons ion-android-walk' => 'android-walk'),
         array('ionicons ion-android-warning' => 'android-warning'),
         array('ionicons ion-android-watch' => 'android-watch'),
         array('ionicons ion-android-wifi' => 'android-wifi'),
         array('ionicons ion-aperture' => 'aperture'),
         array('ionicons ion-archive' => 'archive'),
         array('ionicons ion-arrow-down-a' => 'arrow-down-a'),
         array('ionicons ion-arrow-down-b' => 'arrow-down-b'),
         array('ionicons ion-arrow-down-c' => 'arrow-down-c'),
         array('ionicons ion-arrow-expand' => 'arrow-expand'),
         array('ionicons ion-arrow-graph-down-left' => 'arrow-graph-down-left'),
         array('ionicons ion-arrow-graph-down-right' => 'arrow-graph-down-right'),
         array('ionicons ion-arrow-graph-up-left' => 'arrow-graph-up-left'),
         array('ionicons ion-arrow-graph-up-right' => 'arrow-graph-up-right'),
         array('ionicons ion-arrow-left-a' => 'arrow-left-a'),
         array('ionicons ion-arrow-left-b' => 'arrow-left-b'),
         array('ionicons ion-arrow-left-c' => 'arrow-left-c'),
         array('ionicons ion-arrow-move' => 'arrow-move'),
         array('ionicons ion-arrow-resize' => 'arrow-resize'),
         array('ionicons ion-arrow-return-left' => 'arrow-return-left'),
         array('ionicons ion-arrow-return-right' => 'arrow-return-right'),
         array('ionicons ion-arrow-right-a' => 'arrow-right-a'),
         array('ionicons ion-arrow-right-b' => 'arrow-right-b'),
         array('ionicons ion-arrow-right-c' => 'arrow-right-c'),
         array('ionicons ion-arrow-shrink' => 'arrow-shrink'),
         array('ionicons ion-arrow-swap' => 'arrow-swap'),
         array('ionicons ion-arrow-up-a' => 'arrow-up-a'),
         array('ionicons ion-arrow-up-b' => 'arrow-up-b'),
         array('ionicons ion-arrow-up-c' => 'arrow-up-c'),
         array('ionicons ion-asterisk' => 'asterisk'),
         array('ionicons ion-at' => 'at'),
         array('ionicons ion-backspace' => 'backspace'),
         array('ionicons ion-backspace-outline' => 'backspace-outline'),
         array('ionicons ion-bag' => 'bag'),
         array('ionicons ion-battery-charging' => 'battery-charging'),
         array('ionicons ion-battery-empty' => 'battery-empty'),
         array('ionicons ion-battery-full' => 'battery-full'),
         array('ionicons ion-battery-half' => 'battery-half'),
         array('ionicons ion-battery-low' => 'battery-low'),
         array('ionicons ion-beaker' => 'beaker'),
         array('ionicons ion-beer' => 'beer'),
         array('ionicons ion-bluetooth' => 'beer'),
         array('ionicons ion-softingfire' => 'softingfire'),
         array('ionicons ion-bookmark' => 'bookmark'),
         array('ionicons ion-bowtie' => 'bowtie'),
         array('ionicons ion-briefcase' => 'briefcase'),
         array('ionicons ion-bug' => 'bug'),
         array('ionicons ion-calculator' => 'calculator'),
         array('ionicons ion-calendar' => 'calendar'),
         array('ionicons ion-camera' => 'camera'),
         array('ionicons ion-card' => 'card'),
         array('ionicons ion-cash' => 'cash'),
         array('ionicons ion-chatbox' => 'chatbox'),
         array('ionicons ion-chatbox-working' => 'chatbox-working'),
         array('ionicons ion-chatboxes' => 'chatboxes'),
         array('ionicons ion-chatbubble' => 'chatbubble'),
         array('ionicons ion-chatbubble-working' => 'chatbubble-working'),
         array('ionicons ion-chatbubbles' => 'chatbubbles'),
         array('ionicons ion-checkmark' => 'checkmark'),
         array('ionicons ion-checkmark-circled' => 'checkmark-circled'),
         array('ionicons ion-checkmark-round' => 'checkmark-round'),
         array('ionicons ion-chevron-down' => 'chevron-down'),
         array('ionicons ion-chevron-left' => 'chevron-left'),
         array('ionicons ion-chevron-right' => 'chevron-right'),
         array('ionicons ion-chevron-up' => 'chevron-up'),
         array('ionicons ion-clipboard' => 'clipboard'),
         array('ionicons ion-clock' => 'clock'),
         array('ionicons ion-close' => 'close'),
         array('ionicons ion-close-circled' => 'close-circled'),
         array('ionicons ion-close-round' => 'close-round'),
         array('ionicons ion-closed-captioning' => 'closed-captioning'),
         array('ionicons ion-cloud' => 'cloud'),
         array('ionicons ion-code' => 'code'),
         array('ionicons ion-code-download' => 'code-download'),
         array('ionicons ion-code-working' => 'code-working'),
         array('ionicons ion-coffee' => 'coffee'),
         array('ionicons ion-compass' => 'compass'),
         array('ionicons ion-compose' => 'compose'),
         array('ionicons ion-connection-bars' => 'connection-bars'),
         array('ionicons ion-contrast' => 'contrast'),
         array('ionicons ion-crop' => 'crop'),
         array('ionicons ion-cube' => 'cube'),
         array('ionicons ion-disc' => 'disc'),
         array('ionicons ion-document' => 'document'),
         array('ionicons ion-document-text' => 'document-text'),
         array('ionicons ion-drag' => 'drag'),
         array('ionicons ion-earth' => 'earth'),
         array('ionicons ion-easel' => 'easel'),
         array('ionicons ion-edit' => 'edit'),
         array('ionicons ion-egg' => 'egg'),
         array('ionicons ion-eject' => 'eject'),
         array('ionicons ion-email' => 'email'),
         array('ionicons ion-email-unread' => 'email-unread'),
         array('ionicons ion-erlenmeyer-flask' => 'erlenmeyer-flask'),
         array('ionicons ion-erlenmeyer-flask-bubbles' => 'erlenmeyer-flask-bubbles'),
         array('ionicons ion-eye' => 'eye'),
         array('ionicons ion-eye-disabled' => 'eye-disabled'),
         array('ionicons ion-female' => 'female'),
         array('ionicons ion-filing' => 'filing'),
         array('ionicons ion-film-marker' => 'film-marker'),
         array('ionicons ion-fireball' => 'fireball'),
         array('ionicons ion-flag' => 'flag'),
         array('ionicons ion-flame' => 'flame'),
         array('ionicons ion-flash' => 'flash'),
         array('ionicons ion-flash-off' => 'flash-off'),
         array('ionicons ion-folder' => 'folder'),
         array('ionicons ion-fork' => 'fork'),
         array('ionicons ion-fork-repo' => 'fork-repo'),
         array('ionicons ion-forward' => 'forward'),
         array('ionicons ion-funnel' => 'funnel'),
         array('ionicons ion-gear-a' => 'gear-a'),
         array('ionicons ion-gear-b' => 'gear-b'),
         array('ionicons ion-grid' => 'grid'),
         array('ionicons ion-hammer' => 'hammer'),
         array('ionicons ion-happy' => 'happy'),
         array('ionicons ion-happy-outline' => 'happy-outline'),
         array('ionicons ion-headphone' => 'headphone'),
         array('ionicons ion-heart' => 'heart'),
         array('ionicons ion-heart-broken' => 'heart-broken'),
         array('ionicons ion-help' => 'help'),
         array('ionicons ion-help-buoy' => 'help-buoy'),
         array('ionicons ion-help-circled' => 'help-circled'),
         array('ionicons ion-home' => 'home'),
         array('ionicons ion-icecream' => 'icecream'),
         array('ionicons ion-image' => 'image'),
         array('ionicons ion-images' => 'images'),
         array('ionicons ion-information' => 'information'),
         array('ionicons ion-information-circled' => 'information-circled'),
         array('ionicons ion-ionic' => 'ionic'),
         array('ionicons ion-ios-alarm' => 'ios-alarm'),
         array('ionicons ion-ios-alarm-outline' => 'ios-alarm-outline'),
         array('ionicons ion-ios-albums' => 'ios-albums'),
         array('ionicons ion-ios-albums-outline' => 'ios-albums-outline'),
         array('ionicons ion-ios-americanfootball' => 'ios-americanfootball'),
         array('ionicons ion-ios-americanfootball-outline' => 'ios-americanfootball-outline'),
         array('ionicons ion-ios-analytics' => 'ios-analytics'),
         array('ionicons ion-ios-analytics-outline' => 'ios-analytics-outline'),
         array('ionicons ion-ios-arrow-back' => 'ios-arrow-back'),
         array('ionicons ion-ios-arrow-down' => 'ios-arrow-down'),
         array('ionicons ion-ios-arrow-forward' => 'ios-arrow-forward'),
         array('ionicons ion-ios-arrow-left' => 'ios-arrow-left'),
         array('ionicons ion-ios-arrow-right' => 'ios-arrow-right'),
         array('ionicons ion-ios-arrow-thin-down' => 'ios-arrow-thin-down'),
         array('ionicons ion-ios-arrow-thin-left' => 'ios-arrow-thin-left'),
         array('ionicons ion-ios-arrow-thin-right' => 'ios-arrow-thin-right'),
         array('ionicons ion-ios-arrow-thin-up' => 'ios-arrow-thin-up'),
         array('ionicons ion-ios-arrow-up' => 'ios-arrow-up'),
         array('ionicons ion-ios-at' => 'ios-at'),
         array('ionicons ion-ios-at-outline' => 'ios-at-outline'),
         array('ionicons ion-ios-barcode' => 'ios-barcode'),
         array('ionicons ion-ios-barcode-outline' => 'ios-barcode-outline'),
         array('ionicons ion-ios-baseball' => 'ios-baseball'),
         array('ionicons ion-ios-baseball-outline' => 'ios-baseball-outline'),
         array('ionicons ion-ios-basketball' => 'ios-basketball'),
         array('ionicons ion-ios-basketball-outline' => 'ios-basketball-outline'),
         array('ionicons ion-ios-bell' => 'ios-bell'),
         array('ionicons ion-ios-bell-outline' => 'ios-bell-outline'),
         array('ionicons ion-ios-body' => 'ios-body'),
         array('ionicons ion-ios-body-outline' => 'ios-body-outline'),
         array('ionicons ion-ios-bolt' => 'ios-bolt'),
         array('ionicons ion-ios-bolt-outline' => 'ios-bolt-outline'),
         array('ionicons ion-ios-book' => 'ios-book'),
         array('ionicons ion-ios-book-outline' => 'ios-book-outline'),
         array('ionicons ion-ios-bookmarks' => 'ios-bookmarks'),
         array('ionicons ion-ios-bookmarks-outline' => 'ios-bookmarks-outline'),
         array('ionicons ion-ios-box' => 'ios-box'),
         array('ionicons ion-ios-box-outline' => 'ios-box-outline'),
         array('ionicons ion-ios-briefcase' => 'ios-briefcase'),
         array('ionicons ion-ios-briefcase-outline' => 'ios-briefcase-outline'),
         array('ionicons ion-ios-browsers' => 'ios-browsers'),
         array('ionicons ion-ios-browsers-outline' => 'ios-browsers-outline'),
         array('ionicons ion-ios-calculator' => 'ios-calculator'),
         array('ionicons ion-ios-calculator-outline' => 'ios-calculator-outline'),
         array('ionicons ion-ios-calendar' => 'ios-calendar'),
         array('ionicons ion-ios-calendar-outline' => 'ios-calendar-outline'),
         array('ionicons ion-ios-camera' => 'ios-camera'),
         array('ionicons ion-ios-camera-outline' => 'ios-camera-outline'),
         array('ionicons ion-ios-cart' => 'ios-cart'),
         array('ionicons ion-ios-cart-outline' => 'ios-cart-outline'),
         array('ionicons ion-ios-chatboxes' => 'ios-chatboxes'),
         array('ionicons ion-ios-chatboxes-outline' => 'ios-chatboxes-outline'),
         array('ionicons ion-ios-chatbubble' => 'ios-chatbubble'),
         array('ionicons ion-ios-chatbubble-outline' => 'ios-chatbubble-outline'),
         array('ionicons ion-ios-checkmark' => 'ios-checkmark'),
         array('ionicons ion-ios-checkmark-empty' => 'ios-checkmark-empty'),
         array('ionicons ion-ios-checkmark-outline' => 'ios-checkmark-outline'),
         array('ionicons ion-ios-circle-filled' => 'ios-circle-filled'),
         array('ionicons ion-ios-circle-outline' => 'ios-circle-outline'),
         array('ionicons ion-ios-clock' => 'ios-clock'),
         array('ionicons ion-ios-clock-outline' => 'ios-clock-outline'),
         array('ionicons ion-ios-close' => 'ios-close'),
         array('ionicons ion-ios-close-empty' => 'ios-close-empty'),
         array('ionicons ion-ios-close-outline' => 'ios-close-outline'),
         array('ionicons ion-ios-cloud' => 'ios-cloud'),
         array('ionicons ion-ios-cloud-download' => 'ios-cloud-download'),
         array('ionicons ion-ios-cloud-download-outline' => 'ios-cloud-download-outline'),
         array('ionicons ion-ios-cloud-outline' => 'ios-cloud-outline'),
         array('ionicons ion-ios-cloud-upload' => 'ios-cloud-upload'),
         array('ionicons ion-ios-cloud-upload-outline' => 'ios-cloud-upload-outline'),
         array('ionicons ion-ios-cloudy' => 'ios-cloudy'),
         array('ionicons ion-ios-cloudy-night' => 'ios-cloudy-night'),
         array('ionicons ion-ios-cloudy-night-outline' => 'ios-cloudy-night-outline'),
         array('ionicons ion-ios-cloudy-outline' => 'ios-cloudy-outline'),
         array('ionicons ion-ios-cog' => 'ios-cog'),
         array('ionicons ion-ios-cog-outline' => 'ios-cog-outline'),
         array('ionicons ion-ios-color-filter' => 'ios-color-filter'),
         array('ionicons ion-ios-color-filter-outline' => 'ios-color-filter-outline'),
         array('ionicons ion-ios-color-wand' => 'ios-color-wand'),
         array('ionicons ion-ios-color-wand-outline' => 'ios-color-wand-outline'),
         array('ionicons ion-ios-compose' => 'ios-compose'),
         array('ionicons ion-ios-compose-outline' => 'ios-compose-outline'),
         array('ionicons ion-ios-contact' => 'ios-contact'),
         array('ionicons ion-ios-contact-outline' => 'ios-contact-outline'),
         array('ionicons ion-ios-copy' => 'ios-copy'),
         array('ionicons ion-ios-copy-outline' => 'ios-copy-outline'),
         array('ionicons ion-ios-crop' => 'ios-crop'),
         array('ionicons ion-ios-crop-strong' => 'ios-crop-strong'),
         array('ionicons ion-ios-download' => 'ios-download'),
         array('ionicons ion-ios-download-outline' => 'ios-download-outline'),
         array('ionicons ion-ios-drag' => 'ios-drag'),
         array('ionicons ion-ios-email' => 'ios-email'),
         array('ionicons ion-ios-email-outline' => 'ios-email-outline'),
         array('ionicons ion-ios-eye' => 'ios-eye'),
         array('ionicons ion-ios-eye-outline' => 'ios-eye-outline'),
         array('ionicons ion-ios-fastforward' => 'ios-fastforward'),
         array('ionicons ion-ios-fastforward-outline' => 'ios-fastforward-outline'),
         array('ionicons ion-ios-filing' => 'ios-filing'),
         array('ionicons ion-ios-filing-outline' => 'ios-filing-outline'),
         array('ionicons ion-ios-film' => 'ios-film'),
         array('ionicons ion-ios-film-outline' => 'ios-film-outline'),
         array('ionicons ion-ios-flag' => 'ios-flag'),
         array('ionicons ion-ios-flag-outline' => 'flag-outline'),
         array('ionicons ion-ios-flame' => 'ios-flame'),
         array('ionicons ion-ios-flame-outline' => 'ios-flame-outline'),
         array('ionicons ion-ios-flask' => 'ios-flask'),
         array('ionicons ion-ios-flask-outline' => 'flask-outline'),
         array('ionicons ion-ios-flower' => 'ios-flower'),
         array('ionicons ion-ios-flower-outline' => 'ios-flower-outline'),
         array('ionicons ion-ios-folder' => 'ios-folder'),
         array('ionicons ion-ios-folder-outline' => 'ios-folder-outline'),
         array('ionicons ion-ios-football' => 'ios-football'),
         array('ionicons ion-ios-football-outline' => 'ios-football-outline'),
         array('ionicons ion-ios-game-controller-a' => 'ios-game-controller-a'),
         array('ionicons ion-ios-game-controller-a-outline' => 'ios-game-controller-a-outline'),
         array('ionicons ion-ios-game-controller-b' => 'ios-game-controller-b'),
         array('ionicons ion-ios-game-controller-b-outline' => 'ios-game-controller-b-outline'),
         array('ionicons ion-ios-gear' => 'ios-gear'),
         array('ionicons ion-ios-gear-outline' => 'ios-gear-outline'),
         array('ionicons ion-ios-glasses' => 'ios-glasses'),
         array('ionicons ion-ios-glasses-outline' => 'ios-glasses-outline'),
         array('ionicons ion-ios-grid-view' => 'ios-grid-view'),
         array('ionicons ion-ios-grid-view-outline' => 'ios-grid-view-outline'),
         array('ionicons ion-ios-heart' => 'ios-heart'),
         array('ionicons ion-ios-heart-outline' => 'ios-heart-outline'),
         array('ionicons ion-ios-help' => 'ios-help'),
         array('ionicons ion-ios-help-empty' => 'ios-help-empty'),
         array('ionicons ion-ios-help-outline' => 'ios-help-outline'),
         array('ionicons ion-ios-home' => 'ios-home'),
         array('ionicons ion-ios-home-outline' => 'ios-home-outline'),
         array('ionicons ion-ios-infinite' => 'ios-infinite'),
         array('ionicons ion-ios-infinite-outline' => 'ios-infinite-outline'),
         array('ionicons ion-ios-information' => 'ios-information'),
         array('ionicons ion-ios-information-empty' => 'ios-information-empty'),
         array('ionicons ion-ios-information-outline' => 'ios-information-outline'),
         array('ionicons ion-ios-ionic-outline' => 'ios-ionic-outline'),
         array('ionicons ion-ios-keypad' => 'ios-ionic-outline'),
         array('ionicons ion-ios-keypad-outline' => 'ios-keypad-outline'),
         array('ionicons ion-ios-lightbulb' => 'ios-lightbulb'),
         array('ionicons ion-ios-lightbulb-outline' => 'ios-lightbulb-outline'),
         array('ionicons ion-ios-list' => 'ios-list'),
         array('ionicons ion-ios-list-outline' => 'ios-list-outline'),
         array('ionicons ion-ios-location' => 'ios-location'),
         array('ionicons ion-ios-location-outline' => 'ios-location-outline'),
         array('ionicons ion-ios-locked' => 'ios-locked'),
         array('ionicons ion-ios-locked-outline' => 'ios-locked-outline'),
         array('ionicons ion-ios-loop' => 'ios-loop'),
         array('ionicons ion-ios-loop-strong' => 'ios-loop-strong'),
         array('ionicons ion-ios-medical' => 'ios-medical'),
         array('ionicons ion-ios-medical-outline' => 'ios-medical-outline'),
         array('ionicons ion-ios-medkit' => 'ios-medkit'),
         array('ionicons ion-ios-medkit-outline' => 'ios-medkit-outline'),
         array('ionicons ion-ios-mic' => 'ios-mic'),
         array('ionicons ion-ios-mic-off' => 'ios-mic-off'),
         array('ionicons ion-ios-mic-outline' => 'ios-mic-outline'),
         array('ionicons ion-ios-minus' => 'ios-minus'),
         array('ionicons ion-ios-minus-empty' => 'ios-minus-empty'),
         array('ionicons ion-ios-minus-outline' => 'ios-minus-outline'),
         array('ionicons ion-ios-monitor' => 'ios-monitor'),
         array('ionicons ion-ios-monitor-outline' => 'ios-monitor-outline'),
         array('ionicons ion-ios-moon' => 'ios-moon'),
         array('ionicons ion-ios-moon-outline' => 'ios-moon-outline'),
         array('ionicons ion-ios-more' => 'ios-more'),
         array('ionicons ion-ios-more-outline' => 'ios-more-outline'),
         array('ionicons ion-ios-musical-note' => 'ios-musical-note'),
         array('ionicons ion-ios-musical-notes' => 'ios-musical-notes'),
         array('ionicons ion-ios-navigate' => 'ios-navigate'),
         array('ionicons ion-ios-navigate-outline' => 'ios-navigate-outline'),
         array('ionicons ion-ios-nutrition' => 'ios-nutrition'),
         array('ionicons ion-ios-nutrition-outline' => 'nutrition-outline'),
         array('ionicons ion-ios-paper' => 'ios-paper'),
         array('ionicons ion-ios-paper-outline' => 'ios-paper-outline'),
         array('ionicons ion-ios-paperplane' => 'ios-paperplane'),
         array('ionicons ion-ios-paperplane-outline' => 'ios-paperplane-outline'),
         array('ionicons ion-ios-partlysunny' => 'ios-partlysunny'),
         array('ionicons ion-ios-partlysunny-outline' => 'ios-partlysunny-outline'),
         array('ionicons ion-ios-pause' => 'ios-pause'),
         array('ionicons ion-ios-pause-outline' => 'ios-pause-outline'),
         array('ionicons ion-ios-paw' => 'ios-paw'),
         array('ionicons ion-ios-paw-outline' => 'ios-paw-outline'),
         array('ionicons ion-ios-people' => 'ios-people'),
         array('ionicons ion-ios-people-outline' => 'ios-people-outline'),
         array('ionicons ion-ios-person' => 'ios-person'),
         array('ionicons ion-ios-person-outline' => 'ios-person-outline'),
         array('ionicons ion-ios-personadd' => 'ios-personadd'),
         array('ionicons ion-ios-personadd-outline' => 'ios-personadd-outline'),
         array('ionicons ion-ios-photos' => 'ios-photos'),
         array('ionicons ion-ios-photos-outline' => 'ios-photos-outline'),
         array('ionicons ion-ios-pie' => 'ios-pie'),
         array('ionicons ion-ios-pie-outline' => 'ios-pie-outline'),
         array('ionicons ion-ios-pint' => 'ios-pint'),
         array('ionicons ion-ios-pint-outline' => 'pint-outline'),
         array('ionicons ion-ios-play' => 'ios-play'),
         array('ionicons ion-ios-play-outline' => 'ios-play-outline'),
         array('ionicons ion-ios-plus' => 'ios-plus'),
         array('ionicons ion-ios-plus-empty' => 'ios-plus-empty'),
         array('ionicons ion-ios-plus-outline' => 'ios-plus-outline'),
         array('ionicons ion-ios-pricetag' => 'ios-pricetag'),
         array('ionicons ion-ios-pricetag-outline' => 'ios-pricetag-outline'),
         array('ionicons ion-ios-pricetags' => 'ios-pricetags'),
         array('ionicons ion-ios-pricetags-outline' => 'pricetags-outline'),
         array('ionicons ion-ios-printer' => 'ios-printer'),
         array('ionicons ion-ios-printer-outline' => 'printer-outline'),
         array('ionicons ion-ios-pulse' => 'ios-pulse'),
         array('ionicons ion-ios-pulse-strong' => 'ios-pulse-strong'),
         array('ionicons ion-ios-rainy' => 'ios-rainy'),
         array('ionicons ion-ios-rainy-outline' => 'ios-rainy-outline'),
         array('ionicons ion-ios-recording' => 'ios-recording'),
         array('ionicons ion-ios-recording-outline' => 'ios-recording-outline'),
         array('ionicons ion-ios-redo' => 'ios-redo'),
         array('ionicons ion-ios-redo-outline' => 'ios-redo-outline'),
         array('ionicons ion-ios-refresh' => 'ios-refresh'),
         array('ionicons ion-ios-refresh-empty' => 'ios-refresh-empty'),
         array('ionicons ion-ios-refresh-outline' => 'ios-refresh-outline'),
         array('ionicons ion-ios-reload' => 'ios-reload'),
         array('ionicons ion-ios-reverse-camera' => 'ios-reverse-camera'),
         array('ionicons ion-ios-reverse-camera-outline' => 'ios-reverse-camera-outline'),
         array('ionicons ion-ios-rewind' => 'ios-rewind'),
         array('ionicons ion-ios-rewind-outline' => 'ios-rewind-outline'),
         array('ionicons ion-ios-rose' => 'ios-rose'),
         array('ionicons ion-ios-rose-outline' => 'ios-rose-outline'),
         array('ionicons ion-ios-search' => 'ios-search'),
         array('ionicons ion-ios-search-strong' => 'ios-search-strong'),
         array('ionicons ion-ios-settings' => 'ios-settings'),
         array('ionicons ion-ios-settings-strong' => 'ios-settings-strong'),
         array('ionicons ion-ios-shuffle' => 'ios-shuffle'),
         array('ionicons ion-ios-shuffle-strong' => 'ios-shuffle-strong'),
         array('ionicons ion-ios-skipbackward' => 'ios-skipbackward'),
         array('ionicons ion-ios-skipbackward-outline' => 'ios-skipbackward-outline'),
         array('ionicons ion-ios-skipforward' => 'ios-skipforward'),
         array('ionicons ion-ios-skipforward-outline' => 'ios-skipforward-outline'),
         array('ionicons ion-ios-snowy' => 'ios-snowy'),
         array('ionicons ion-ios-speedometer' => 'ios-speedometer'),
         array('ionicons ion-ios-speedometer-outline' => 'ios-speedometer-outline'),
         array('ionicons ion-ios-star' => 'ios-star'),
         array('ionicons ion-ios-star-half' => 'ios-star-half'),
         array('ionicons ion-ios-star-outline' => 'ios-star-outline'),
         array('ionicons ion-ios-stopwatch' => 'ios-stopwatch'),
         array('ionicons ion-ios-stopwatch-outline' => 'ios-stopwatch-outline'),
         array('ionicons ion-ios-sunny' => 'ios-sunny'),
         array('ionicons ion-ios-sunny-outline' => 'ios-sunny-outline'),
         array('ionicons ion-ios-telephone' => 'ios-telephone'),
         array('ionicons ion-ios-telephone-outline' => 'ios-telephone-outline'),
         array('ionicons ion-ios-tennisball' => 'ios-tennisball'),
         array('ionicons ion-ios-tennisball-outline' => 'ios-tennisball-outline'),
         array('ionicons ion-ios-thunderstorm' => 'ios-thunderstorm'),
         array('ionicons ion-ios-thunderstorm-outline' => 'ios-thunderstorm-outline'),
         array('ionicons ion-ios-time' => 'ios-time'),
         array('ionicons ion-ios-time-outline' => 'time-outline'),
         array('ionicons ion-ios-timer' => 'ios-timer'),
         array('ionicons ion-ios-timer-outline' => 'ios-timer-outline'),
         array('ionicons ion-ios-toggle' => 'ios-toggle'),
         array('ionicons ion-ios-toggle-outline' => 'toggle-outline'),
         array('ionicons ion-ios-trash' => 'ios-trash'),
         array('ionicons ion-ios-trash-outline' => 'trash-outline'),
         array('ionicons ion-ios-undo' => 'ios-undo'),
         array('ionicons ion-ios-undo-outline' => 'ios-undo-outline'),
         array('ionicons ion-ios-unlocked' => 'ios-unlocked'),
         array('ionicons ion-ios-unlocked-outline' => 'ios-unlocked-outline'),
         array('ionicons ion-ios-upload' => 'ios-upload'),
         array('ionicons ion-ios-upload-outline' => 'ios-upload-outline'),
         array('ionicons ion-ios-videocam' => 'ios-videocam'),
         array('ionicons ion-ios-videocam-outline' => 'ios-videocam-outline'),
         array('ionicons ion-ios-volume-high' => 'ios-volume-high'),
         array('ionicons ion-ios-volume-low' => 'ios-volume-low'),
         array('ionicons ion-ios-wineglass' => 'ios-wineglass'),
         array('ionicons ion-ios-wineglass-outline' => 'ios-wineglass-outline'),
         array('ionicons ion-ios-world' => 'ios-world'),
         array('ionicons ion-ios-world-outline' => 'ios-world-outline'),
         array('ionicons ion-ipad' => 'ipad'),
         array('ionicons ion-iphone' => 'iphone'),
         array('ionicons ion-ipod' => 'ipod'),
         array('ionicons ion-jet' => 'jet'),
         array('ionicons ion-key' => 'key'),
         array('ionicons ion-knife' => 'knife'),
         array('ionicons ion-laptop' => 'laptop'),
         array('ionicons ion-leaf' => 'leaf'),
         array('ionicons ion-levels' => 'levels'),
         array('ionicons ion-lightbulb' => 'lightbulb'),
         array('ionicons ion-link' => 'link'),
         array('ionicons ion-load-a' => 'load-a'),
         array('ionicons ion-load-b' => 'load-b'),
         array('ionicons ion-load-c' => 'load-c'),
         array('ionicons ion-load-d' => 'load-d'),
         array('ionicons ion-location' => 'location'),
         array('ionicons ion-lock-combination' => 'lock-combination'),
         array('ionicons ion-locked' => 'locked'),
         array('ionicons ion-log-in' => 'log-in'),
         array('ionicons ion-log-out' => 'log-out'),
         array('ionicons ion-loop' => 'loop'),
         array('ionicons ion-magnet' => 'magnet'),
         array('ionicons ion-male' => 'male'),
         array('ionicons ion-man' => 'man'),
         array('ionicons ion-map' => 'map'),
         array('ionicons ion-medkit' => 'medkit'),
         array('ionicons ion-merge' => 'merge'),
         array('ionicons ion-mic-a' => 'mic-a'),
         array('ionicons ion-mic-b' => 'mic-b'),
         array('ionicons ion-mic-c' => 'mic-c'),
         array('ionicons ion-minus' => 'minus'),
         array('ionicons ion-minus-circled' => 'minus-circled'),
         array('ionicons ion-minus-round' => 'minus-round'),
         array('ionicons ion-model-s' => 'model-s'),
         array('ionicons ion-monitor' => 'monitor'),
         array('ionicons ion-more' => 'more'),
         array('ionicons ion-mouse' => 'mouse'),
         array('ionicons ion-music-note' => 'music-note'),
         array('ionicons ion-navicon' => 'navicon'),
         array('ionicons ion-navicon-round' => 'navicon-round'),
         array('ionicons ion-navigate' => 'navigate'),
         array('ionicons ion-network' => 'network'),
         array('ionicons ion-no-smoking' => 'no-smoking'),
         array('ionicons ion-nuclear' => 'nuclear'),
         array('ionicons ion-outlet' => 'outlet'),
         array('ionicons ion-paintbrush' => 'paintbrush'),
         array('ionicons ion-paintbucket' => 'paintbucket'),
         array('ionicons ion-paper-airplane' => 'paper-airplane'),
         array('ionicons ion-paperclip' => 'paperclip'),
         array('ionicons ion-pause' => 'pause'),
         array('ionicons ion-person' => 'person'),
         array('ionicons ion-person-add' => 'person-add'),
         array('ionicons ion-person-stalker' => 'person-stalker'),
         array('ionicons ion-pie-graph' => 'pie-graph'),
         array('ionicons ion-pin' => 'pin'),
         array('ionicons ion-pinpoint' => 'pinpoint'),
         array('ionicons ion-pizza' => 'pizza'),
         array('ionicons ion-plane' => 'plane'),
         array('ionicons ion-planet' => 'planet'),
         array('ionicons ion-play' => 'play'),
         array('ionicons ion-playstation' => 'playstation'),
         array('ionicons ion-plus' => 'plus'),
         array('ionicons ion-plus-circled' => 'plus-circled'),
         array('ionicons ion-plus-round' => 'plus-round'),
         array('ionicons ion-podium' => 'podium'),
         array('ionicons ion-pound' => 'pound'),
         array('ionicons ion-power' => 'power'),
         array('ionicons ion-pricetag' => 'pricetag'),
         array('ionicons ion-pricetags' => 'pricetags'),
         array('ionicons ion-printer' => 'printer'),
         array('ionicons ion-pull-request' => 'pull-request'),
         array('ionicons ion-qr-scanner' => 'qr-scanner'),
         array('ionicons ion-quote' => 'quote'),
         array('ionicons ion-radio-waves' => 'radio-waves'),
         array('ionicons ion-record' => 'record'),
         array('ionicons ion-refresh' => 'refresh'),
         array('ionicons ion-reply' => 'reply'),
         array('ionicons ion-reply-all' => 'reply-all'),
         array('ionicons ion-ribsofting-a' => 'ribsofting-a'),
         array('ionicons ion-ribsofting-b' => 'ribsofting-b'),
         array('ionicons ion-sad' => 'sad'),
         array('ionicons ion-sad-outline' => 'sad-outline'),
         array('ionicons ion-scissors' => 'scissors'),
         array('ionicons ion-search' => 'search'),
         array('ionicons ion-settings' => 'settings'),
         array('ionicons ion-share' => 'share'),
         array('ionicons ion-shuffle' => 'shuffle'),
         array('ionicons ion-skip-backward' => 'skip-backward'),
         array('ionicons ion-skip-forward' => 'skip-forward'),
         array('ionicons ion-social-android' => 'social-android'),
         array('ionicons ion-social-android-outline' => 'social-android-outline'),
         array('ionicons ion-social-angular' => 'social-angular'),
         array('ionicons ion-social-angular-outline' => 'social-angular-outline'),
         array('ionicons ion-social-apple' => 'social-apple'),
         array('ionicons ion-social-apple-outline' => 'social-apple-outline'),
         array('ionicons ion-social-bitcoin' => 'social-bitcoin'),
         array('ionicons ion-social-bitcoin-outline' => 'social-bitcoin-outline'),
         array('ionicons ion-social-buffer' => 'social-buffer'),
         array('ionicons ion-social-buffer-outline' => 'social-buffer-outline'),
         array('ionicons ion-social-chrome' => 'social-chrome'),
         array('ionicons ion-social-chrome-outline' => 'social-chrome-outline'),
         array('ionicons ion-social-codepen' => 'social-codepen'),
         array('ionicons ion-social-codepen-outline' => 'social-codepen-outline'),
         array('ionicons ion-social-css3' => 'social-css3'),
         array('ionicons ion-social-css3-outline' => 'social-css3-outline'),
         array('ionicons ion-social-designernews' => 'social-designernews'),
         array('ionicons ion-social-designernews-outline' => 'social-designernews-outline'),
         array('ionicons ion-social-dribbble' => 'social-dribbble'),
         array('ionicons ion-social-dribbble-outline' => 'social-dribbble-outline'),
         array('ionicons ion-social-dropbox' => 'social-dropbox'),
         array('ionicons ion-social-dropbox-outline' => 'social-dropbox-outline'),
         array('ionicons ion-social-euro' => 'social-euro'),
         array('ionicons ion-social-euro-outline' => 'social-euro-outline'),
         array('ionicons ion-social-facebook' => 'social-facebook'),
         array('ionicons ion-social-facebook-outline' => 'social-facebook-outline'),
         array('ionicons ion-social-foursquare' => 'social-foursquare'),
         array('ionicons ion-social-foursquare-outline' => 'social-foursquare-outline'),
         array('ionicons ion-social-freebsd-devil' => 'social-freebsd-devil'),
         array('ionicons ion-social-github' => 'social-github'),
         array('ionicons ion-social-github-outline' => 'social-github-outline'),
         array('ionicons ion-social-google' => 'social-google'),
         array('ionicons ion-social-google-outline' => 'social-google-outline'),
         array('ionicons ion-social-googleplus' => 'social-googleplus'),
         array('ionicons ion-social-googleplus-outline' => 'social-googleplus-outline'),
         array('ionicons ion-social-hackernews' => 'social-hackernews'),
         array('ionicons ion-social-hackernews-outline' => 'social-hackernews-outline'),
         array('ionicons ion-social-html5' => 'social-html5'),
         array('ionicons ion-social-html5-outline' => 'social-html5-outline'),
         array('ionicons ion-social-instagram' => 'social-instagram'),
         array('ionicons ion-social-instagram-outline' => 'social-instagram-outline'),
         array('ionicons ion-social-javascript' => 'social-javascript'),
         array('ionicons ion-social-javascript-outline' => 'social-javascript-outline'),
         array('ionicons ion-social-linkedin' => 'social-linkedin'),
         array('ionicons ion-social-linkedin-outline' => 'social-linkedin-outline'),
         array('ionicons ion-social-markdown' => 'social-markdown'),
         array('ionicons ion-social-nodejs' => 'social-nodejs'),
         array('ionicons ion-social-octocat' => 'social-octocat'),
         array('ionicons ion-social-pinterest' => 'social-pinterest'),
         array('ionicons ion-social-pinterest-outline' => 'social-pinterest-outline'),
         array('ionicons ion-social-python' => 'social-python'),
         array('ionicons ion-social-reddit' => 'social-reddit'),
         array('ionicons ion-social-reddit-outline' => 'social-reddit-outline'),
         array('ionicons ion-social-rss' => 'social-rss'),
         array('ionicons ion-social-rss-outline' => 'social-rss-outline'),
         array('ionicons ion-social-sass' => 'social-sass'),
         array('ionicons ion-social-skype' => 'social-skype'),
         array('ionicons ion-social-skype-outline' => 'social-skype-outline'),
         array('ionicons ion-social-snapchat' => 'social-snapchat'),
         array('ionicons ion-social-snapchat-outline' => 'social-snapchat-outline'),
         array('ionicons ion-social-tumblr' => 'social-tumblr'),
         array('ionicons ion-social-tumblr-outline' => 'social-tumblr-outline'),
         array('ionicons ion-social-tux' => 'social-tux'),
         array('ionicons ion-social-twitch' => 'social-twitch'),
         array('ionicons ion-social-twitch-outline' => 'social-twitch-outline'),
         array('ionicons ion-social-twitter' => 'social-twitter'),
         array('ionicons ion-social-twitter-outline' => 'social-twitter-outline'),
         array('ionicons ion-social-usd' => 'social-usd'),
         array('ionicons ion-social-usd-outline' => 'social-usd-outline'),
         array('ionicons ion-social-vimeo' => 'social-vimeo'),
         array('ionicons ion-social-vimeo-outline' => 'social-vimeo-outline'),
         array('ionicons ion-social-whatsapp' => 'social-whatsapp'),
         array('ionicons ion-social-whatsapp-outline' => 'social-whatsapp-outline'),
         array('ionicons ion-social-windows' => 'social-windows'),
         array('ionicons ion-social-windows-outline' => 'social-windows-outline'),
         array('ionicons ion-social-wordpress' => 'social-wordpress'),
         array('ionicons ion-social-wordpress-outline' => 'social-wordpress-outline'),
         array('ionicons ion-social-yahoo' => 'social-yahoo'),
         array('ionicons ion-social-yahoo-outline' => 'social-yahoo-outline'),
         array('ionicons ion-social-yen' => 'social-yen'),
         array('ionicons ion-social-yen-outline' => 'social-yen-outline'),
         array('ionicons ion-social-youtube' => 'social-youtube'),
         array('ionicons ion-social-youtube-outline' => 'social-youtube-outline'),
         array('ionicons ion-soup-can' => 'soup-can'),
         array('ionicons ion-soup-can-outline' => 'soup-can-outline'),
         array('ionicons ion-speakerphone' => 'speakerphone'),
         array('ionicons ion-speedometer' => 'speedometer'),
         array('ionicons ion-spoon' => 'spoon'),
         array('ionicons ion-star' => 'star'),
         array('ionicons ion-stats-bars' => 'stats-bars'),
         array('ionicons ion-steam' => 'steam'),
         array('ionicons ion-stop' => 'stop'),
         array('ionicons ion-thermometer' => 'thermometer'),
         array('ionicons ion-thumbsdown' => 'thumbsdown'),
         array('ionicons ion-thumbsup' => 'thumbsup'),
         array('ionicons ion-toggle' => 'toggle'),
         array('ionicons ion-toggle-filled' => 'toggle-filled'),
         array('ionicons ion-transgender' => 'transgender'),
         array('ionicons ion-trash-a' => 'trash-a'),
         array('ionicons ion-trash-b' => 'trash-b'),
         array('ionicons ion-trophy' => 'trophy'),
         array('ionicons ion-tshirt' => 'tshirt'),
         array('ionicons ion-tshirt-outline' => 'tshirt-outline'),
         array('ionicons ion-umbrella' => 'umbrella'),
         array('ionicons ion-university' => 'university'),
         array('ionicons ion-unlocked' => 'unlocked'),
         array('ionicons ion-upload' => 'upload'),
         array('ionicons ion-usb' => 'usb'),
         array('ionicons ion-videocamera' => 'videocamera'),
         array('ionicons ion-volume-high' => 'volume-high'),
         array('ionicons ion-volume-low' => 'volume-low'),
         array('ionicons ion-volume-medium' => 'volume-medium'),
         array('ionicons ion-volume-mute' => 'volume-mute'),
         array('ionicons ion-wand' => 'wand'),
         array('ionicons ion-waterdrop' => 'waterdrop'),
         array('ionicons ion-wifi' => 'wifi'),
         array('ionicons ion-wineglass' => 'wineglass'),
         array('ionicons ion-woman' => 'woman'),
         array('ionicons ion-wrench' => 'wrench'),
         array('ionicons ion-xbox' => 'xbox'),
		);
	}
	add_filter( 'vc_iconpicker-type-ionicons', 'softing_icon_array' );
	// Add new custom font to Font Family selection in icon box module
	function softing_add_flaticon( ) {
		$param = WPBMap::getParam( 'vc_icon', 'type' );
		$param['value'][__( 'Flaticon', 'softing' )] = 'flaticon';
		vc_update_shortcode_param( 'vc_icon', $param );
	}
	add_filter( 'init', 'softing_add_flaticon', 40 );
	// Add font picker setting to icon box module when you select your font family from the dropdown
	function softing_add_font_flaticon_picker() {
		vc_add_param( 'vc_icon', array(
			'type' => 'iconpicker',
			'weight' => 1,
			'heading' => esc_html__( 'Icon', 'softing' ),
			'param_name' => 'icon_flaticon',
			'settings' => array(
				'emptyIcon' => false,
				'type' => 'flaticon',
				'iconsPerPage' => 200,
			),
			'dependency' => array(
				'element' => 'type',
				'value' => 'flaticon',
			),
		) );
	}
	add_filter( 'vc_after_init', 'softing_add_font_flaticon_picker', 40 );
	function softing_flaticonicon_array() {
		return array(
		array('flaticon-align' => 'align'),
		array('flaticon-align-1' => 'align-1'),
		array('flaticon-anchor' => 'anchor'),
		array('flaticon-background' => 'background'),
		array('flaticon-background-1' => 'background-1'),
		array('flaticon-background-2' => 'background-2'),
		array('flaticon-bounding-box' => 'bounding-box'),
		array('flaticon-brush' => 'brush'),
		array('flaticon-bucket' => 'bucket'),
		array('flaticon-bucket-1' => 'bucket-1'),
		array('flaticon-center-align' => 'center-align'),
		array('flaticon-center-alignment' => 'center-alignment'),
		array('flaticon-center-alignment-1' => 'center-alignment-1'),
		array('flaticon-circle' => 'circle'),
		array('flaticon-circular' => 'circular'),
		array('flaticon-column' => 'column'),
		array('flaticon-cone' => 'cone'),
		array('flaticon-constraint' => 'constraint'),
		array('flaticon-coordinates' => 'coordinates'),
		array('flaticon-crop' => 'crop'),
		array('flaticon-crop-1' => 'crop-1'),
		array('flaticon-cube' => 'cube'),
		array('flaticon-cube-1' => 'cube-1'),
		array('flaticon-cube-2' => 'cube-2'),
		array('flaticon-cube-3' => 'cube-3'),
		array('flaticon-cube-4' => 'cube-4'),
		array('flaticon-cube-5' => 'cube-5'),
		array('flaticon-cursor' => 'cursor'),
		array('flaticon-cursor-1' => 'cursor-1'),
		array('flaticon-cursor-2' => 'cursor-2'),
		array('flaticon-customer-support' => 'customer-support'),
		array('flaticon-cylinder' => 'cylinder'),
		array('flaticon-distort' => 'distort'),
		array('flaticon-distort-1' => 'distort-1'),
		array('flaticon-divide' => 'divide'),
		array('flaticon-edit' => 'edit'),
		array('flaticon-edit-1' => 'edit-1'),
		array('flaticon-edit-2' => 'edit-2'),
		array('flaticon-edit-3' => 'edit-3'),
		array('flaticon-edit-4' => 'edit-4'),
		array('flaticon-edit-corner' => 'edit-corner'),
		array('flaticon-exclude' => 'exclude'),
		array('flaticon-eyedropper' => 'eyedropper'),
		array('flaticon-eyedropper-1' => 'eyedropper-1'),
		array('flaticon-flatten' => 'flatten'),
		array('flaticon-flip' => 'flip'),
		array('flaticon-flip-1' => 'flip-1'),
		array('flaticon-foreground' => 'foreground'),
		array('flaticon-grids' => 'grids'),
		array('flaticon-group' => 'group'),
		array('flaticon-intersection' => 'intersection'),
		array('flaticon-joint' => 'joint'),
		array('flaticon-left-alignment' => 'left-alignment'),
		array('flaticon-left-alignment-1' => 'left-alignment-1'),
		array('flaticon-left-alignment-2' => 'left-alignment-2'),
		array('flaticon-merge' => 'merge'),
		array('flaticon-mirror-horizontally' => 'mirror-horizontally'),
		array('flaticon-mirror-horizontally-1' => 'mirror-horizontally-1'),
		array('flaticon-move' => 'move'),
		array('flaticon-outline' => 'outline'),
		array('flaticon-oval' => 'oval'),
		array('flaticon-oval-1' => 'oval-1'),
		array('flaticon-oval-2' => 'oval-2'),
		array('flaticon-paint-palette' => 'paint-palette'),
		array('flaticon-pen' => 'pen'),
		array('flaticon-pen-1' => 'pen-1'),
		array('flaticon-perspective' => 'perspective'),
		array('flaticon-polygon' => 'polygon'),
		array('flaticon-right-alignment' => 'right-alignment'),
		array('flaticon-right-alignment-1' => 'right-alignment-1'),
		array('flaticon-right-alignment-2' => 'right-alignment-2'),
		array('flaticon-rotate' => 'rotate'),
		array('flaticon-rotate-1' => 'rotate-1'),
		array('flaticon-row' => 'row'),
		array('flaticon-ruler' => 'ruler'),
		array('flaticon-ruler-1' => 'ruler-1'),
		array('flaticon-scale' => 'scale'),
		array('flaticon-select' => 'select'),
		array('flaticon-sent' => 'sent'),
		array('flaticon-sent-1' => 'sent-1'),
		array('flaticon-shapes' => 'shapes'),
		array('flaticon-shapes-1' => 'shapes-1'),
		array('flaticon-spiral' => 'spiral'),
		array('flaticon-spray' => 'spray'),
		array('flaticon-square' => 'square'),
		array('flaticon-square-1' => 'square-1'),
		array('flaticon-square-10' => 'square-10'),
		array('flaticon-square-11' => 'square-11'),
		array('flaticon-square-12' => 'square-12'),
		array('flaticon-square-13' => 'square-13'),
		array('flaticon-square-14' => 'square-14'),
		array('flaticon-square-15' => 'square-15'),
		array('flaticon-square-16' => 'square-16'),
		array('flaticon-square-17' => 'square-17'),
		array('flaticon-square-18' => 'square-18'),
		array('flaticon-square-19' => 'square-19'),
		array('flaticon-square-2' => 'square-2'),
		array('flaticon-square-20' => 'square-20'),
		array('flaticon-square-21' => 'square-21'),
		array('flaticon-square-22' => 'square-22'),
		array('flaticon-square-23' => 'square-23'),
		array('flaticon-square-24' => 'square-24'),
		array('flaticon-square-25' => 'square-25'),
		array('flaticon-square-26' => 'square-26'),
		array('flaticon-square-27' => 'square-27'),
		array('flaticon-square-3' => 'square-3'),
		array('flaticon-square-4' => 'square-4'),
		array('flaticon-square-5' => 'square-5'),
		array('flaticon-square-6' => 'square-6'),
		array('flaticon-square-7' => 'square-7'),
		array('flaticon-square-8' => 'square-8'),
		array('flaticon-square-9' => 'square-9'),
		array('flaticon-tile' => 'tile'),
		array('flaticon-tile-1' => 'tile-1'),
		array('flaticon-transform' => 'transform'),
		array('flaticon-triangle' => 'triangle'),
		array('flaticon-triangle-1' => 'triangle-1'),
		array('flaticon-trim' => 'trim'),
		array('flaticon-unconstrained' => 'unconstrained'),
		array('flaticon-ungroup' => 'ungroup'),
		array('flaticon-unite' => 'unite'),
		array('flaticon-vector' => 'vector'),
		array('flaticon-vector-1' => 'vector-1'),
		array('flaticon-vector-2' => 'vector-2'),
		array('flaticon-vector-3' => 'vector-3'),
		array('flaticon-vertical-alignment' => 'vertical-alignment'),
		array('flaticon-vertical-alignment-1' => 'vertical-alignment-1'),
		array('flaticon-vertical-alignment-2' => 'vertical-alignment-2'),
		array('flaticon-vertical-alignment-3' => 'vertical-alignment-3'),
		array('flaticon-vertical-alignment-4' => 'vertical-alignment-4'),
		array('flaticon-vertical-alignment-5' => 'vertical-alignment-5'),
		array('flaticon-vertical-alignment-6' => 'vertical-alignment-6'),
		array('flaticon-scroll' => 'scroll'),
		array('flaticon-feature' => 'feature'),
		array('flaticon-intersect' => 'intersect'),
		array('flaticon-union' => 'union'),
		array('flaticon-rgb' => 'rgb'),
		array('flaticon-rgb-1' => 'rgb-1'),
		array('flaticon-resolution' => 'resolution'),
		array('flaticon-showcase' => 'showcase'),
		array('flaticon-tickets' => 'tickets'),
		array('flaticon-ticket' => 'ticket'),
		array('flaticon-conversation' => 'conversation'),
		array('flaticon-speech-bubble' => 'speech-bubble'),
		array('flaticon-email' => 'email'),
		array('flaticon-contact' => 'contact'),
		array('flaticon-file' => 'file'),
		array('flaticon-upload-information' => 'upload-information'),
		);
	}
	add_filter( 'vc_iconpicker-type-flaticon', 'softing_flaticonicon_array' );

	/**  Register Backend and Frontend CSS Styles */
	add_action( 'vc_base_register_front_css', 'softing_vc_iconpicker_base_register_css' );
	add_action( 'vc_base_register_admin_css', 'softing_vc_iconpicker_base_register_css' );
	function softing_vc_iconpicker_base_register_css(){
    wp_register_style('ionicons', get_template_directory_uri() . '/css/ionicons.min.css');
    wp_register_style('flaticon', get_template_directory_uri() . '/css/flaticon.css');
    wp_register_style('fontawesome', get_template_directory_uri() . '/css/font-awesome.min.css');
	}

	/** Enqueue Backend and Frontend CSS Styles  */
	add_action( 'vc_backend_editor_enqueue_js_css', 'softing_vc_iconpicker_editor_jscss' );
	add_action( 'vc_frontend_editor_enqueue_js_css', 'softing_vc_iconpicker_editor_jscss' );
	function softing_vc_iconpicker_editor_jscss(){
    wp_enqueue_style('fontawesome');
    wp_enqueue_style( 'ionicons' );
    wp_enqueue_style( 'flaticon' );
	}

	/**  Enqueue CSS in Frontend when it's used  */
	add_action('vc_enqueue_font_icon_element', 'softing_enqueue_font_ionicons');
	function softing_enqueue_font_ionicons($font){
        switch ($font) {
            case 'fontaweome':
                wp_enqueue_style('fontawesome');
                break;
            case 'ionicons':
                wp_enqueue_style('ionicons');
                break;
            case 'flaticon':
            wp_enqueue_style('flaticon');
        }
	}
