<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $css
 * @var $el_id
 * @var $equal_height
 * @var $content_placement
 * @var $content - shortcode content
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Row_Inner
 */
$el_class = $equal_height = $content_placement = $css = $el_id = '';

//extra inner_row atts
$softing_row_prepad = $softing_lg_bgpos = $softing_lg_custom_bgpos = $softing_md_bgpos = $softing_md_custom_bgpos = $softing_sm_bgpos = $softing_sm_custom_bgpos = $softing_xs_bgpos = $softing_xs_custom_bgpos = $softing_md_hidebg = $softing_sm_hidebg = $softing_xs_hidebg = $softing_md_css = $softing_sm_css = $softing_xs_css = '';
//extra inner_row atts

$disable_element = '';
$output = $after_output = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$el_class = $this->getExtraClass( $el_class );
$css_classes = array(
	'row',
	$softing_row_prepad,
	$el_class,
	vc_shortcode_custom_css_class( $css ),
);

if ( 'yes' === $disable_element ) {
	if ( vc_is_page_editable() ) {
		$css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
	} else {
		return '';
	}
}

if ( vc_shortcode_custom_css_has_property( $css, array(
	'border',
	'background',
) ) ) {
	$css_classes[] = 'vc_row-has-fill';
}

if ( ! empty( $atts['gap'] ) ) {
	$css_classes[] = 'vc_column-gap-' . $atts['gap'];
}

if ( ! empty( $equal_height ) ) {
	$flex_row = true;
	$css_classes[] = 'vc_row-o-equal-height';
}

if ( ! empty( $content_placement ) ) {
	$flex_row = true;
	$css_classes[] = 'vc_row-o-content-' . $content_placement;
}

if ( ! empty( $flex_row ) ) {
	$css_classes[] = 'vc_row-flex';
}

$wrapper_attributes = array();
// build attributes for wrapper
if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
}

//craete uniq class for row data css
$softing_inrow_data_unique_class = 'nt_column_1541'.mt_rand(15, 1000000000);
//add to custom css function
$softing_inrow_data = softing_vc_extra_css($atts, $softing_inrow_data_unique_class, $softing_inrow_extra = '');
$softing_inrow_class = $softing_inrow_data != '' ? $softing_inrow_data_unique_class : '';
$css_classes[] = $softing_inrow_data != '' ? $softing_inrow_class.' nt_inner_row-has-responsive-data' : '';


$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( array_unique( $css_classes ) ) ), $this->settings['base'], $atts ) );
$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';

$output .= '<div ' . implode( ' ', $wrapper_attributes ) . $softing_inrow_data .'>';
$output .= wpb_js_remove_wpautop( $content );
$output .= '</div>';
$output .= $after_output;

echo softing_vc_sanitize_data( $output );
