<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $source
 * @var $image
 * @var $custom_src
 * @var $onclick
 * @var $img_size
 * @var $external_img_size
 * @var $caption
 * @var $img_link_large
 * @var $link
 * @var $img_link_target
 * @var $alignment
 * @var $el_class
 * @var $css_animation
 * @var $style
 * @var $external_style
 * @var $border_color
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Single_image
 */
$title = $source = $image = $custom_src = $onclick = $img_size = $external_img_size =
$caption = $img_link_large = $link = $img_link_target = $alignment = $el_class = $css_animation = $style = $external_style = $border_color = $css = '';

//extra vc_single_image atts
$softing_img_title = $softing_hover_style = $res_img_md_aling = $res_img_sm_aling = $res_img_xs_aling = $softing_maxwidth = $softing_img_op = $softing_img_hvr_op = $softing_img_overlay = $softing_img_trans = $softing_lg_bgpos = $softing_md_bgpos = $softing_sm_bgpos = $softing_xs_bgpos =  $softing_md_hidebg = $softing_sm_hidebg = $softing_xs_hidebg = $softing_md_css = $softing_sm_css = $softing_xs_css = '';
$md_custom_media = $md_custom_css_media = $sm_custom_media = $sm_custom_css_media = $xs_custom_media = $xs_custom_css_media = '';
//extra vc_single_image atts

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$default_src = vc_asset_url( 'vc/no_image.png' );

// backward compatibility. since 4.6
if ( empty( $onclick ) && isset( $img_link_large ) && 'yes' === $img_link_large ) {
	$onclick = 'img_link_large';
} elseif ( empty( $atts['onclick'] ) && ( ! isset( $atts['img_link_large'] ) || 'yes' !== $atts['img_link_large'] ) ) {
	$onclick = 'custom_link';
}

if ( 'external_link' === $source ) {
	$style = $external_style;
	$border_color = $external_border_color;
}

$border_color = ( '' !== $border_color ) ? ' vc_box_border_' . $border_color : '';

$img = false;

switch ( $source ) {
	case 'media_library':
	case 'featured_image':

		if ( 'featured_image' === $source ) {
			$post_id = get_the_ID();
			if ( $post_id && has_post_thumbnail( $post_id ) ) {
				$img_id = get_post_thumbnail_id( $post_id );
			} else {
				$img_id = 0;
			}
		} else {
			$img_id = preg_replace( '/[^\d]/', '', $image );
		}

		// set rectangular
		if ( preg_match( '/_circle_2$/', $style ) ) {
			$style = preg_replace( '/_circle_2$/', '_circle', $style );
			$img_size = $this->getImageSquareSize( $img_id, $img_size );
		}

		if ( ! $img_size ) {
			$img_size = 'medium';
		}

		$img = wpb_getImageBySize( array(
			'attach_id' => $img_id,
			'thumb_size' => $img_size,
			'class' => 'vc_single_image-img',
		) );

		// don't show placeholder in public version if post doesn't have featured image
		if ( 'featured_image' === $source ) {
			if ( ! $img && 'page' === vc_manager()->mode() ) {
				return;
			}
		}

		break;

	case 'external_link':
		$dimensions = vcExtractDimensions( $external_img_size );
		$hwstring = $dimensions ? image_hwstring( $dimensions[0], $dimensions[1] ) : '';

		$custom_src = $custom_src ? esc_attr( $custom_src ) : $default_src;

		$img = array(
			'thumbnail' => '<img class="vc_single_image-img" ' . $hwstring . ' src="' . $custom_src . '" />',
		);
		break;

	default:
		$img = false;
}

if ( ! $img ) {
	$img['thumbnail'] = '<img class="vc_img-placeholder vc_single_image-img" src="' . $default_src . '" />';
}

$el_class = $this->getExtraClass( $el_class );

// backward compatibility
if ( vc_has_class( 'prettyphoto', $el_class ) ) {
	$onclick = 'link_image';
}

// backward compatibility. will be removed in 4.7+
if ( ! empty( $atts['img_link'] ) ) {
	$link = $atts['img_link'];
	if ( ! preg_match( '/^(https?\:\/\/|\/\/)/', $link ) ) {
		$link = 'http://' . $link;
	}
}

// backward compatibility
if ( in_array( $link, array( 'none', 'link_no' ) ) ) {
	$link = '';
}

$a_attrs = array();

switch ( $onclick ) {
	case 'img_link_large':

		if ( 'external_link' === $source ) {
			$link = $custom_src;
		} else {
			$link = wp_get_attachment_image_src( $img_id, 'large' );
			$link = $link[0];
		}

		break;

	case 'link_image':
		wp_enqueue_script( 'prettyphoto' );
		wp_enqueue_style( 'prettyphoto' );

		$a_attrs['class'] = 'prettyphoto';
		$a_attrs['data-rel'] = 'prettyPhoto[rel-' . get_the_ID() . '-' . rand() . ']';

		// backward compatibility
		if ( vc_has_class( 'prettyphoto', $el_class ) ) {
			// $link is already defined
		} elseif ( 'external_link' === $source ) {
			$link = $custom_src;
		} else {
			$link = wp_get_attachment_image_src( $img_id, 'large' );
			$link = $link[0];
		}

		break;

	case 'custom_link':
		// $link is already defined
		break;

	case 'zoom':
		wp_enqueue_script( 'vc_image_zoom' );

		if ( 'external_link' === $source ) {
			$large_img_src = $custom_src;
		} else {
			$large_img_src = wp_get_attachment_image_src( $img_id, 'large' );
			if ( $large_img_src ) {
				$large_img_src = $large_img_src[0];
			}
		}

		$img['thumbnail'] = str_replace( '<img ', '<img data-vc-zoom="' . $large_img_src . '" ', $img['thumbnail'] );

		break;

	case 'chocolat':
	wp_enqueue_script('softing-custom-lightbox');
	wp_enqueue_script('lightbox-plus-jquery');
	wp_enqueue_script('lightbox');

		$a_attrs['class'] = 'chocolat-image';

		break;

}

// backward compatibility
if ( vc_has_class( 'prettyphoto', $el_class ) ) {
	$el_class = vc_remove_class( 'prettyphoto', $el_class );
}

$wrapperClass = 'vc_single_image-wrapper ' . $style . ' ' . $border_color;


//custom code
if ( 'mfp' === $onclick ) {
	$large_img_src = wp_get_attachment_image_src( $img_id, 'full' );
	$softing_img_title = $softing_img_title != '' ?' title="'.$softing_img_title.'"' : '';
	$softing_img = '<a class="image-link" href="'.$large_img_src[0].'"'.$softing_img_title.'>' . $img['thumbnail'] . '</a>';
}else{
	$softing_img = $img['thumbnail'];
}
// custom code end

if ( $link ) {
	$a_attrs['href'] = $link;
	$a_attrs['target'] = $img_link_target;
	if ( ! empty( $a_attrs['class'] ) ) {
		$wrapperClass .= ' ' . $a_attrs['class'];
		unset( $a_attrs['class'] );
	}
	$html = '<a ' . vc_stringify_attributes( $a_attrs ) . ' class="' . $wrapperClass . '">' . $img['thumbnail'] . ' </a>';
} else {
	$html = '<div class="' . $wrapperClass . '"';if($softing_maxwidth != ''){$html .= ' style="max-width:'.esc_attr($softing_maxwidth).';"';}$html .= '>' . $softing_img . '</div>';
}



$class_to_filter = 'wpb_single_image wpb_content_element vc_align_' . $alignment . ' ' . $this->getCSSAnimation( $css_animation );
$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts );

if ( in_array( $source, array( 'media_library', 'featured_image' ) ) && 'yes' === $add_caption ) {
	$post = get_post( $img_id );
	$caption = $post->post_excerpt;
} else {
	if ( 'external_link' === $source ) {
		$add_caption = 'yes';
	}
}

if ( 'yes' === $add_caption && '' !== $caption ) {
	$html .= '<figcaption class="vc_figure-caption">' . esc_html( $caption ) . '</figcaption>';
}

//custom code start
$unique_img_class = 'nt_img_1541'.mt_rand(15, 1000000000);

//img extra css
$md_img_media = $md_custom_media == 'yes' && $md_custom_css_media != '' ? $md_custom_css_media : '@media (max-width: 992px)';
$sm_img_media = $sm_custom_media == 'yes' && $sm_custom_css_media != '' ? $sm_custom_css_media : '@media (max-width: 768px)';
$xs_img_media = $xs_custom_media == 'yes' && $xs_custom_css_media != '' ? $xs_custom_css_media : '@media (max-width: 576px)';
$hover_style = $softing_hover_style != '' ? esc_attr($softing_hover_style) : '';
$softing_img_extra = array();
$softing_img_extra[] = ($hover_style == 'has_opacity' && $softing_img_op != '') ? '.'.$unique_img_class.' .vc_single_image-wrapper{opacity:'.$softing_img_op.'!important;}' : '';
$softing_img_extra[] = ($hover_style == 'has_opacity' && $softing_img_hvr_op != '') ? '.'.$unique_img_class.' .vc_single_image-wrapper:hover{opacity:'.$softing_img_hvr_op.'!important;}' : '';
$softing_img_extra[] = ($hover_style == 'has_overlay' && $softing_img_overlay != '') ? '.'.$unique_img_class.' .vc_single_image-wrapper:before{background:'.$softing_img_overlay.'!important;}' : '';
$softing_img_extra[] = ($hover_style == 'has_transform' && $softing_img_trans != '') ?  '.'.$unique_img_class.' .vc_single_image-wrapper:hover{-webkit-transform:scale('.$softing_img_trans.')!important;-ms-transform:scale('.$softing_img_trans.')!important;transform:scale('.$softing_img_trans.')!important;}' : '';
$softing_img_extra[] = $res_img_md_aling != '' ? $md_img_media.' {.'.$unique_img_class.'{text-align:'.$res_img_md_aling.'!important;}}' : '';
$softing_img_extra[] = $res_img_sm_aling != '' ? $sm_img_media.' {.'.$unique_img_class.'{text-align:'.$res_img_sm_aling.'!important;}}' : '';
$softing_img_extra[] = $res_img_xs_aling != '' ? $xs_img_media.' {.'.$unique_img_class.'{text-align:'.$res_img_xs_aling.'!important;}}' : '';

$softing_class_to_extra = ($hover_style == 'has_opacity' && $softing_img_hvr_op != '') ? 'has_opacity' : '';
$softing_class_to_extra .= ($hover_style == 'has_overlay' && $softing_img_overlay != '') ? 'has_overlay' : '';
$softing_class_to_extra .= ($hover_style == 'has_transform' && $softing_img_trans != '') ?  'has_transform' : '';

//add to custom css function
$softing_img_data = softing_vc_extra_css($atts, $unique_img_class, $softing_img_extra);
$unique_img_class= $softing_img_data != '' ? $unique_img_class.' nt_single_image-has-responsive-data' : '';
$output = '
	<div class="'.$unique_img_class.' ' . esc_attr( trim( $css_class ) ). ' '.$softing_class_to_extra.'"'.$softing_img_data.'>
		' . wpb_widget_title( array( 'title' => $title, 'extraclass' => 'wpb_singleimage_heading' ) ) . '
		<figure class="wpb_wrapper vc_figure">
			' . $html . '
		</figure>
	</div>
';

echo softing_vc_sanitize_data( $output );
