<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.6.0
 */

    get_header();

    do_action("softing_before_woo_shop_page");

    $active = is_active_sidebar( 'shop-page-sidebar' );
    $shop_layout = softing_settings( 'shop_layout', 'right-sidebar' );
    $container_width = softing_settings( 'shop_container_width', '' );
    $res_column = '';
    $res_column .= softing_settings( 'shop_md_column' ) ? ' res-md-col-'.softing_settings( 'shop_md_column' ) : '';
    $res_column .= softing_settings( 'shop_sm_column' ) ? ' res-sm-col-'.softing_settings( 'shop_sm_column' ) : '';
?>

<!-- Woo shop page general div -->
<div id="nt-shop-page" class="nt-shop-page<?php echo esc_attr( $res_column ); ?>">

    <!-- Hero section - this function using on all inner pages -->
    <?php softing_woo_hero_section(); ?>

    <div class="nt-theme-inner-container section-padding">
        <div class="container<?php echo esc_attr( $container_width ); ?>">
            <div class="row">

                <!-- Left sidebar -->
                <?php if ( 'left-sidebar' == $shop_layout && is_active_sidebar( 'shop-page-sidebar' ) ) {
                    echo '<div id="nt-sidebar" class="col-lg-3">';
                        dynamic_sidebar( 'shop-page-sidebar' );
                    echo '</div>';
                } ?>

                <!-- Sidebar none -->
                <?php if ( ( 'left-sidebar' == $shop_layout || 'right-sidebar' == $shop_layout ) && is_active_sidebar( 'shop-page-sidebar' ) ) { ?>
                    <div class="col-lg-9">
                    <?php } else { ?>
                    <div class="col-lg-12">
                    <?php } ?>

                        <?php
                        woocommerce_content();
                        softing_index_loop_pagination();
                        ?>

                    </div>
                    <!-- End sidebar + content -->

                    <!-- Right sidebar -->

                    <?php if( 'right-sidebar' == $shop_layout && is_active_sidebar( 'shop-page-sidebar' ) ) {
                        echo '<div id="nt-sidebar" class="col-lg-3">';
                            dynamic_sidebar( 'shop-page-sidebar' );
                        echo '</div>';
                    } ?>

                </div><!-- End row -->
            </div><!-- End container -->
        </div><!-- End #blog -->
    </div><!-- End woo shop page general div -->

<?php

    do_action("softing_after_woo_shop_page");

    get_footer();

?>
