<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

if ( class_exists( 'Redux' ) && class_exists( 'WooCommerce' ) ) {

    if ( ! function_exists( 'softing_dynamic_section' ) ) {
        function softing_dynamic_section($sections)
        {

            global $softing_pre;

            /*************************************************
            ## SINGLE PAGE SECTION
            *************************************************/
            // create sections in the theme options
            $sections[] = array(
                'title' => esc_html__('Shop Page', 'softing'),
                'id' => 'shopsection',
                'icon' => 'el el-shopping-cart-sign',
            );
            // SHOP PAGE SECTION
            $sections[] = array(
                'title' => esc_html__( 'Shop Page Layout', 'softing' ),
                'id' => 'shoplayoutsection',
                'subsection'=> true,
                'icon' => 'el el-website',
                'fields'	=> array(
                    array(
                        'title' => esc_html__( 'Shop Page Layout', 'softing' ),
                        'subtitle' => esc_html__( 'Choose the shop page layout.', 'softing' ),
                        'id' => 'shop_layout',
                        'type' => 'image_select',
                        'options' => array(
                            'left-sidebar' => array(
                                'alt' => 'Left Sidebar',
                                'img' => ReduxFramework::$_url . 'assets/img/2cl.png'
                            ),
                            'full-width' => array(
                                'alt' => 'Full Width',
                                'img' => ReduxFramework::$_url . 'assets/img/1col.png'
                            ),
                            'right-sidebar' => array(
                                'alt' => 'Right Sidebar',
                                'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                            ),
                        ),
                        'default' => 'right-sidebar'
                    )
                )
            );

            // SINGLE HERO SUBSECTION
            $sections[] = array(
                'title' => esc_html__('Shop Page Hero', 'softing'),
                'desc' => esc_html__('These are shop page hero section settings', 'softing'),
                'id' => 'shopherosubsection',
                'subsection' => true,
                'icon' => 'el el-brush',
                'fields' => array(
                    array(
                        'title' => esc_html__('Shop Hero display', 'softing'),
                        'subtitle' => esc_html__('You can enable or disable the site shop page hero section with switch option.', 'softing'),
                        'id' => 'shop_hero_visibility',
                        'type' => 'switch',
                        'default' => 1,
                        'on' => 'On',
                        'off' => 'Off',
                    ),
                    array(
                        'title' => esc_html__( 'Shop Hero Template', 'softing' ),
                        'subtitle' => esc_html__( 'Select your header template.', 'softing' ),
                        'id' => 'shop_hero_template',
                        'type' => 'select',
                        'customizer' => true,
                        'options' => array(
                            'default' => esc_html__( 'Deafult Site Hero', 'softing' ),
                            'elementor' => esc_html__( 'Elementor Templates', 'softing' ),
                        ),
                        'default' => 'default',
                        'required' => array( 'shop_hero_visibility', '=', '1' )
                    ),

                    array(
                        'title' => esc_html__('Shop Page Hero Alignment', 'softing'),
                        'subtitle' => esc_html__('Select shop page hero text alignment.', 'softing'),
                        'id' => 'shop_hero_alignment',
                        'type' => 'select',
                        'customizer' => true,
                        'options' => array(
                            '' => esc_html__('Select alignment', 'softing'),
                            'text-right' => esc_html__('right', 'softing'),
                            'text-center' => esc_html__('center', 'softing'),
                            'text-left' => esc_html__('left', 'softing'),
                        ),
                        'default' => 'text-center',
                        'required' => array(
                            array( 'shop_hero_visibility', '=', '1' ),
                            array( 'shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__('Shop Page Hero Background', 'softing'),
                        'id' => 'shop_hero_bg',
                        'type' => 'background',
                        'output' => array( '#nt-shop-page .page-header' ),
                        'required' => array(
                            array( 'shop_hero_visibility', '=', '1' ),
                            array( 'shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__( 'Hero Image Overlay Color', 'softing' ),
                        'id' => 'shop_hero_overlay',
                        'type' => 'color_rgba',
                        'mode' => 'background-color',
                        'options'=> array(
                            'show_input' => true,
                            'show_initial' => true,
                            'show_alpha' => true,
                            'show_palette' => true,
                            'show_palette_only' => false,
                            'show_selection_palette' => true,
                            'max_palette_size' => 10,
                            'allow_empty' => true,
                            'clickout_fires_change' => false,
                            'choose_text' => 'Choose',
                            'cancel_text' => 'Cancel',
                            'show_buttons' => true,
                            'use_extended_classes' => true,
                            'palette' => null,
                        ),
                        'output' => array( '#nt-shop-page .page-header.hero-overlay:before' ),
                        'required' => array(
                            array( 'shop_hero_visibility', '=', '1' ),
                            array( 'shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__('Shop Page Hero Padding', 'softing'),
                        'subtitle' => esc_html__('You can set the top spacing of the site shop page Hero Section', 'softing'),
                        'id' =>'shop_hero_pad',
                        'type' => 'spacing',
                        'output' => array('#nt-shop-page .page-header'),
                        'mode' => 'padding',
                        'units' => array('em', 'px'),
                        'units_extended' => 'false',
                        'default' => array(
                            'padding-top' => '',
                            'padding-right' => '',
                            'padding-bottom' => '',
                            'padding-left' => '',
                            'units' => 'px',
                        ),
                        'required' => array(
                            array( 'shop_hero_visibility', '=', '1' ),
                            array( 'shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__('Shop Page Title', 'softing'),
                        'subtitle' => esc_html__('Add your shop page title here.', 'softing'),
                        'id' => 'shop_title',
                        'type' => 'text',
                        'default' => 'Shop',
                        'required' => array(
                            array( 'shop_hero_visibility', '=', '1' ),
                            array( 'shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__('Shop Page Title Typography', 'softing'),
                        'id' => 'shop_title_typo',
                        'type' => 'typography',
                        'font-backup' => false,
                        'letter-spacing' => true,
                        'text-transform' => true,
                        'all_styles' => true,
                        'output' => array( '#nt-shop-page .nt-hero-title' ),
                        'units' => 'px',
                        'default' => array(
                            'color' => '',
                            'font-style' => '',
                            'font-family' => '',
                            'google' => true,
                            'font-size' => '',
                            'line-height' => ''
                        ),
                        'required' => array(
                            array( 'shop_hero_visibility', '=', '1' ),
                            array( 'shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__('Shop Page Slogan', 'softing'),
                        'subtitle' => esc_html__('Add your shop page slogan here.', 'softing'),
                        'id' => 'shop_slogan',
                        'type' => 'textarea',
                        'default' => '',
                        'required' => array(
                            array( 'shop_hero_visibility', '=', '1' ),
                            array( 'shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__('Slogan Typography', 'softing'),
                        'id' => 'shop_slogan_typo',
                        'type' => 'typography',
                        'font-backup' => false,
                        'letter-spacing' => true,
                        'text-transform' => true,
                        'all_styles' => true,
                        'output' => array( '#nt-shop-page .nt-hero-subtitle' ),
                        'default' => array(
                            'color' => '',
                            'font-style' => '',
                            'font-family' => '',
                            'google' => true,
                            'font-size' => '',
                            'line-height' => ''
                        ),
                        'required' => array(
                            array( 'shop_hero_visibility', '=', '1' ),
                            array( 'shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__('Shop Page Description', 'softing'),
                        'subtitle' => esc_html__('Add your shop page description here.', 'softing'),
                        'id' => 'shop_desc',
                        'type' => 'textarea',
                        'default' => '',
                        'required' => array(
                            array( 'shop_hero_visibility', '=', '1' ),
                            array( 'shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__('Description Typography', 'softing'),
                        'id' => 'shop_desc_typo',
                        'type' => 'typography',
                        'font-backup' => false,
                        'letter-spacing' => true,
                        'text-transform' => true,
                        'all_styles' => true,
                        'output' => array( '#nt-shop-page .nt-hero-description' ),
                        'default' => array(
                            'color' => '',
                            'font-style' => '',
                            'font-family' => '',
                            'google' => true,
                            'font-size' => '',
                            'line-height' => ''
                        ),
                        'required' => array(
                            array( 'shop_hero_visibility', '=', '1' ),
                            array( 'shop_hero_template', '=', 'default' )
                        )
                    )
                )
            );
            // SINGLE CONTENT SUBSECTION
            $sections[] = array(
                'title' => esc_html__('Shop Page Content', 'softing'),
                'id' => 'shopcontentsubsection',
                'subsection' => true,
                'icon' => 'el el-brush',
                'fields' => array(
                    array(
                        'title' => esc_html__( 'Shop Page Container Width', 'softing' ),
                        'subtitle' => esc_html__( 'Choose the shop page container width.', 'softing' ),
                        'id' => 'shop_container_width',
                        'type' => 'select',
                        'customizer' => true,
                        'options' => array(
                            '' => esc_html__('Default ( Container )', 'softing'),
                            '-fluid' => esc_html__('Container Fluid', 'softing'),
                            '-off' => esc_html__('Full Width', 'softing'),
                        ),
                        'default' => '',
                    ),
                    array(
                        'title' => esc_html__('Shop Page Content Padding', 'softing'),
                        'subtitle' => esc_html__('You can set the top spacing of the site shop page content.', 'softing'),
                        'id' =>'shop_content_pad',
                        'type' => 'spacing',
                        'output' => array('#nt-shop-page .nt-theme-inner-container'),
                        'mode' => 'padding',
                        'units' => array('em', 'px'),
                        'units_extended' => 'false',
                        'default' => array(
                            'padding-top' => '',
                            'padding-right' => '',
                            'padding-bottom' => '',
                            'padding-left' => '',
                            'units' => 'px'
                        )
                    ),
                    array(
                        'title' => esc_html__('Shop Post Column', 'softing'),
                        'subtitle' => esc_html__('You can control post column with this option.', 'softing'),
                        'id' => 'shop_column',
                        'type' => 'slider',
                        'default' => 3,
                        'min' => 1,
                        'step' => 1,
                        'max' => 4,
                        'display_value' => 'text',
                    ),
                    array(
                        'title' => esc_html__('Shop Post 992px Column ( Responsive: Desktop, Tablet )', 'softing'),
                        'subtitle' => esc_html__('You can control post column on max-device width 992px with this option.', 'softing'),
                        'id' => 'shop_md_column',
                        'type' => 'slider',
                        'default' =>'',
                        'min' => 1,
                        'step' => 1,
                        'max' => 3,
                        'display_value' => 'text',
                    ),
                    array(
                        'title' => esc_html__('Shop Post 768px Column ( Responsive: Tablet, Phone )', 'softing'),
                        'subtitle' => esc_html__('You can control post column on max-device-width 768px with this option.', 'softing'),
                        'id' => 'shop_sm_column',
                        'type' => 'slider',
                        'default' =>'',
                        'min' => 1,
                        'step' => 1,
                        'max' => 2,
                        'display_value' => 'text',
                    ),
                    array(
                        'title' => esc_html__('Shop Post Count', 'softing'),
                        'subtitle' => esc_html__('You can control show post count with this option.', 'softing'),
                        'id' => 'shop_perpage',
                        'type' => 'slider',
                        'default' => 6,
                        'min' => 1,
                        'step' => 1,
                        'max' => 100,
                        'display_value' => 'text'
                    )
                )
            );

            $sections[] = array(
                'title' => esc_html__('Shop Page Post Style', 'softing'),
                'id' => 'shoppoststylesubsection',
                'subsection' => true,
                'icon' => 'el el-brush',
                'fields' => array(
                    array(
                        'title' => esc_html__('Post Color Style', 'softing'),
                        'subtitle' => esc_html__('Select your color.', 'softing'),
                        'id' => 'shop_theme_color',
                        'type' => 'select',
                        'customizer' => true,
                        'options' => array(
                            'default' => esc_html__('Default', 'softing'),
                            '1' => esc_html__('Blue', 'softing'),
                            '2' => esc_html__('Orange', 'softing'),
                            '3' => esc_html__('Indigo', 'softing'),
                            '4' => esc_html__('Sunglow', 'softing'),
                            '5' => esc_html__('Cerise Red', 'softing'),
                            '6' => esc_html__('Mantis', 'softing'),
                            'custom' => esc_html__('Custom Color', 'softing')
                        ),
                        'default' => '1',
                    ),
                    array(
                        'title' => esc_html__('Custom Color', 'softing'),
                        'subtitle' => esc_html__('Change post color.', 'softing'),
                        'id' => 'shop_custom_color',
                        'type' => 'color',
                        'default' => '#30aafc',
                        'required' => array( 'shop_theme_color', '=', 'custom' )
                    ),
                    // post button ( view cart )
                    array(
                        'title' => esc_html__('Post Background Color', 'softing'),
                        'subtitle' => esc_html__('Change post background color.', 'softing'),
                        'id' => 'shop_post_bgcolor',
                        'type' => 'color',
                        'mode' => 'background-color',
                        'default' => '',
                        'output' => array('.woocommerce ul.products li.product .product-content-wrap, .woocommerce-page ul.products li.product .product-content-wrap')
                    ),
                    array(
                        'title' => esc_html__('Post Border', 'softing'),
                        'subtitle' => esc_html__('Set your custom border styles for the posts.', 'softing'),
                        'id' => 'shop_post_brd',
                        'type' => 'border',
                        'all' => false,
                        'output' => array('.woocommerce ul.products li.product .product-content-wrap, .woocommerce-page ul.products li.product .product-content-wrap')
                    ),
                    array(
                        'title' => esc_html__('Post Padding', 'softing'),
                        'subtitle' => esc_html__('You can set the top spacing of the site shop page post.', 'softing'),
                        'id' =>'shop_post_pad',
                        'type' => 'spacing',
                        'output' => array('.woocommerce ul.products li.product .product-content-wrap, .woocommerce-page ul.products li.product .product-content-wrap'),
                        'mode' => 'padding',
                        'units' => array('em', 'px'),
                        'units_extended' => 'false',
                        'default' => array(
                            'units' => 'px'
                        )
                    ),
                    array(
                        'title' => esc_html__('Post Margin', 'softing'),
                        'subtitle' => esc_html__('You can set the top spacing of the site shop page post.', 'softing'),
                        'id' =>'shop_post_margin',
                        'type' => 'spacing',
                        'output' => array('.woocommerce ul.products li.product .product-content-wrap, .woocommerce-page ul.products li.product .product-content-wrap'),
                        'mode' => 'margin',
                        'units' => array('em', 'px'),
                        'units_extended' => 'false',
                        'default' => array(
                            'units' => 'px'
                        )
                    ),
                    // post itle
                    array(
                        'title' => esc_html__('Shop Loop Post Title Typography', 'softing'),
                        'id' => 'shop_post_title_typo',
                        'type' => 'typography',
                        'font-backup' => false,
                        'letter-spacing' => true,
                        'text-transform' => true,
                        'all_styles' => true,
                        'output' => array( '.woocommerce ul.products li.product .woocommerce-loop-product__title' ),
                        'units' => 'px',
                        'default' => array(
                            'color' => '',
                            'font-style' => '',
                            'font-family' => '',
                            'google' => true,
                            'font-size' => '',
                            'line-height' => ''
                        )
                    ),
                    array(
                        'title' => esc_html__('Shop Loop Post Title Padding', 'softing'),
                        'subtitle' => esc_html__('You can set the top spacing of the site shop page post title.', 'softing'),
                        'id' =>'shop_post_title_pad',
                        'type' => 'spacing',
                        'output' => array('.woocommerce ul.products li.product .woocommerce-loop-product__title'),
                        'mode' => 'padding',
                        'units' => array('em', 'px'),
                        'units_extended' => 'false',
                        'default' => array(
                            'padding-top' => '',
                            'padding-right' => '',
                            'padding-bottom' => '',
                            'padding-left' => '',
                            'units' => 'px'
                        )
                    ),
                    array(
                        'title' => esc_html__('Shop Loop Post Title Margin', 'softing'),
                        'subtitle' => esc_html__('You can set the top spacing of the site shop page post title.', 'softing'),
                        'id' =>'shop_post_title_margin',
                        'type' => 'spacing',
                        'output' => array('.woocommerce ul.products li.product .woocommerce-loop-product__title'),
                        'mode' => 'margin',
                        'units' => array('em', 'px'),
                        'units_extended' => 'false',
                        'default' => array(
                            'padding-top' => '',
                            'padding-right' => '',
                            'padding-bottom' => '',
                            'padding-left' => '',
                            'units' => 'px'
                        )
                    ),
                    array(
                        'title' => esc_html__('Shop Loop Post Price Typography', 'softing'),
                        'id' => 'shop_post_price_typo',
                        'type' => 'typography',
                        'font-backup' => false,
                        'letter-spacing' => true,
                        'text-transform' => true,
                        'all_styles' => true,
                        'output' => array( '.woocommerce ul.products li.product .price' ),
                        'units' => 'px',
                        'default' => array(
                            'color' => '',
                            'font-style' => '',
                            'font-family' => '',
                            'google' => true,
                            'font-size' => '',
                            'line-height' => ''
                        )
                    ),
                    array(
                        'title' => esc_html__('Shop Loop Post Price Padding', 'softing'),
                        'subtitle' => esc_html__('You can set the top spacing of the site shop page post title.', 'softing'),
                        'id' =>'shop_post_price_pad',
                        'type' => 'spacing',
                        'output' => array('.woocommerce ul.products li.product .price'),
                        'mode' => 'padding',
                        'units' => array('em', 'px'),
                        'units_extended' => 'false',
                        'default' => array(
                            'units' => 'px'
                        )
                    ),
                    array(
                        'title' => esc_html__('Shop Loop Post Price Margin', 'softing'),
                        'subtitle' => esc_html__('You can set the top spacing of the site shop page post title.', 'softing'),
                        'id' =>'shop_post_price_margin',
                        'type' => 'spacing',
                        'output' => array('.woocommerce ul.products li.product .price'),
                        'mode' => 'margin',
                        'units' => array('em', 'px'),
                        'units_extended' => 'false',
                        'default' => array(
                            'units' => 'px'
                        )
                    ),
                    // post button ( Add to cart )
                    array(
                        'title' => esc_html__('Button Background ( Add to cart )', 'softing'),
                        'subtitle' => esc_html__('Change theme main color.', 'softing'),
                        'id' => 'shop_addtocartbtn_bgcolor',
                        'type' => 'color',
                        'mode' => 'background-color',
                        'default' => '',
                        'output' => array('.woocommerce ul.products li.product .button, .woocommerce.single-product .entry-summary button.button.alt')
                    ),
                    array(
                        'title' => esc_html__('Hover Button Background ( Add to cart )', 'softing'),
                        'subtitle' => esc_html__('Change theme main color.', 'softing'),
                        'id' => 'shop_addtocartbtn_hvrbgcolor',
                        'type' => 'color',
                        'mode' => 'background-color',
                        'default' => '',
                        'output' => array('.woocommerce ul.products li.product .button:hover, .woocommerce.single-product .entry-summary button.button.alt:hover')
                    ),
                    array(
                        'title' => esc_html__('Button Title ( Add to cart )', 'softing'),
                        'subtitle' => esc_html__('Change theme main color.', 'softing'),
                        'id' => 'shop_addtocartbtn_color',
                        'type' => 'color',
                        'default' => '',
                        'output' => array('.woocommerce ul.products li.product .button, .woocommerce.single-product .entry-summary button.button.alt')
                    ),
                    array(
                        'title' => esc_html__('Hover Button Title ( Add to cart )', 'softing'),
                        'subtitle' => esc_html__('Change theme main color.', 'softing'),
                        'id' => 'shop_addtocartbtn_hvrcolor',
                        'type' => 'color',
                        'default' => '',
                        'output' => array('.woocommerce ul.products li.product .button:hover, .woocommerce.single-product .entry-summary button.button.alt:hover')
                    ),
                    array(
                        'title' => esc_html__('Button Border ( Add to cart )', 'softing'),
                        'subtitle' => esc_html__('Change theme main color.', 'softing'),
                        'id' => 'shop_addtocartbtn_brd',
                        'type' => 'border',
                        'output' => array('.woocommerce ul.products li.product .button, .woocommerce.single-product .entry-summary button.button.alt')
                    ),
                    array(
                        'title' => esc_html__('Hover Button Border ( Add to cart )', 'softing'),
                        'subtitle' => esc_html__('Change theme main color.', 'softing'),
                        'id' => 'shop_addtocartbtn_hvrbrd',
                        'type' => 'border',
                        'output' => array('.woocommerce ul.products li.product .button:hover, .woocommerce.single-product .entry-summary button.button.alt:hover')
                    ),
                    // post button ( view cart )
                    array(
                        'title' => esc_html__('Button Background ( View cart )', 'softing'),
                        'subtitle' => esc_html__('Change button background color.', 'softing'),
                        'id' => 'shop_viewcartbtn_bgcolor',
                        'type' => 'color',
                        'mode' => 'background-color',
                        'default' => '',
                        'output' => array('.woocommerce a.added_to_cart')
                    ),
                    array(
                        'title' => esc_html__('Hover Button Background ( View cart )', 'softing'),
                        'subtitle' => esc_html__('Change button hover background color.', 'softing'),
                        'id' => 'shop_viewcartbtn_hvrbgcolor',
                        'type' => 'color',
                        'mode' => 'background-color',
                        'default' => '',
                        'output' => array('.woocommerce a.added_to_cart')
                    ),
                    array(
                        'title' => esc_html__('Button Title ( View cart )', 'softing'),
                        'subtitle' => esc_html__('Change button title color.', 'softing'),
                        'id' => 'shop_viewcartbtn_color',
                        'type' => 'color',
                        'default' => '',
                        'output' => array('.woocommerce a.added_to_cart')
                    ),
                    array(
                        'title' => esc_html__('Hover Button Title ( View cart )', 'softing'),
                        'subtitle' => esc_html__('Change button hover title color.', 'softing'),
                        'id' => 'shop_viewcartbtn_hvrcolor',
                        'type' => 'color',
                        'default' => '',
                        'output' => array('.woocommerce a.added_to_cart')
                    ),
                    array(
                        'title' => esc_html__('Button Border ( View cart )', 'softing'),
                        'subtitle' => esc_html__('Change hover button border style.', 'softing'),
                        'id' => 'shop_viewcartbtn_brd',
                        'type' => 'border',
                        'output' => array('.woocommerce a.added_to_cart')
                    ),
                    array(
                        'title' => esc_html__('Hover Button Border ( View cart )', 'softing'),
                        'subtitle' => esc_html__('Change hover button border style.', 'softing'),
                        'id' => 'shop_viewcartbtn_hvrbrd',
                        'type' => 'border',
                        'output' => array('.woocommerce a.added_to_cart')
                    ),
                    array(
                        'title' => esc_html__('Buttons Padding', 'softing'),
                        'subtitle' => esc_html__('You can set the top spacing of the site shop page post buttons.', 'softing'),
                        'id' =>'shop_postbtn_pad',
                        'type' => 'spacing',
                        'output' => array('.woocommerce ul.products li.product .button,.woocommerce a.added_to_cart'),
                        'mode' => 'padding',
                        'units' => array('em', 'px'),
                        'units_extended' => 'false',
                        'default' => array(
                            'units' => 'px'
                        )
                    ),
                    array(
                        'title' => esc_html__('Buttons Margin', 'softing'),
                        'subtitle' => esc_html__('You can set the top spacing of the site shop page post buttons.', 'softing'),
                        'id' =>'shop_postbtn_margin',
                        'type' => 'spacing',
                        'output' => array('.woocommerce ul.products li.product .button,.woocommerce a.added_to_cart'),
                        'mode' => 'margin',
                        'units' => array('em', 'px'),
                        'units_extended' => 'false',
                        'default' => array(
                            'units' => 'px'
                        )
                    ),
                    array(
                        'title' => esc_html__('Sale Label Background Color', 'softing'),
                        'subtitle' => esc_html__('Change sale label background color.', 'softing'),
                        'id' => 'shop_sale_bgcolor',
                        'type' => 'color',
                        'mode' => 'background',
                        'default' => '',
                        'output' => array('.woocommerce span.onsale,.woocommerce ul.products li.product .onsale, .woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle')
                    ),
                    array(
                        'title' => esc_html__('Sale Label Text Color', 'softing'),
                        'subtitle' => esc_html__('Change sale label text color.', 'softing'),
                        'id' => 'shop_sale_color',
                        'type' => 'color',
                        'default' => '',
                        'output' => array('.woocommerce span.onsale,.woocommerce ul.products li.product .onsale')
                    ),
                    array(
                        'title' => esc_html__('Pagination Background Color', 'softing'),
                        'subtitle' => esc_html__('Change shop page pagination background color.', 'softing'),
                        'id' => 'shop_pagination_bgcolor',
                        'type' => 'color',
                        'mode' => 'background',
                        'default' => '',
                        'output' => array('.woocommerce .nt-pagination .nt-pagination-inner .nt-pagination-item .nt-pagination-link')
                    ),
                    array(
                        'title' => esc_html__('Active Pagination Background Color', 'softing'),
                        'subtitle' => esc_html__('Change shop page pagination hover and active item background color.', 'softing'),
                        'id' => 'shop_pagination_hvrbgcolor',
                        'type' => 'color',
                        'mode' => 'background',
                        'default' => '',
                        'output' => array('.woocommerce .nt-pagination .nt-pagination-inner .nt-pagination-item.active .nt-pagination-link')
                    ),
                    array(
                        'title' => esc_html__('Pagination Text Color', 'softing'),
                        'subtitle' => esc_html__('Change shop page pagination text color.', 'softing'),
                        'id' => 'shop_pagination_color',
                        'type' => 'color',
                        'default' => '',
                        'output' => array('.woocommerce .nt-pagination .nt-pagination-inner .nt-pagination-item .nt-pagination-link')
                    ),
                    array(
                        'title' => esc_html__('Active Pagination Text Color', 'softing'),
                        'subtitle' => esc_html__('Change shop page pagination hover and active item text color.', 'softing'),
                        'id' => 'shop_pagination_hvrcolor',
                        'type' => 'color',
                        'default' => '',
                        'output' => array('.woocommerce .nt-pagination .nt-pagination-inner .nt-pagination-item.active .nt-pagination-link')
                    ),
                    array(
                        'title' => esc_html__('Pagination Border', 'softing'),
                        'subtitle' => esc_html__('Change pagination item border style.', 'softing'),
                        'id' => 'shop_pagination_brd',
                        'type' => 'border',
                        'output' => array('.woocommerce .nt-pagination .nt-pagination-inner .nt-pagination-item .nt-pagination-link')
                    ),
                    array(
                        'title' => esc_html__('Active Pagination Border', 'softing'),
                        'subtitle' => esc_html__('Change pagination active item border style.', 'softing'),
                        'id' => 'shop_pagination_hvrbrd',
                        'type' => 'border',
                        'output' => array('.woocommerce .nt-pagination .nt-pagination-inner .nt-pagination-item.active .nt-pagination-link')
                    ),
                )
            );


            /*************************************************
            ## SINGLE PAGE SECTION
            *************************************************/
            // create sections in the theme options
            $sections[] = array(
                'title' => esc_html__('Shop Single Page', 'softing'),
                'id' => 'singleshopsection',
                'icon' => 'el el-shopping-cart-sign',
            );
            // SHOP PAGE SECTION
            $sections[] = array(
                'title' => esc_html__('General', 'softing'),
                'id' => 'singleshopgeneral',
                'subsection' => true,
                'icon' => 'el el-brush',
                'fields' => array(
                    array(
                        'title' => esc_html__( 'Single Page Layout', 'softing' ),
                        'subtitle' => esc_html__( 'Choose the single page layout.', 'softing' ),
                        'id' => 'single_shop_layout',
                        'type' => 'image_select',
                        'options' => array(
                            'left-sidebar' => array(
                                'alt' => 'Left Sidebar',
                                'img' => ReduxFramework::$_url . 'assets/img/2cl.png'
                            ),
                            'full-width' => array(
                                'alt' => 'Full Width',
                                'img' => ReduxFramework::$_url . 'assets/img/1col.png'
                            ),
                            'right-sidebar' => array(
                                'alt' => 'Right Sidebar',
                                'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                            ),
                        ),
                        'default' => 'right-sidebar'
                    ),
                    array(
                        'title' => esc_html__('Single Related Title', 'softing'),
                        'subtitle' => esc_html__('Add your single shop page related section title here.', 'softing'),
                        'id' => 'single_shop_related_title',
                        'type' => 'text',
                        'default' => 'Related Products'
                    ),
                    array(
                        'title' => esc_html__('Related Post Column', 'softing'),
                        'subtitle' => esc_html__('You can control related post column with this option.', 'softing'),
                        'id' => 'single_shop_related_column',
                        'type' => 'slider',
                        'default' => 3,
                        'min' => 1,
                        'step' => 1,
                        'max' => 4,
                        'display_value' => 'text'
                    ),
                    array(
                        'title' => esc_html__('Related Post Count', 'softing'),
                        'subtitle' => esc_html__('You can control show related post count with this option.', 'softing'),
                        'id' => 'single_shop_related_count',
                        'type' => 'slider',
                        'default' => 6,
                        'min' => 1,
                        'step' => 1,
                        'max' => 24,
                        'display_value' => 'text'
                    )
                )
            );
            // SINGLE HERO SUBSECTION
            $sections[] = array(
                'title' => esc_html__('Single Hero', 'softing'),
                'desc' => esc_html__('These are single page hero section settings!', 'softing'),
                'id' => 'singleshopherosubsection',
                'subsection' => true,
                'icon' => 'el el-brush',
                'fields' => array(
                    array(
                        'title' => esc_html__('Single Hero display', 'softing'),
                        'subtitle' => esc_html__('You can enable or disable the site single page hero section with switch option.', 'softing'),
                        'id' => 'single_shop_hero_visibility',
                        'type' => 'switch',
                        'default' => 1,
                        'on' => 'On',
                        'off' => 'Off',
                    ),
                    array(
                        'title' => esc_html__( 'Single Hero Template', 'softing' ),
                        'subtitle' => esc_html__( 'Select your header template.', 'softing' ),
                        'id' => 'single_shop_hero_template',
                        'type' => 'select',
                        'customizer' => true,
                        'options' => array(
                            'default' => esc_html__( 'Deafult Site Hero', 'softing' ),
                            'elementor' => esc_html__( 'Elementor Templates', 'softing' ),
                        ),
                        'default' => 'default',
                        'required' => array( 'single_shop_hero_visibility', '=', '1' )
                    ),

                    array(
                        'title' => esc_html__('Single Hero Alignment', 'softing'),
                        'subtitle' => esc_html__('Select single page hero text alignment.', 'softing'),
                        'id' => 'single_shop_hero_alignment',
                        'type' => 'select',
                        'customizer' => true,
                        'options' => array(
                            '' => esc_html__('Select alignment', 'softing'),
                            'text-right' => esc_html__('right', 'softing'),
                            'text-center' => esc_html__('center', 'softing'),
                            'text-left' => esc_html__('left', 'softing'),
                        ),
                        'default' => 'text-center',
                        'required' => array(
                            array( 'single_shop_hero_visibility', '=', '1' ),
                            array( 'single_shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__('Single Hero Background', 'softing'),
                        'id' => 'single_shop_hero_bg',
                        'type' => 'background',
                        'output' => array( '#nt-woo-single .page-header' ),
                        'required' => array(
                            array( 'single_shop_hero_visibility', '=', '1' ),
                            array( 'single_shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__('Single Hero Overlay Color', 'softing'),
                        'id' =>'single_shop_hero_overlay',
                        'type' => 'color_rgba',
                        'mode' => 'background',
                        'output' => array( '#nt-woo-single .page-header.hero-overlay:before' ),
                        'required' => array(
                            array( 'single_shop_hero_visibility', '=', '1' ),
                            array( 'single_shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__('Single Page Title', 'softing'),
                        'subtitle' => esc_html__('Add your single shop page title here.', 'softing'),
                        'id' => 'single_shop_title',
                        'type' => 'text',
                        'default' => '',
                        'required' => array(
                            array( 'single_shop_hero_visibility', '=', '1' ),
                            array( 'single_shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__('Single Title Typography', 'softing'),
                        'id' => 'single_shop_title_typo',
                        'type' => 'typography',
                        'font-backup' => false,
                        'letter-spacing' => true,
                        'text-transform' => true,
                        'all_styles' => true,
                        'output' => array( '#nt-woo-single .nt-hero-title' ),
                        'units' => 'px',
                        'default' => array(
                            'color' => '',
                            'font-style' => '',
                            'font-family' => '',
                            'google' => true,
                            'font-size' => '',
                            'line-height' => ''
                        ),
                        'required' => array(
                            array( 'single_shop_hero_visibility', '=', '1' ),
                            array( 'single_shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__('Single Slogan', 'softing'),
                        'subtitle' => esc_html__('Add your single page slogan here.', 'softing'),
                        'id' => 'single_shop_slogan',
                        'type' => 'textarea',
                        'default' => '',
                        'required' => array(
                            array( 'single_shop_hero_visibility', '=', '1' ),
                            array( 'single_shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__('Single Slogan Typography', 'softing'),
                        'id' => 'single_shop_slogan_typo',
                        'type' => 'typography',
                        'font-backup' => false,
                        'letter-spacing' => true,
                        'text-transform' => true,
                        'all_styles' => true,
                        'output' => array( '#nt-woo-single .nt-hero-subtitle' ),
                        'default' => array(
                            'color' => '',
                            'font-style' => '',
                            'font-family' => '',
                            'google' => true,
                            'font-size' => '',
                            'line-height' => ''
                        ),
                        'required' => array(
                            array( 'single_shop_hero_visibility', '=', '1' ),
                            array( 'single_shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__('Single Description', 'softing'),
                        'subtitle' => esc_html__('Add your single page description here.', 'softing'),
                        'id' => 'single_shop_desc',
                        'type' => 'textarea',
                        'default' => '',
                        'required' => array(
                            array( 'single_shop_hero_visibility', '=', '1' ),
                            array( 'single_shop_hero_template', '=', 'default' )
                        )
                    ),
                    array(
                        'title' => esc_html__('Single Description Typography', 'softing'),
                        'id' => 'single_shop_desc_typo',
                        'type' => 'typography',
                        'font-backup' => false,
                        'letter-spacing' => true,
                        'text-transform' => true,
                        'all_styles' => true,
                        'output' => array( '#nt-woo-single .nt-hero-description' ),
                        'default' => array(
                            'color' => '',
                            'font-style' => '',
                            'font-family' => '',
                            'google' => true,
                            'font-size' => '',
                            'line-height' => ''
                        ),
                        'required' => array(
                            array( 'single_shop_hero_visibility', '=', '1' ),
                            array( 'single_shop_hero_template', '=', 'default' )
                        )
                    )
                )
            );
            // SINGLE CONTENT SUBSECTION
            $sections[] = array(
                'title' => esc_html__('Single Content', 'softing'),
                'id' => 'singleshopcontentsubsection',
                'subsection' => true,
                'icon' => 'el el-brush',
                'fields' => array(
                    array(
                        'title' => esc_html__('Single Content Padding', 'softing'),
                        'subtitle' => esc_html__('You can set the top spacing of the site single page content.', 'softing'),
                        'id' =>'single_shop_content_pad',
                        'type' => 'spacing',
                        'output' => array('#nt-woo-single .nt-theme-inner-container'),
                        'mode' => 'padding',
                        'units' => array('em', 'px'),
                        'units_extended' => 'false',
                        'default' => array(
                            'padding-top' => '',
                            'padding-right' => '',
                            'padding-bottom' => '',
                            'padding-left' => '',
                            'units' => 'px'
                        )
                    )
                )
            );
            return $sections;
        }
        add_filter('redux/options/'.$softing_pre.'/sections', 'softing_dynamic_section');
    }
}

/*************************************************
## WOOCOMMERCE HERO FUNCTION
*************************************************/

if(! function_exists('softing_woo_hero_section')) {
    function softing_woo_hero_section()
    {

        if (class_exists( 'WooCommerce' )) {

            if (is_archive() || is_shop()) {
                $name = 'shop';
                $h_t  = '' != softing_settings('shop_title') ? softing_settings('shop_title') : '';
            } elseif (is_product()) { // blog and cpt archive page
                $name = 'single_shop';
                $h_t  = '' != softing_settings('single_shop_title') ? softing_settings('single_shop_title') : '';
            } else {
                $name = 'shop';
                $h_t  = 'Shop';
            }
            $has_bg = $bg_attr = '';
            $def_bg = ' default-bg';


            // page breadcrumbs
            $h_b = softing_settings('breadcrumbs_visibility', '0');
            // page hero text alignment
            $h_a = softing_settings($name.'_hero_alignment', 'text-center');
            // page hero background image overlay
            $h_o = softing_settings($name.'_hero_overlay') != '' ? ' hero-overlay': '';

            if ( '0' != softing_settings('shop_hero', '1')) {


                    echo '<div id="nt-hero" class="breadcrumb-area text-light bg-fixed padding-xl page-id-'.get_the_ID().' '. esc_attr($h_o) .$has_bg.$def_bg.'"'.$bg_attr.'>
                    <div class="container">
                    <div class="row">
                    <div class="col-sm-12">
                    <div class="cont-inner">
                    <div class="hero-innner-last-child">';

                    // page hero slogan
                    if ( '' != softing_settings($name.'_slogan')) {
                        echo '<h6 class="nt-hero-subtitle __subtitle">'.wp_kses(softing_settings($name.'_slogan'), softing_allowed_html()).'</h6>';
                    }

                    // page hero title
                    if ( $h_t ) {
                        echo '<h1 class="hero-title"><span>'.wp_kses($h_t, softing_allowed_html()).'</span></h1>';
                    } else {
                        echo '<h1 class="hero-title"><span>';
                        woocommerce_page_title();
                        echo '</span></h1>';
                    }

                    // page hero description
                    if ( '' != softing_settings($name.'_desc')) {
                        echo '<p class="hero-subtitle">'.wp_kses(softing_settings($name.'_desc'), softing_allowed_html()).'</p>';
                    }

                    // page breadcrumbs
                    if ( '1' == softing_settings('breadcrumbs_visibility', '0')) {
                        softing_breadcrumbs();
                    }

                    echo '</div><!-- End hero-innner-last-child -->
                    </div><!-- End hero-content -->
                    </div><!-- End column -->
                    </div><!-- End row -->
                    </div><!-- End container -->
                    </div><!-- End hero-container -->';

            } // hide hero area
        }
    }
}

if ( !function_exists( 'softing_after_shop_page' ) ) {
    function softing_after_shop_page() {
        if ( class_exists( '\Elementor\Frontend' ) ) {
            $template_id = softing_settings( 'shop_after_page_elementor_templates' );
            if ( !empty( $template_id ) ) {

                $frontend = new \Elementor\Frontend;
                printf( '%1$s', $frontend->get_builder_content( $template_id, false ) );

            }
        }
    }
    add_action('softing_after_woo_shop_page', 'softing_after_shop_page', 10);
}

/*************************************************
## ADD CUSTOM CSS FOR WOOCOMMERCE
*************************************************/


if ( !function_exists( 'softing_woo_scripts' ) ) {
    function softing_woo_scripts()
    {
        wp_enqueue_style( 'softing-woocommerce-custom', get_template_directory_uri() . '/woocommerce/woocommerce-custom.css',false, '1.0');
        wp_enqueue_script('softing-woocommerce-custom', get_template_directory_uri() . '/woocommerce/woocommerce-custom.js', array('jquery'), '1.0', true);
    }
    add_action( 'wp_enqueue_scripts', 'softing_woo_scripts' );
}


/*************************************************
## REMOVE WOOCOMMERCE DEFAULT PAGINATION
*************************************************/

remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 10 );


/*************************************************
## ADD THEME SUPPORT FOR WOOCOMMERCE
*************************************************/


function softing_woo_theme_setup() {

    add_theme_support( 'woocommerce'  );
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );

}
add_action( 'after_setup_theme', 'softing_woo_theme_setup' );


/*************************************************
## CHANGE NUMBER OF PRODUCTS PER ROW
*************************************************/

/**
* Change number of products that are displayed per page (shop page)
*/

if (!function_exists('softing_woo_shop_per_page')) {

    add_filter( 'loop_shop_per_page', 'softing_woo_shop_per_page', 20 );

    function softing_woo_shop_per_page( $cols ) {

        // $cols contains the current number of products per page based on the value stored on Options -> Reading
        // Return the number of products you wanna show per page.
        $cols = softing_settings('shop_perpage', '6');

        return $cols;

    }
}

/*************************************************
## CHANGE NUMBER OF PRODUCTS COLUMN
*************************************************/

/*************************************************
## CHANGE NUMBER OF PRODUCTS COLUMN
*************************************************/
/**
* Change number or products per row to 3
*/

if (!function_exists('softing_woo_loop_columns')) {

    add_filter('loop_shop_columns', 'softing_woo_loop_columns', 999);

    function softing_woo_loop_columns() {

        return softing_settings('shop_column', '3'); // 2 products per row

    }
}

/**
* Change number of related products output
*/
if (!function_exists('softing_woo_related_products_limit')) {

    add_filter( 'woocommerce_output_related_products_args', 'softing_woo_related_products_limit', 20 );
    function softing_woo_related_products_limit( $args ) {
        $args['posts_per_page'] = softing_settings('single_shop_related_count', '4'); // 4 related products
        $args['columns'] = softing_settings('single_shop_related_column', '1'); // arranged in 2 columns
        return $args;
    }
}

/*************************************************
## REGISTER SIDEBAR FOR WOOCOMMERCE
*************************************************/


if ( !function_exists( 'softing_woo_widgets_init' ) ) {
    function softing_woo_widgets_init() {
        //Shop page sidebar
        register_sidebar( array(
            'name' => esc_html__( 'Shop Page Sidebar', 'softing' ),
            'id' => 'shop-page-sidebar',
            'description' => esc_html__( 'These widgets for the Shop page.','softing' ),
            'before_widget' => '<div class="sidebar sidebar-widget widget mb-30 %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>'
        ) );
        //Single product sidebar
        register_sidebar( array(
            'name' => esc_html__( 'Shop Single Page Sidebar', 'softing' ),
            'id' => 'shop-single-sidebar',
            'description' => esc_html__( 'These widgets for the Shop Single page.','softing' ),
            'before_widget' => '<div class="sidebar sidebar-widget widget mb-30 %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>'
        ) );
    }
    add_action( 'widgets_init', 'softing_woo_widgets_init' );
}



/************************************************************
## ADD THEME CSS SETTINGS TO WOOCOMMERCE AND WP INLINE STYLE
*************************************************************/


if ( !function_exists( 'softing_woo_theme_css_options' ) ) {
    function softing_woo_theme_css_options() {

        /* CSS to output */

        $theCSS = '';

        $theCSS .= '.woocommerce .page-header.hero-overlay:before{
            content: "";
            position: absolute;
            width:100%;
            height:100%;
            top:0;
            left:0;
        }
        .page-header {
            position: relative;
        }';

        $shop_theme_color = softing_settings('shop_theme_color');
        if ( '1' != $shop_theme_color ) {
            $theme_color = $shop_theme_color;
            if ( '1' == $theme_color ) {
                $theme_color = '#30aafc';
            } elseif ( '2' == $theme_color ) {
                $theme_color = '#ff6833';
            } elseif ( '3' == $theme_color ) {
                $theme_color = '#341880';
            } elseif ( '4' == $theme_color || '8' == $theme_color ) {
                $theme_color = '#fccb30';
            } elseif ( '5' == $theme_color ) {
                $theme_color = '#db3a58';
            } elseif ( '6' == $theme_color ) {
                $theme_color = '#5ec05a';
            } elseif ( '7' == $theme_color ) {
                $theme_color = '#5b65bd';
            } elseif ( 'custom' == $theme_color ) {
                $theme_color = softing_settings('shop_custom_color');
            }

            // css color
            $theCSS .= '.product.t-left:hover p.paragraph, .woocommerce #reviews #comments ol.commentlist li .comment-text p.meta .woocommerce-review__published-date , .woocommerce-info::before, a.showcoupon,.woocommerce a.added_to_cart, .woocommerce div.product p.price, .woocommerce div.product span.price, .nt-sidebar .product_list_widget ins .woocommerce-Price-amount.amount { color: '.$theme_color.'; }';
            //css border color
            $theCSS .= '.woocommerce-account .woocommerce-MyAccount-content p a, .woocommerce-error, .woocommerce-info, .woocommerce-message, .woocommerce div.product.sale div.images.woocommerce-product-gallery, .woocommerce div.product .woocommerce-tabs ul.tabs li a:hover, .woocommerce div.product .woocommerce-tabs ul.tabs li.active a, .woocommerce-Address-title .edit {border-color:'.$theme_color.';}';
            $theCSS .= '.stack-title a:hover, .woocommerce div.product .woocommerce-tabs ul.tabs li a:hover, .woocommerce div.product .woocommerce-tabs ul.tabs li.active a, .woocommerce a.added_to_cart, .woocommerce div.product .woocommerce-tabs ul.tabs li.active { border-color:' .$theme_color. '; }';
            //css background color
            $theCSS .= '.woocommerce span.onsale,.single-product .form-submit input#submit:hover,.woocommerce #respond input#submit:hover,.button:hover,.woocommerce button.button:hover,.woocommerce a.button:hover, .woocommerce a.added_to_cart:hover,.woocommerce.single-product .entry-summary button.button.alt, .woocommerce div.product .woocommerce-tabs ul.tabs li.active, .woocommerce .woocommerce-ordering .nice-select .option:hover,.nt-sidebar form.woocommerce-product-search button,.woocommerce .widget_price_filter .price_slider_amount .button,.woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle { background: '.$theme_color.';}';

            //theme button bg color
            $theCSS .= '.button, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .single-product .form-submit input#submit,a.add_to_cart_button,.single-product .form-submit input#submit:hover{ background-color:'. $theme_color .';border-color:'. $theme_color .'; } ';
            $theCSS .= '.button:hover,  .woocommerce .form-submit .button-slide, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .single-product .form-submit input#submit:hover, a.added_to_cart:hover, .woocommerce ul.products li.product .button{  border-color:'. $theme_color .'; }';

            //theme button title color
            $theCSS .= '.button,  .woocommerce .form-submit .button-slide:hover, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .single-product .form-submit input#submit, a.add_to_cart_button, .woocommerce a.added_to_cart:hover, .woocommerce .woocommerce-ordering .nice-select .option:hover{color:#fff;}';
            $theCSS .= '.button,  .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .single-product .form-submit input#submit:hover, a.added_to_cart:hover{ border-color:'. $theme_color .'; }';
            $theCSS .= '.woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle { background: '.$theme_color.';}';
        }
        /* Add CSS to softing-custom-style.css */
        wp_register_style( 'softing-woo-style', false );
        wp_enqueue_style( 'softing-woo-style' );
        wp_add_inline_style( 'softing-woo-style', $theCSS );

    }
    add_action( 'wp_enqueue_scripts', 'softing_woo_theme_css_options' );
}

add_filter( 'woocommerce_prevent_automatic_wizard_redirect', '__return_true' );

/*************************************************
## CUSTOM POST CLASS
*************************************************/

if (! function_exists('nt_softing_post_theme_class')) {
    function nt_softing_post_theme_class($classes)
    {

        if ( is_single() ) {
            $classes[] =  has_blocks() ? 'nt-single-has-block' : '';
        }

        return $classes;
    }
    add_filter('post_class', 'nt_softing_post_theme_class');
}
